/*
 * Decompiled with CFR 0.152.
 */
package io.chocorean.authmod.command;

import io.chocorean.authmod.AuthMod;
import io.chocorean.authmod.config.AuthModConfig;
import io.chocorean.authmod.event.Handler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.Logger;

public class LoggedCommand
implements ICommand {
    private static final Logger LOGGER = AuthMod.LOGGER;
    private final List<String> aliases;
    private final Handler handler;
    private final String no;
    private final String yes;

    public LoggedCommand(Handler handler) {
        this.handler = handler;
        this.aliases = new ArrayList<String>();
        this.aliases.add("logged?");
        this.yes = AuthModConfig.i18n.loggedYes;
        this.no = AuthModConfig.i18n.loggedNo;
    }

    public String func_71517_b() {
        return "logged";
    }

    public String func_71518_a(ICommandSender sender) {
        return AuthModConfig.i18n.loggedUsage;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        EntityPlayer player = (EntityPlayer)sender;
        LOGGER.info(String.format("%s is using /logged", player.getDisplayNameString()));
        boolean logged = this.handler.isLogged(player);
        sender.func_145747_a((ITextComponent)new TextComponentString(logged ? this.yes : this.no));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return new ArrayList<String>();
    }

    public boolean func_82358_a(String[] args, int index) {
        return true;
    }

    public int compareTo(ICommand iCommand) {
        return this.func_71517_b().compareTo(iCommand.func_71517_b());
    }
}

