/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.Platform;
import java.util.Collections;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public abstract class ContainerFluidConfigurable
extends ContainerUpgradeable
implements IFluidSyncContainer {
    private FluidSyncHelper sync = null;

    public ContainerFluidConfigurable(InventoryPlayer ip, IUpgradeableHost te) {
        super(ip, te);
    }

    public abstract IAEFluidTank getFluidConfigInventory();

    private FluidSyncHelper getSynchHelper() {
        if (this.sync == null) {
            this.sync = new FluidSyncHelper(this.getFluidConfigInventory(), 0);
        }
        return this.sync;
    }

    @Override
    protected ItemStack transferStackToContainer(ItemStack input) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)input);
        if (fs != null) {
            IAEFluidTank t = this.getFluidConfigInventory();
            AEFluidStack stack = AEFluidStack.fromFluidStack(fs);
            for (int i = 0; i < t.getSlots(); ++i) {
                if (t.getFluidInSlot(i) != null || !this.isValidForConfig(i, stack)) continue;
                t.setFluidInSlot(i, stack);
                break;
            }
        }
        return input;
    }

    protected boolean isValidForConfig(int slot, IAEFluidStack fs) {
        if (this.supportCapacity()) {
            int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
            if (slot > 0 && upgrades < 1) {
                return false;
            }
            if (slot > 4 && upgrades < 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void standardDetectAndSendChanges() {
        if (Platform.isServer()) {
            this.getSynchHelper().sendDiff(this.field_75149_d);
            IAEFluidTank t = this.getFluidConfigInventory();
            for (int i = 0; i < t.getSlots(); ++i) {
                if (t.getFluidInSlot(i) == null || this.isValidForConfig(i, t.getFluidInSlot(i))) continue;
                t.setFluidInSlot(i, null);
            }
        }
        super.standardDetectAndSendChanges();
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.getSynchHelper().sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        this.getSynchHelper().readPacket(fluids);
    }
}

