/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import com.supermartijn642.core.extensions.RegistrySimpleExtension;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.util.MappedSetView;
import com.supermartijn642.core.util.Pair;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public final class Registries {
    static final Map<ResourceLocation, Registry<?>> IDENTIFIER_TO_REGISTRY = new HashMap();
    static final Map<IRegistry<ResourceLocation, ?>, Registry<?>> VANILLA_REGISTRY_MAP = new HashMap();
    static final Map<IForgeRegistry<?>, Registry<?>> FORGE_REGISTRY_MAP = new HashMap();
    static final Map<Registry<?>, List<Registry<?>>> REGISTRATION_ORDER_MAP = new HashMap();
    public static final Registry<Block> BLOCKS = Registries.forge(Block.field_149771_c, ForgeRegistries.BLOCKS, Block.class);
    public static final Registry<Fluid> FLUIDS = new FluidRegistryWrapper();
    public static final Registry<Item> ITEMS = new ForgeRegistryWrapper<Item>((IRegistry)Item.field_150901_e, ForgeRegistries.ITEMS, Item.class){

        @Override
        public void register(ResourceLocation identifier, Item object) {
            super.register(identifier, object);
            if (CommonUtils.getEnvironmentSide().isClient()) {
                ClientRegistrationHandler.setItemCustomModelLocation(object);
            }
        }
    };
    public static final Registry<Potion> MOB_EFFECTS = Registries.forge(Potion.field_188414_b, ForgeRegistries.POTIONS, Potion.class);
    public static final Registry<SoundEvent> SOUND_EVENTS = Registries.forge(SoundEvent.field_187505_a, ForgeRegistries.SOUND_EVENTS, SoundEvent.class);
    public static final Registry<PotionType> POTIONS = Registries.forge(PotionType.field_185176_a, ForgeRegistries.POTION_TYPES, PotionType.class);
    public static final Registry<Enchantment> ENCHANTMENTS = Registries.forge(Enchantment.field_185264_b, ForgeRegistries.ENCHANTMENTS, Enchantment.class);
    public static final Registry<EntityEntry> ENTITY_TYPES = Registries.forge(null, ForgeRegistries.ENTITIES, EntityEntry.class);
    public static final Registry<BaseBlockEntityType<?>> BLOCK_ENTITY_TYPES = new MapBackedRegistry(new ResourceLocation("supermartijn642corelib", "block_entity_types"), BaseBlockEntityType.class);
    public static final Registry<Class<? extends TileEntity>> BLOCK_ENTITY_CLASSES = Registries.vanilla(new ResourceLocation("block_entities"), TileEntity.field_190562_f, Class.class);
    public static final Registry<BaseContainerType<?>> MENU_TYPES = new MapBackedRegistry(new ResourceLocation("supermartijn642corelib", "container_types"), BaseContainerType.class);
    public static final Registry<IConditionFactory> RECIPE_CONDITION_SERIALIZERS = new RecipeConditionSerializerRegistry();
    public static final Registry<CustomTagEntrySerializer<?>> CUSTOM_TAG_ENTRY_SERIALIZERS = new MapBackedRegistry(new ResourceLocation("supermartijn642corelib", "custom_tag_entries"), CustomTagEntrySerializer.class);

    private static void addRegistry(Registry<?> registry) {
        if (IDENTIFIER_TO_REGISTRY.containsKey(registry.getRegistryIdentifier())) {
            throw new RuntimeException("Duplicate registry registration for identifier '" + registry.getRegistryIdentifier() + "'!");
        }
        if (registry.hasVanillaRegistry() && VANILLA_REGISTRY_MAP.containsKey(registry.getVanillaRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + registry.getValueClass() + "'!");
        }
        if (registry.hasForgeRegistry() && FORGE_REGISTRY_MAP.containsKey(registry.getForgeRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + registry.getValueClass() + "'!");
        }
        IDENTIFIER_TO_REGISTRY.put(registry.getRegistryIdentifier(), registry);
        if (registry.hasVanillaRegistry()) {
            VANILLA_REGISTRY_MAP.put(registry.getVanillaRegistry(), registry);
        }
        if (registry.hasForgeRegistry()) {
            FORGE_REGISTRY_MAP.put(registry.getForgeRegistry(), registry);
        }
    }

    @Deprecated
    public static void onRecipeConditionSerializerAdded(ResourceLocation identifier, IConditionFactory serializer) {
        ((RecipeConditionSerializerRegistry)RECIPE_CONDITION_SERIALIZERS).onObjectAdded(identifier, serializer);
    }

    @Deprecated
    public static <T> Registry<T> fromUnderlying(IRegistry<ResourceLocation, T> registry) {
        return VANILLA_REGISTRY_MAP.get(registry);
    }

    @Deprecated
    public static <T extends IForgeRegistryEntry<T>> Registry<T> fromUnderlying(IForgeRegistry<T> registry) {
        return FORGE_REGISTRY_MAP.get(registry);
    }

    public static Registry<?> getRegistry(ResourceLocation identifier) {
        return IDENTIFIER_TO_REGISTRY.get(identifier);
    }

    private static <T> Registry<T> vanilla(ResourceLocation identifier, IRegistry<ResourceLocation, T> registry, Class<? super T> valueClass) {
        return new VanillaRegistryWrapper(identifier, registry, valueClass);
    }

    private static <T extends IForgeRegistryEntry<T>> Registry<T> forge(IRegistry<ResourceLocation, ? extends T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
        return new ForgeRegistryWrapper(registry, forgeRegistry, valueClass);
    }

    static {
        ((RecipeConditionSerializerRegistry)Registries.RECIPE_CONDITION_SERIALIZERS).initializeMap();
        REGISTRATION_ORDER_MAP.put(ITEMS, Lists.newArrayList((Object[])new Registry[]{BLOCK_ENTITY_TYPES, BLOCK_ENTITY_CLASSES, FLUIDS}));
        REGISTRATION_ORDER_MAP.put(ENTITY_TYPES, Lists.newArrayList((Object[])new Registry[]{MENU_TYPES, CUSTOM_TAG_ENTRY_SERIALIZERS}));
    }

    private static class RecipeConditionSerializerRegistry
    implements Registry<IConditionFactory> {
        private static final Supplier<Map<ResourceLocation, IConditionFactory>> craftingHelperConditions;
        private static final ResourceLocation IDENTIFIER;
        private Map<ResourceLocation, IConditionFactory> identifierToObject;
        private final Map<IConditionFactory, ResourceLocation> objectToIdentifier = new HashMap<IConditionFactory, ResourceLocation>();
        private final Set<Pair<ResourceLocation, IConditionFactory>> entries = new HashSet<Pair<ResourceLocation, IConditionFactory>>();
        private final Class<IConditionFactory> valueClass = IConditionFactory.class;

        private RecipeConditionSerializerRegistry() {
        }

        private void initializeMap() {
            this.identifierToObject = craftingHelperConditions.get();
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return IDENTIFIER;
        }

        @Override
        @Nullable
        public IRegistry<ResourceLocation, IConditionFactory> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        @Nullable
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, IConditionFactory object) {
            if (this.identifierToObject.containsKey(identifier)) {
                throw new RuntimeException("Duplicate registry for identifier '" + identifier + "'!");
            }
            if (this.objectToIdentifier.containsKey(object)) {
                throw new RuntimeException("Duplicate registry for object under '" + this.objectToIdentifier.get(object) + "' and '" + identifier + "'!");
            }
            CraftingHelper.register((ResourceLocation)identifier, (IConditionFactory)object);
        }

        public void onObjectAdded(ResourceLocation identifier, IConditionFactory object) {
            this.objectToIdentifier.put(object, identifier);
            this.entries.add(Pair.of(identifier, object));
        }

        @Override
        public ResourceLocation getIdentifier(IConditionFactory object) {
            return this.objectToIdentifier.get(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.identifierToObject.containsKey(identifier);
        }

        @Override
        public IConditionFactory getValue(ResourceLocation identifier) {
            return this.identifierToObject.get(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return Collections.unmodifiableSet(this.identifierToObject.keySet());
        }

        @Override
        public Collection<IConditionFactory> getValues() {
            return Collections.unmodifiableCollection(this.objectToIdentifier.keySet());
        }

        @Override
        public Set<Pair<ResourceLocation, IConditionFactory>> getEntries() {
            return Collections.unmodifiableSet(this.entries);
        }

        @Override
        public Class<IConditionFactory> getValueClass() {
            return this.valueClass;
        }

        static {
            try {
                Field field = CraftingHelper.class.getDeclaredField("conditions");
                field.setAccessible(true);
                craftingHelperConditions = () -> {
                    try {
                        return (Map)field.get(null);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            IDENTIFIER = new ResourceLocation("supermartijn642corelib", "resource_conditions");
        }
    }

    private static class MapBackedRegistry<T>
    implements Registry<T> {
        private final ResourceLocation identifier;
        private final Map<ResourceLocation, T> identifierToObject = new HashMap<ResourceLocation, T>();
        private final Map<T, ResourceLocation> objectToIdentifier = new HashMap<T, ResourceLocation>();
        private final Set<Pair<ResourceLocation, T>> entries = new HashSet<Pair<ResourceLocation, T>>();
        private final Class<T> valueClass;

        private MapBackedRegistry(ResourceLocation identifier, Class<? super T> valueClass) {
            this.identifier = identifier;
            this.valueClass = valueClass;
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public IRegistry<ResourceLocation, T> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        @Nullable
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            if (this.identifierToObject.containsKey(identifier)) {
                throw new RuntimeException("Duplicate registry for identifier '" + identifier + "'!");
            }
            if (this.objectToIdentifier.containsKey(object)) {
                throw new RuntimeException("Duplicate registry for object under '" + this.objectToIdentifier.get(object) + "' and '" + identifier + "'!");
            }
            if (object instanceof IForgeRegistryEntry) {
                ((IForgeRegistryEntry)object).setRegistryName(identifier);
            }
            this.identifierToObject.put(identifier, object);
            this.objectToIdentifier.put(object, identifier);
            this.entries.add(Pair.of(identifier, object));
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.objectToIdentifier.get(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.identifierToObject.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return this.identifierToObject.get(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return Collections.unmodifiableSet(this.identifierToObject.keySet());
        }

        @Override
        public Collection<T> getValues() {
            return Collections.unmodifiableCollection(this.objectToIdentifier.keySet());
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return Collections.unmodifiableSet(this.entries);
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }
    }

    private static class FluidRegistryWrapper
    implements Registry<Fluid> {
        private static final ResourceLocation IDENTIFIER = new ResourceLocation("fluids");

        private FluidRegistryWrapper() {
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return IDENTIFIER;
        }

        @Override
        @Nullable
        public IRegistry<ResourceLocation, Fluid> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        @Nullable
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, Fluid object) {
            if (!identifier.toString().equals(object.getName())) {
                throw new RuntimeException("Mismatched fluid name '" + object.getName() + "' and identifier '" + identifier + "'!");
            }
            FluidRegistry.registerFluid((Fluid)object);
        }

        @Override
        public ResourceLocation getIdentifier(Fluid object) {
            return new ResourceLocation(FluidRegistry.getFluidName((Fluid)object));
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return FluidRegistry.isFluidRegistered((String)identifier.toString());
        }

        @Override
        public Fluid getValue(ResourceLocation identifier) {
            return FluidRegistry.getFluid((String)identifier.toString());
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return MappedSetView.map(FluidRegistry.getRegisteredFluids().keySet(), ResourceLocation::new);
        }

        @Override
        public Collection<Fluid> getValues() {
            return FluidRegistry.getRegisteredFluids().values();
        }

        @Override
        public Set<Pair<ResourceLocation, Fluid>> getEntries() {
            return MappedSetView.map(FluidRegistry.getRegisteredFluids().entrySet(), entry -> Pair.of(new ResourceLocation((String)entry.getKey()), entry.getValue()));
        }

        @Override
        public Class<Fluid> getValueClass() {
            return Fluid.class;
        }
    }

    private static class ForgeRegistryWrapper<T extends IForgeRegistryEntry<T>>
    implements Registry<T> {
        private final IRegistry<ResourceLocation, T> registry;
        private final IForgeRegistry<T> forgeRegistry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private ForgeRegistryWrapper(IRegistry<ResourceLocation, T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
            this.registry = registry;
            this.forgeRegistry = forgeRegistry;
            this.identifier = RegistryManager.ACTIVE.getName(forgeRegistry);
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        @Deprecated
        public IRegistry<ResourceLocation, T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return this.registry != null;
        }

        @Override
        @Nullable
        @Deprecated
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return this.forgeRegistry;
        }

        @Override
        public boolean hasForgeRegistry() {
            return true;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            if (!identifier.equals((Object)object.getRegistryName())) {
                object.setRegistryName(identifier);
            }
            this.forgeRegistry.register(object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.forgeRegistry.getKey(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.forgeRegistry.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.forgeRegistry.getValue(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.forgeRegistry.getKeys();
        }

        @Override
        public Collection<T> getValues() {
            return this.forgeRegistry.getValues();
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.forgeRegistry.getEntries(), entry -> Pair.of(entry.getKey(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.registry, this.forgeRegistry, this.valueClass});
        }
    }

    private static class VanillaRegistryWrapper<T>
    implements Registry<T> {
        private final IRegistry<ResourceLocation, T> registry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private VanillaRegistryWrapper(ResourceLocation identifier, IRegistry<ResourceLocation, T> registry, Class<? super T> valueClass) {
            this.identifier = identifier;
            this.registry = registry;
            this.valueClass = valueClass;
            if (!(registry instanceof RegistrySimple)) {
                throw new RuntimeException("Registry for type '" + valueClass.getName() + "' is not an instance of RegistrySimple!");
            }
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        @Deprecated
        public IRegistry<ResourceLocation, T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return true;
        }

        @Override
        @Nullable
        @Deprecated
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            this.registry.func_82595_a((Object)identifier, object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return (ResourceLocation)((RegistrySimpleExtension)this.registry).coreLibGetKey(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.registry.func_148742_b().contains(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.registry.func_82594_a((Object)identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.registry.func_148742_b();
        }

        @Override
        public Collection<T> getValues() {
            return ((RegistrySimple)this.registry).field_82596_a.values();
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(((RegistrySimple)this.registry).field_82596_a.entrySet(), entry -> Pair.of(entry.getKey(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }

    public static interface Registry<T> {
        public ResourceLocation getRegistryIdentifier();

        @Nullable
        public IRegistry<ResourceLocation, T> getVanillaRegistry();

        public boolean hasVanillaRegistry();

        @Nullable
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry();

        public boolean hasForgeRegistry();

        public void register(ResourceLocation var1, T var2);

        public ResourceLocation getIdentifier(T var1);

        public boolean hasIdentifier(ResourceLocation var1);

        public T getValue(ResourceLocation var1);

        public Set<ResourceLocation> getIdentifiers();

        public Collection<T> getValues();

        public Set<Pair<ResourceLocation, T>> getEntries();

        public Class<T> getValueClass();
    }
}

