/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.network.PacketDirection;
import com.supermartijn642.core.registry.RegistryUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketChannel {
    private static final HashMap<String, PacketChannel> NAME_TO_CHANNEL = new HashMap();
    private final String modid;
    private final String name;
    private final ResourceLocation channelName;
    private final SimpleNetworkWrapper channel;
    private final List<PacketProperties<?>> packetsByIndex = new ArrayList();
    private final Map<Class<? extends BasePacket>, PacketProperties<?>> packetsByClass = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        boolean validActiveMod;
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = Loader.instance().activeModContainer() == null ? null : Loader.instance().activeModContainer().getModId();
        boolean bl = validActiveMod = activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge");
        if (validActiveMod) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '{}' is creating a packet channel for different modid '{}'!", (Object)Loader.instance().activeModContainer().getName(), (Object)modid);
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a packet channel for modid '{}'!", (Object)modid);
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    @Deprecated
    public static PacketChannel create() {
        ModContainer modContainer = Loader.instance().activeModContainer();
        return PacketChannel.create(modContainer == null ? "unknown" : modContainer.getModId(), "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channelName = new ResourceLocation(modid, name);
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel(this.channelName.toString());
        this.channel.registerMessage((message, context) -> {
            this.handle(((InternalPacket)message).packet, new PacketContext(context), PacketDirection.CLIENT_TO_SERVER);
            return null;
        }, InternalPacket.class, 0, Side.SERVER);
        this.channel.registerMessage((message, context) -> {
            this.handle(((InternalPacket)message).packet, new PacketContext(context), PacketDirection.SERVER_TO_CLIENT);
            return null;
        }, InternalPacket.class, 1, Side.CLIENT);
        NAME_TO_CHANNEL.put(this.channelName.toString(), this);
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, PacketDirection direction, boolean shouldBeQueued) {
        if (this.packetsByClass.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + packetClass + "' has already been registered!");
        }
        int index = this.packetsByIndex.size();
        PacketProperties properties = new PacketProperties(index, packetClass, packetSupplier, direction, shouldBeQueued);
        this.packetsByIndex.add(properties);
        this.packetsByClass.put(packetClass, properties);
    }

    @Deprecated
    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        this.registerMessage(packetClass, packetSupplier, PacketDirection.BOTH_WAYS, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.CLIENT_TO_SERVER);
        this.channel.sendToServer((IMessage)new InternalPacket(this, packet));
    }

    public void sendToPlayer(EntityPlayer player, BasePacket packet) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.sendTo((IMessage)new InternalPacket(this, packet), (EntityPlayerMP)player);
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.sendToAll((IMessage)new InternalPacket(this, packet));
    }

    public void sendToDimension(int dimension, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.sendToDimension((IMessage)new InternalPacket(this, packet), dimension);
    }

    @Deprecated
    public void sendToDimension(DimensionType dimension, BasePacket packet) {
        this.sendToDimension(dimension.func_186068_a(), packet);
    }

    public void sendToDimension(World world, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToDimension(world.field_73011_w.getDimension(), packet);
    }

    public void sendToAllTrackingEntity(Entity entity, BasePacket packet) {
        if (entity.field_70170_p.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.sendToAllTracking((IMessage)new InternalPacket(this, packet), entity);
    }

    public void sendToAllNear(int dimension, double x, double y, double z, double radius, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.sendToAllAround((IMessage)new InternalPacket(this, packet), new NetworkRegistry.TargetPoint(dimension, x, y, z, radius));
    }

    public void sendToAllNear(int dimension, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(dimension, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius, packet);
    }

    @Deprecated
    public void sendToAllNear(DimensionType world, double x, double y, double z, double radius, BasePacket packet) {
        this.sendToAllNear(world.func_186068_a(), x, y, z, radius, packet);
    }

    @Deprecated
    public void sendToAllNear(DimensionType world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world.func_186068_a(), pos, radius, packet);
    }

    public void sendToAllNear(World world, double x, double y, double z, double radius, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear(world.field_73011_w.getDimension(), x, y, z, radius, packet);
    }

    public void sendToAllNear(World world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet, PacketDirection direction) {
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (properties == null) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + packet.getClass() + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        if (((PacketProperties)properties).direction != PacketDirection.BOTH_WAYS && ((PacketProperties)properties).direction != direction) {
            throw new IllegalArgumentException("Tried to send packet '" + packet.getClass() + "' on channel '" + this.modid + ":" + this.name + "' in invalid direction '" + (Object)((Object)direction) + "'!");
        }
    }

    private void write(BasePacket packet, PacketBuffer buffer) {
        int index = ((PacketProperties)this.packetsByClass.get(packet.getClass())).index;
        buffer.writeInt(index);
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst writing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
    }

    private BasePacket read(PacketBuffer buffer) {
        int index = buffer.readInt();
        if (this.packetsByIndex.size() < index) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        PacketProperties<?> properties = this.packetsByIndex.get(index);
        BasePacket packet = (BasePacket)((PacketProperties)properties).supplier.get();
        try {
            packet.read(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst reading packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        return packet;
    }

    void handle(BasePacket packet, PacketContext context, PacketDirection direction) {
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (((PacketProperties)properties).direction != PacketDirection.BOTH_WAYS && ((PacketProperties)properties).direction != direction) {
            throw new RuntimeException("Received packet of class '" + ((PacketProperties)properties).clazz + "' on channel '" + this.modid + ":" + this.name + "' for invalid direction '" + (Object)((Object)(direction == PacketDirection.CLIENT_TO_SERVER ? PacketDirection.SERVER_TO_CLIENT : PacketDirection.CLIENT_TO_SERVER)) + "'!");
        }
        try {
            boolean verify = packet.verify(context);
            if (!verify) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst verifying packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        Runnable handle = () -> {
            try {
                packet.handle(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst processing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
            }
        };
        if (((PacketProperties)properties).shouldBeQueued) {
            context.queueTask(handle);
        } else {
            handle.run();
        }
    }

    @Deprecated
    public static class InternalPacket
    implements IMessage {
        private PacketChannel channel;
        private BasePacket packet;

        public InternalPacket(PacketChannel channel, BasePacket packet) {
            this.channel = channel;
            this.packet = packet;
        }

        public InternalPacket() {
        }

        public void fromBytes(ByteBuf buffer) {
            PacketBuffer packetBuffer = new PacketBuffer(buffer);
            this.channel = (PacketChannel)NAME_TO_CHANNEL.get(packetBuffer.func_150789_c(Short.MAX_VALUE));
            if (this.channel == null) {
                throw new IllegalStateException("Couldn't find received channel name!");
            }
            this.packet = this.channel.read(packetBuffer);
        }

        public void toBytes(ByteBuf buffer) {
            PacketBuffer packetBuffer = new PacketBuffer(buffer);
            packetBuffer.func_180714_a(this.channel.modid + ":" + this.channel.name);
            this.channel.write(this.packet, packetBuffer);
        }
    }

    private static class PacketProperties<T extends BasePacket> {
        private final int index;
        private final Class<T> clazz;
        private final Supplier<T> supplier;
        private final PacketDirection direction;
        private final boolean shouldBeQueued;

        private PacketProperties(int index, Class<T> clazz, Supplier<T> supplier, PacketDirection direction, boolean shouldBeQueued) {
            this.index = index;
            this.clazz = clazz;
            this.supplier = supplier;
            this.direction = direction;
            this.shouldBeQueued = shouldBeQueued;
        }
    }
}

