/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget.premade;

import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.function.IntSupplier;
import net.minecraft.util.text.ITextComponent;

public class ScissorWidget
extends BaseWidget {
    private IntSupplier scissorOffsetX;
    private IntSupplier scissorOffsetY;

    public static ScissorWidget create(int x, int y, int width, int height, Widget ... children) {
        return new ScissorWidget(x, y, width, height, children);
    }

    private ScissorWidget(int x, int y, int width, int height, Widget ... children) {
        super(x, y, width, height);
        for (Widget child : children) {
            this.addWidget(child);
        }
    }

    public void setScissorOffset(IntSupplier offsetX, IntSupplier offsetY) {
        this.scissorOffsetX = offsetX;
        this.scissorOffsetY = offsetY;
    }

    @Override
    public ITextComponent getNarrationMessage() {
        return null;
    }

    @Override
    public <T extends Widget> T addWidget(T widget) {
        return super.addWidget(widget);
    }

    @Override
    public boolean removeWidget(Widget widget) {
        return super.removeWidget(widget);
    }

    private void renderScissored(int mouseX, int mouseY, RenderFunction renderFunction) {
        if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
            mouseY = -100;
            mouseX = -100;
        }
        int x = this.x;
        if (this.scissorOffsetX != null) {
            x += this.scissorOffsetX.getAsInt();
        }
        int y = this.y;
        if (this.scissorOffsetY != null) {
            y += this.scissorOffsetY.getAsInt();
        }
        int finalMouseX = mouseX;
        int finalMouseY = mouseY;
        ScreenUtils.withScissor(x, y, this.width, this.height, () -> renderFunction.render(finalMouseX, finalMouseY));
    }

    @Override
    public void renderBackground(int mouseX, int mouseY) {
        this.renderScissored(mouseX, mouseY, (x$0, x$1) -> super.renderBackground(x$0, x$1));
    }

    @Override
    public void render(int mouseX, int mouseY) {
        this.renderScissored(mouseX, mouseY, (x$0, x$1) -> super.render(x$0, x$1));
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        this.renderScissored(mouseX, mouseY, (x$0, x$1) -> super.renderForeground(x$0, x$1));
    }

    @Override
    public void renderOverlay(int mouseX, int mouseY) {
        this.renderScissored(mouseX, mouseY, (x$0, x$1) -> super.renderOverlay(x$0, x$1));
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
            mouseY = -100;
            mouseX = -100;
        }
        super.renderTooltips(mouseX, mouseY);
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
            mouseY = -100;
            mouseX = -100;
        }
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
            mouseY = -100;
            mouseX = -100;
        }
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
            mouseY = -100;
            mouseX = -100;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }

    private static interface RenderFunction {
        public void render(int var1, int var2);
    }
}

