/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.CustomSlot;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends GuiContainer {
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("supermartijn642corelib", "textures/gui/slot.png");
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container);
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void func_73866_w_() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.field_146999_f = this.widget.width();
        this.field_147000_g = this.widget.height();
        super.func_73866_w_();
    }

    public void func_146281_b() {
        this.widget.discard();
        super.func_146281_b();
    }

    public void func_73876_c() {
        this.widget.update();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ItemStack cursorStack;
        this.func_146276_q_();
        int offsetX = (this.field_146294_l - this.widget.width()) / 2;
        int offsetY = (this.field_146295_m - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
        this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        this.widget.renderBackground(offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).field_75151_b) {
                if (slot instanceof CustomSlot) {
                    if (!((CustomSlot)slot).showBackground()) continue;
                    ScreenUtils.bindTexture(SLOT_TEXTURE);
                    ScreenUtils.drawTexture(slot.field_75223_e - 1, slot.field_75221_f - 1, ((CustomSlot)slot).getWidth(), ((CustomSlot)slot).getHeight());
                    continue;
                }
                ScreenUtils.bindTexture(SLOT_TEXTURE);
                ScreenUtils.drawTexture(slot.field_75223_e - 1, slot.field_75221_f - 1, 18.0f, 18.0f);
            }
        }
        this.widget.render(offsetMouseX, offsetMouseY);
        RenderHelper.func_74520_c();
        this.field_147006_u = null;
        for (Slot slot : ((BaseContainer)((Object)this.container)).field_75151_b) {
            if (!slot.func_111238_b()) continue;
            if (slot instanceof CustomSlot) {
                CustomSlot customSlot = (CustomSlot)slot;
                int slotWidth = customSlot.getWidth();
                int slotHeight = customSlot.getHeight();
                if (customSlot.showItem()) {
                    float scale = Math.min((float)slotWidth / 18.0f, (float)slotHeight / 18.0f);
                    GlStateManager.func_179094_E();
                    if (customSlot.scaleItemToSize() && scale != 1.0f) {
                        GlStateManager.func_179109_b((float)slot.field_75223_e, (float)slot.field_75221_f, (float)0.0f);
                        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                        GlStateManager.func_179109_b((float)(-slot.field_75223_e), (float)(-slot.field_75221_f), (float)0.0f);
                        this.func_146977_a(slot);
                    } else {
                        GlStateManager.func_179109_b((float)((float)(customSlot.getWidth() - 18) / 2.0f), (float)((float)(customSlot.getHeight() - 18) / 2.0f), (float)0.0f);
                        this.func_146977_a(slot);
                    }
                    GlStateManager.func_179121_F();
                }
                if (!this.func_146981_a(slot, mouseX, mouseY) || !customSlot.showHighlight()) continue;
                this.field_147006_u = slot;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                ScreenUtils.fillRect(slot.field_75223_e, slot.field_75221_f, slotWidth - 2, slotHeight - 2, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                continue;
            }
            this.func_146977_a(slot);
            if (!this.func_146981_a(slot, mouseX, mouseY)) continue;
            this.field_147006_u = slot;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            ScreenUtils.fillRect(slot.field_75223_e, slot.field_75221_f, 16.0f, 16.0f, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        this.widget.renderForeground(offsetMouseX, offsetMouseY);
        this.func_191948_b(offsetMouseX, offsetMouseY);
        GlStateManager.func_179121_F();
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground((GuiContainer)this, mouseX, mouseY));
        ItemStack itemStack = cursorStack = this.field_147012_x.func_190926_b() ? ClientUtils.getPlayer().field_71071_by.func_70445_o() : this.field_147012_x;
        if (!cursorStack.func_190926_b()) {
            int offset = this.field_147012_x.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.field_147012_x.func_190926_b() && this.field_147004_w) {
                cursorStack = cursorStack.func_77946_l();
                cursorStack.func_190920_e(MathHelper.func_76123_f((float)((float)cursorStack.func_190916_E() / 2.0f)));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                cursorStack = cursorStack.func_77946_l();
                cursorStack.func_190920_e(this.field_146996_I);
                if (cursorStack.func_190926_b()) {
                    s = TextFormatting.YELLOW + "0";
                }
            }
            this.func_146982_a(cursorStack, mouseX - 8, mouseY - offset, s);
        }
        if (!this.field_146991_C.func_190926_b()) {
            float f = (float)(Minecraft.func_71386_F() - this.field_146990_B) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.field_146991_C = ItemStack.field_190927_a;
            }
            int j2 = this.field_146989_A.field_75223_e - this.field_147011_y;
            int k2 = this.field_146989_A.field_75221_f - this.field_147010_z;
            int j1 = this.field_147011_y + (int)((float)j2 * f);
            int k1 = this.field_147010_z + (int)((float)k2 * f);
            this.func_146982_a(this.field_146991_C, j1, k1, null);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
        this.widget.renderOverlay(offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(offsetMouseX, offsetMouseY);
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        int offsetY;
        int offsetX = (this.field_146294_l - this.widget.width()) / 2;
        if (!this.widget.mousePressed(mouseX - offsetX, mouseY - (offsetY = (this.field_146295_m - this.widget.height()) / 2), button, false)) {
            super.func_73864_a(mouseX, mouseY, button);
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_146294_l - this.widget.width()) / 2;
        if (!this.widget.mouseReleased(mouseX - offsetX, mouseY - (offsetY = (this.field_146295_m - this.widget.height()) / 2), button, false)) {
            super.func_146286_b(mouseX, mouseY, button);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = (int)((double)Mouse.getEventX() * (double)this.field_146294_l / (double)this.field_146297_k.field_71443_c);
        int mouseY = (int)((double)this.field_146295_m - (double)Mouse.getEventY() * (double)this.field_146295_m / (double)this.field_146297_k.field_71440_d - 1.0);
        int scroll = Mouse.getEventDWheel() / 120;
        if (scroll != 0) {
            this.mouseScrolled(mouseX, mouseY, scroll);
        }
    }

    public void mouseScrolled(double mouseX, double mouseY, double amount) {
        int offsetX = (this.field_146294_l - this.widget.width()) / 2;
        int offsetY = (this.field_146295_m - this.widget.height()) / 2;
        this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)offsetY), amount, false);
    }

    public void func_146282_l() {
        if (Keyboard.getEventKeyState()) {
            int key;
            char character = Keyboard.getEventCharacter();
            if (character >= ' ') {
                this.charTyped(character);
            }
            if ((key = Keyboard.getEventKey()) >= 0 && key < WidgetScreen.KEY_CODE_MAP.length && !this.keyPressed(WidgetScreen.KEY_CODE_MAP[key])) {
                this.field_146297_k.func_152348_aa();
            }
        } else {
            int key = Keyboard.getEventKey();
            if (key >= 0 && key < WidgetScreen.KEY_CODE_MAP.length && !this.keyReleased(WidgetScreen.KEY_CODE_MAP[key])) {
                this.field_146297_k.func_152348_aa();
            }
        }
    }

    public boolean keyPressed(int keyCode) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        if (keyCode == 256 || ClientUtils.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(Keyboard.getEventKey())) {
            this.closeScreen();
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode) {
        return this.widget.keyReleased(keyCode, false);
    }

    public boolean charTyped(char character) {
        return this.widget.charTyped(character, false);
    }

    public boolean func_73868_f() {
        return this.isPauseScreen();
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    protected void closeScreen() {
        ClientUtils.closeScreen();
    }
}

