/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.gui.CustomSlot;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;

public class CustomSlotImpl
extends Slot
implements CustomSlot {
    private static final IInventory EMPTY_CONTAINER = new IInventory(){

        public String func_70005_c_() {
            return "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return null;
        }

        public int func_70302_i_() {
            return 0;
        }

        public boolean func_191420_l() {
            return true;
        }

        public ItemStack func_70301_a(int i) {
            return ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int i, int j) {
            return ItemStack.field_190927_a;
        }

        public ItemStack func_70304_b(int i) {
            return ItemStack.field_190927_a;
        }

        public void func_70299_a(int i, ItemStack itemStack) {
        }

        public int func_70297_j_() {
            return 0;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer player) {
            return false;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int i, ItemStack stack) {
            return false;
        }

        public int func_174887_a_(int i) {
            return 0;
        }

        public void func_174885_b(int i, int j) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
        }
    };
    private final int width;
    private final int height;
    private final Supplier<ItemStack> getter;
    private final Consumer<ItemStack> setter;
    private final ToIntFunction<ItemStack> inserter;
    private final Function<Integer, ItemStack> extractor;
    private final ToIntFunction<ItemStack> capacity;
    private final Predicate<ItemStack> filter;
    private final CustomSlot.SlotChangeListener onInsert;
    private final CustomSlot.SlotChangeListener onExtract;
    private final boolean canInsert;
    private final boolean canExtract;
    private final boolean scaleItemToSize;
    private final boolean showBackground;
    private final boolean showItem;
    private final boolean showHighlight;
    private boolean active = true;

    static CustomSlot.Builder builder() {
        return new BuilderImpl();
    }

    private CustomSlotImpl(IInventory vanillaContainer, int vanillaSlot, int x, int y, int width, int height, Supplier<ItemStack> getter, Consumer<ItemStack> setter, ToIntFunction<ItemStack> inserter, Function<Integer, ItemStack> extractor, ToIntFunction<ItemStack> capacity, Predicate<ItemStack> filter, CustomSlot.SlotChangeListener onInsert, CustomSlot.SlotChangeListener onExtract, boolean canInsert, boolean canExtract, boolean scaleItemToSize, boolean showBackground, boolean showItem, boolean showHighlight) {
        super(vanillaContainer == null ? EMPTY_CONTAINER : vanillaContainer, vanillaSlot, x, y);
        this.width = width;
        this.height = height;
        this.getter = getter == null ? () -> ItemStack.field_190927_a : getter;
        Consumer<ItemStack> consumer = this.setter = setter == null ? stack -> {} : setter;
        ToIntFunction<ItemStack> toIntFunction = inserter == null ? (setter == null ? stack -> 0 : stack -> {
            if (stack.func_190926_b()) {
                return 0;
            }
            ItemStack currentStack = this.getter.get();
            if (!(currentStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)stack, (ItemStack)currentStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)currentStack))) {
                return 0;
            }
            int inserted = Math.min(stack.func_190916_E(), stack.func_77976_d() - currentStack.func_190916_E());
            if (capacity != null) {
                inserted = Math.min(inserted, capacity.applyAsInt((ItemStack)stack));
            }
            setter.accept(CustomSlotImpl.copyWithCount(stack, currentStack.func_190916_E() + inserted));
            return inserted;
        }) : (this.inserter = inserter);
        this.extractor = extractor == null ? (setter == null ? amount -> ItemStack.field_190927_a : amount -> {
            if (amount <= 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack currentStack = this.getter.get();
            if (currentStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int extracted = Math.min(amount, currentStack.func_190916_E());
            ItemStack extractedStack = CustomSlotImpl.copyWithCount(currentStack, extracted);
            setter.accept(CustomSlotImpl.copyWithCount(currentStack, currentStack.func_190916_E() - extracted));
            return extractedStack;
        }) : extractor;
        this.capacity = capacity == null ? stack -> stack.func_190926_b() ? 64 : stack.func_77976_d() : capacity;
        this.filter = filter == null ? stack -> true : filter;
        this.onInsert = onInsert == null ? (oldStack, newStack) -> {} : onInsert;
        this.onExtract = onExtract == null ? (oldStack, newStack) -> {} : onExtract;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
        this.scaleItemToSize = scaleItemToSize;
        this.showBackground = showBackground;
        this.showItem = showItem;
        this.showHighlight = showHighlight;
    }

    @Override
    public Slot getVanillaSlot() {
        return this;
    }

    @Override
    public void move(int x, int y) {
        this.field_75223_e = x;
        this.field_75221_f = y;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int getX() {
        return this.field_75223_e;
    }

    @Override
    public int getY() {
        return this.field_75221_f;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean scaleItemToSize() {
        return this.scaleItemToSize;
    }

    @Override
    public boolean showBackground() {
        return this.showBackground;
    }

    @Override
    public boolean showItem() {
        return this.showItem;
    }

    @Override
    public boolean showHighlight() {
        return this.showHighlight;
    }

    public boolean func_75214_a(ItemStack stack) {
        return this.canInsert && this.filter.test(stack);
    }

    @Override
    public ItemStack getItem() {
        return this.getter.get();
    }

    public ItemStack func_75211_c() {
        return this.getter.get();
    }

    public void func_75215_d(ItemStack stack) {
        ItemStack original = this.getter.get();
        this.setter.accept(stack);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.func_77989_b((ItemStack)original, (ItemStack)newStack)) {
            if (newStack.func_190926_b()) {
                this.onExtract.onChange(original, newStack);
            } else {
                this.onInsert.onChange(original, newStack);
            }
        }
    }

    public int func_75219_a() {
        return this.capacity.applyAsInt(ItemStack.field_190927_a);
    }

    public int func_178170_b(ItemStack stack) {
        return this.capacity.applyAsInt(stack);
    }

    public ItemStack func_75209_a(int amount) {
        ItemStack original = this.getter.get();
        ItemStack extracted = this.extractor.apply(amount);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.func_77989_b((ItemStack)original, (ItemStack)newStack)) {
            this.onExtract.onChange(original, newStack);
        }
        return extracted;
    }

    public boolean func_82869_a(EntityPlayer player) {
        return this.canExtract;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private static ItemStack copyWithCount(ItemStack stack, int count) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(count);
        return copy;
    }

    private static class BuilderImpl
    implements CustomSlot.Builder {
        private int x;
        private int y;
        private int width = 18;
        private int height = 18;
        private Supplier<ItemStack> getter;
        private Consumer<ItemStack> setter;
        private ToIntFunction<ItemStack> inserter;
        private Function<Integer, ItemStack> extractor;
        private ToIntFunction<ItemStack> capacity;
        private Predicate<ItemStack> filter;
        private CustomSlot.SlotChangeListener onInsert;
        private CustomSlot.SlotChangeListener onExtract;
        private boolean canInsert = true;
        private boolean canExtract = true;
        private boolean scaleItemToSize = false;
        private boolean showBackground = true;
        private boolean showItem = true;
        private boolean showHighlight = true;
        private IInventory vanillaContainer;
        private int vanillaSlot;

        private BuilderImpl() {
        }

        @Override
        public CustomSlot.Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int size) {
            return this.size(size, size);
        }

        @Override
        public CustomSlot.Builder getter(Supplier<ItemStack> getter) {
            this.getter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder setter(Consumer<ItemStack> getter) {
            this.setter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder inserter(ToIntFunction<ItemStack> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        public CustomSlot.Builder extractor(Function<Integer, ItemStack> extractor) {
            this.extractor = extractor;
            return this;
        }

        @Override
        public CustomSlot.Builder capacity(ToIntFunction<ItemStack> capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public CustomSlot.Builder filter(Predicate<ItemStack> filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public CustomSlot.Builder onInsert(CustomSlot.SlotChangeListener onInsert) {
            this.onInsert = onInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder onExtract(CustomSlot.SlotChangeListener onExtract) {
            this.onExtract = onExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder onChange(CustomSlot.SlotChangeListener onChange) {
            return this.onInsert(onChange).onExtract(onChange);
        }

        @Override
        public CustomSlot.Builder vanillaContainer(int index, IInventory container) {
            this.getter(() -> container.func_70301_a(index));
            this.setter(stack -> {
                container.func_70299_a(index, stack);
                container.func_70296_d();
            });
            this.inserter(stack -> {
                if (stack.func_190926_b()) {
                    return 0;
                }
                ItemStack currentStack = container.func_70301_a(index);
                int amount = Math.min(stack.func_190916_E(), container.func_70297_j_() - currentStack.func_190916_E());
                if (!(amount > 0 && (currentStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)stack, (ItemStack)currentStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)currentStack)))) {
                    return 0;
                }
                container.func_70299_a(index, CustomSlotImpl.copyWithCount(stack, currentStack.func_190916_E() + amount));
                container.func_70296_d();
                return amount;
            });
            this.extractor(amount -> {
                ItemStack extracted = container.func_70298_a(index, amount.intValue());
                if (!extracted.func_190926_b()) {
                    if (container.func_70301_a(index).func_190926_b()) {
                        container.func_70299_a(index, ItemStack.field_190927_a);
                    }
                    container.func_70296_d();
                }
                return extracted;
            });
            this.capacity(stack -> container.func_70297_j_());
            this.vanillaContainer = container;
            this.vanillaSlot = index;
            return this;
        }

        @Override
        public CustomSlot.Builder playerInventory(int index, InventoryPlayer inventory) {
            return this.vanillaContainer(index, (IInventory)inventory);
        }

        @Override
        public CustomSlot.Builder itemHandler(int index, Supplier<IItemHandler> handlerSupplier) {
            this.getter(() -> ((IItemHandler)handlerSupplier.get()).getStackInSlot(0));
            this.inserter(stack -> {
                if (stack.func_190926_b()) {
                    return 0;
                }
                IItemHandler handler = (IItemHandler)handlerSupplier.get();
                int initialCount = stack.func_190916_E();
                ItemStack leftover = handler.insertItem(0, stack, false);
                if (stack.func_190916_E() != initialCount) {
                    throw new RuntimeException("Item handler of class '" + handler.getClass() + "' modified input stack to #insertItem!");
                }
                return initialCount - leftover.func_190916_E();
            });
            this.extractor(amount -> {
                if (amount <= 0) {
                    return ItemStack.field_190927_a;
                }
                IItemHandler handler = (IItemHandler)handlerSupplier.get();
                return handler.extractItem(index, amount.intValue(), false);
            });
            this.capacity(stack -> ((IItemHandler)handlerSupplier.get()).getSlotLimit(0));
            return this;
        }

        @Override
        public CustomSlot.Builder canInsert(boolean canInsert) {
            this.canInsert = canInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder canExtract(boolean canExtract) {
            this.canExtract = canExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder canInsertExtract(boolean mutable) {
            return this.canExtract(mutable).canInsert(mutable);
        }

        @Override
        public CustomSlot.Builder scaleItemToSize(boolean scaleItemToSize) {
            this.scaleItemToSize = scaleItemToSize;
            return this;
        }

        @Override
        public CustomSlot.Builder scaleItemToSize() {
            return this.scaleItemToSize(true);
        }

        @Override
        public CustomSlot.Builder showBackground(boolean showBackground) {
            this.showBackground = showBackground;
            return this;
        }

        @Override
        public CustomSlot.Builder noBackground() {
            this.showBackground = false;
            return this;
        }

        @Override
        public CustomSlot.Builder showItem(boolean showItem) {
            this.showItem = showItem;
            return this;
        }

        @Override
        public CustomSlot.Builder showHighlight(boolean showHighlight) {
            this.showHighlight = showHighlight;
            return this;
        }

        @Override
        public CustomSlot build() {
            return new CustomSlotImpl(this.vanillaContainer, this.vanillaSlot, this.x, this.y, this.width, this.height, this.getter, this.setter, this.inserter, this.extractor, this.capacity, this.filter, this.onInsert, this.onExtract, this.canInsert, this.canExtract, this.scaleItemToSize, this.showBackground, this.showItem, this.showHighlight);
        }
    }
}

