/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class BlockProperties {
    final Material material;
    MapColor mapColor;
    boolean hasCollision = true;
    SoundType soundType = SoundType.field_185851_d;
    ToIntFunction<IBlockState> lightLevel = state -> 0;
    float explosionResistance;
    float destroyTime;
    boolean requiresCorrectTool = false;
    boolean ticksRandomly = false;
    float friction = 0.6f;
    float speedFactor = 1.0f;
    float jumpFactor = 1.0f;
    boolean canOcclude = true;
    boolean isAir;
    Predicate<IBlockState> isSuffocating = state -> state.func_185904_a().func_76230_c() && state.func_185917_h();
    boolean noLootTable = false;
    Supplier<Block> lootTableBlock;
    Supplier<ResourceLocation> lootTableSupplier;

    public static BlockProperties create(Material material, MapColor color) {
        return new BlockProperties(material).mapColor(color);
    }

    public static BlockProperties create(Material material, EnumDyeColor color) {
        return new BlockProperties(material).mapColor(MapColor.func_193558_a((EnumDyeColor)color));
    }

    public static BlockProperties create(Material material) {
        return new BlockProperties(material);
    }

    public static BlockProperties copy(Block block) {
        BlockProperties properties = BlockProperties.create(block.field_149764_J, block.field_181083_K);
        properties.hasCollision = block.func_149703_v();
        properties.soundType = block.func_185467_w();
        properties.lightLevel = arg_0 -> ((Block)block).func_149750_m(arg_0);
        properties.explosionResistance = block.field_149781_w;
        properties.destroyTime = block.field_149782_v;
        properties.requiresCorrectTool = !block.field_149764_J.func_76229_l();
        properties.ticksRandomly = block.func_149653_t();
        properties.friction = block.field_149765_K;
        properties.speedFactor = 1.0f;
        properties.jumpFactor = 1.0f;
        properties.canOcclude = block.func_149662_c(block.func_176223_P());
        properties.isAir = block.field_149764_J == Material.field_151579_a;
        properties.isSuffocating = arg_0 -> ((Block)block).func_176214_u(arg_0);
        properties.lootTableBlock = () -> block;
        return properties;
    }

    private BlockProperties(Material material) {
        this.material = material;
        this.mapColor = material.func_151565_r();
        this.isAir = material == Material.field_151579_a;
    }

    public BlockProperties mapColor(MapColor color) {
        this.mapColor = color == null ? this.material.func_151565_r() : color;
        return this;
    }

    public BlockProperties collision(boolean hasCollision) {
        this.hasCollision = hasCollision;
        if (!hasCollision) {
            this.canOcclude = false;
        }
        return this;
    }

    public BlockProperties noCollision() {
        return this.collision(false);
    }

    public BlockProperties sound(SoundType soundTypeIn) {
        this.soundType = soundTypeIn;
        return this;
    }

    public BlockProperties lightLevel(ToIntFunction<IBlockState> stateLightFunction) {
        this.lightLevel = stateLightFunction;
        return this;
    }

    public BlockProperties lightLevel(int light) {
        this.lightLevel = state -> light;
        return this;
    }

    public BlockProperties explosionResistance(float resistance) {
        this.explosionResistance = Math.max(0.0f, resistance * 5.0f / 3.0f);
        return this;
    }

    public BlockProperties destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockProperties strength(float strength) {
        return this.explosionResistance(strength).destroyTime(strength);
    }

    public BlockProperties requiresCorrectTool(boolean requiresCorrectTool) {
        this.requiresCorrectTool = requiresCorrectTool;
        return this;
    }

    public BlockProperties requiresCorrectTool() {
        return this.requiresCorrectTool(true);
    }

    public BlockProperties randomTicks(boolean receiveRandomTicks) {
        this.ticksRandomly = receiveRandomTicks;
        return this;
    }

    public BlockProperties randomTicks() {
        return this.randomTicks(true);
    }

    public BlockProperties friction(float friction) {
        this.friction = friction;
        return this;
    }

    public BlockProperties speedFactor(float factor) {
        this.speedFactor = factor;
        return this;
    }

    public BlockProperties jumpFactor(float factor) {
        this.jumpFactor = factor;
        return this;
    }

    public BlockProperties canOcclude(boolean canOcclude) {
        this.canOcclude = canOcclude;
        return this;
    }

    public BlockProperties noOcclusion() {
        return this.canOcclude(false);
    }

    public BlockProperties air(boolean isAir) {
        this.isAir = isAir;
        return this;
    }

    public BlockProperties air() {
        return this.air(true);
    }

    public BlockProperties isSuffocating(Predicate<IBlockState> isSuffocating) {
        this.isSuffocating = isSuffocating;
        return this;
    }

    public BlockProperties isSuffocating(boolean isSuffocating) {
        this.isSuffocating = state -> isSuffocating;
        return this;
    }

    public BlockProperties noLootTable() {
        this.noLootTable = true;
        this.lootTableBlock = null;
        this.lootTableSupplier = null;
        return this;
    }

    public BlockProperties defaultLootTable() {
        this.noLootTable = false;
        this.lootTableBlock = null;
        this.lootTableSupplier = null;
        return this;
    }

    public BlockProperties lootTable(ResourceLocation lootTable) {
        this.noLootTable = false;
        this.lootTableBlock = null;
        this.lootTableSupplier = () -> lootTable;
        return this;
    }

    public BlockProperties lootTableFrom(Supplier<Block> block) {
        this.noLootTable = false;
        this.lootTableBlock = block;
        this.lootTableSupplier = null;
        return this;
    }
}

