/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TextComponents {
    public static TextComponentBuilder empty() {
        return TextComponents.string("");
    }

    public static TextComponentBuilder string(String text) {
        return new TextComponentBuilder((ITextComponent)new TextComponentString(text));
    }

    public static TextComponentBuilder number(int number) {
        return new TextComponentBuilder((ITextComponent)new TextComponentString(Integer.toString(number)));
    }

    public static TextComponentBuilder number(double number, int decimals) {
        return new TextComponentBuilder((ITextComponent)new TextComponentString(String.format("%." + decimals + "f", number)));
    }

    public static TextComponentBuilder number(double number) {
        return new TextComponentBuilder((ITextComponent)new TextComponentString(Double.toString(number)));
    }

    public static TextComponentBuilder translation(String translationKey, Object ... arguments) {
        return new TextComponentBuilder((ITextComponent)new TextComponentTranslation(translationKey, arguments));
    }

    public static TextComponentBuilder translation(String translationKey) {
        return new TextComponentBuilder((ITextComponent)new TextComponentTranslation(translationKey, new Object[0]));
    }

    public static TextComponentBuilder fromTextComponent(ITextComponent textComponent) {
        return new TextComponentBuilder(textComponent);
    }

    public static String format(ITextComponent textComponent) {
        return textComponent.func_150254_d();
    }

    public static TextComponentBuilder block(Block block) {
        return TextComponents.translation(block.func_149739_a());
    }

    public static TextComponentBuilder blockState(IBlockState state) {
        return TextComponents.block(state.func_177230_c());
    }

    public static TextComponentBuilder item(Item item) {
        return TextComponents.translation(item.func_77653_i(ItemStack.field_190927_a));
    }

    public static TextComponentBuilder itemStack(ItemStack stack) {
        return TextComponents.string(stack.func_82833_r());
    }

    public static TextComponentBuilder fluid(Fluid fluid) {
        return TextComponents.translation(fluid.getUnlocalizedName());
    }

    public static TextComponentBuilder fluidStack(FluidStack stack) {
        return TextComponents.translation(stack.getFluid().getUnlocalizedName(stack));
    }

    public static TextComponentBuilder entity(Entity entity) {
        return entity.func_145818_k_() ? TextComponents.string(entity.func_95999_t()) : TextComponents.fromTextComponent(entity.func_145748_c_());
    }

    public static TextComponentBuilder dimension(DimensionType dimension) {
        String dimensionName = dimension.func_186065_b();
        dimensionName = dimensionName.substring(Math.min(dimensionName.length() - 1, Math.max(0, dimensionName.indexOf(47) + 1))).toLowerCase();
        dimensionName = dimensionName.substring(0, 1).toUpperCase() + dimensionName.substring(1);
        for (int i = 0; i < dimensionName.length() - 1; ++i) {
            if (dimensionName.charAt(i) != '_' || !Character.isAlphabetic(dimensionName.charAt(i + 1))) continue;
            dimensionName = dimensionName.substring(0, i) + ' ' + (i + 2 < dimensionName.length() ? dimensionName.substring(i + 1, i + 2).toUpperCase() + dimensionName.substring(i + 2) : dimensionName.substring(i + 1).toUpperCase());
        }
        return TextComponents.string(dimensionName);
    }

    public static TextComponentBuilder dimension(World world) {
        return TextComponents.dimension(world.field_73011_w.func_186058_p());
    }

    public static class TextComponentBuilder {
        private final TextComponentBuilder parent;
        private final ITextComponent textComponent;

        private TextComponentBuilder(ITextComponent textComponent, TextComponentBuilder parent) {
            this.textComponent = textComponent;
            this.parent = parent;
        }

        private TextComponentBuilder(ITextComponent textComponent) {
            this(textComponent, (TextComponentBuilder)null);
        }

        public TextComponentBuilder formatting(TextFormatting color) {
            this.updateStyle(style -> style.func_150238_a(color));
            return this;
        }

        public TextComponentBuilder color(TextFormatting color) {
            return this.formatting(color);
        }

        public TextComponentBuilder bold() {
            this.updateStyle(style -> style.func_150227_a(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder italic() {
            this.updateStyle(style -> style.func_150217_b(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder underline() {
            this.updateStyle(style -> style.func_150228_d(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder strikethrough() {
            this.updateStyle(style -> style.func_150225_c(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder obfuscate() {
            this.updateStyle(style -> style.func_150237_e(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder reset() {
            this.updateStyle(style -> new Style().func_150227_a(Boolean.valueOf(false)).func_150217_b(Boolean.valueOf(false)).func_150228_d(Boolean.valueOf(false)).func_150225_c(Boolean.valueOf(false)).func_150237_e(Boolean.valueOf(false)));
            return this;
        }

        private void updateStyle(Function<Style, Style> updater) {
            this.textComponent.func_150255_a(updater.apply(this.textComponent.func_150256_b()));
        }

        public TextComponentBuilder string(String text) {
            return this.append((ITextComponent)new TextComponentString(text));
        }

        public TextComponentBuilder translation(String translationKey, Object ... arguments) {
            return this.append((ITextComponent)new TextComponentTranslation(translationKey, arguments));
        }

        public TextComponentBuilder translation(String translationKey) {
            return this.append((ITextComponent)new TextComponentTranslation(translationKey, new Object[0]));
        }

        public TextComponentBuilder append(ITextComponent textComponent) {
            this.textComponent.func_150257_a(textComponent);
            return new TextComponentBuilder(textComponent, this);
        }

        public ITextComponent get() {
            return this.parent == null ? this.textComponent : this.parent.get();
        }

        public String format() {
            return TextComponents.format(this.get());
        }
    }
}

