/*
 * Decompiled with CFR 0.152.
 */
package glmath.glm.mat._4;

import glmath.glm.Glm;
import glmath.glm.mat._4.Mat4;
import glmath.glm.mat._4.funcMatrix;
import glmath.glm.vec._3.Vec3;

abstract class matrixTransform
extends funcMatrix {
    matrixTransform() {
    }

    public Mat4 rotation(float radAngle, float x, float y, float z) {
        float c = (float)Math.cos(radAngle);
        float s = (float)Math.sin(radAngle);
        float t = (float)(1.0 - (double)c);
        this.m00 = c + x * x * t;
        this.m11 = c + y * y * t;
        this.m22 = c + z * z * t;
        float tmp1 = x * y * t;
        float tmp2 = z * s;
        this.m01 = tmp1 + tmp2;
        this.m10 = tmp1 - tmp2;
        tmp1 = x * z * t;
        tmp2 = y * s;
        this.m02 = tmp1 - tmp2;
        this.m20 = tmp1 + tmp2;
        tmp1 = y * z * t;
        tmp2 = x * s;
        this.m12 = tmp1 + tmp2;
        this.m21 = tmp1 - tmp2;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return (Mat4)this;
    }

    public Mat4 rotate(float angle, Vec3 v) {
        return this.rotate(angle, v.x, v.y, v.z, (Mat4)this);
    }

    public Mat4 rotate(float angle, float x, float y, float z) {
        return this.rotate(angle, x, y, z, (Mat4)this);
    }

    public Mat4 rotate(float angle, float x, float y, float z, Mat4 res) {
        float s = (float)Math.sin(angle);
        float c = (float)Math.cos(angle);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float rm00 = xx * C + c;
        float rm01 = xy * C + z * s;
        float rm02 = xz * C - y * s;
        float rm10 = xy * C - z * s;
        float rm11 = yy * C + c;
        float rm12 = yz * C + x * s;
        float rm20 = xz * C + y * s;
        float rm21 = yz * C - x * s;
        float rm22 = zz * C + c;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        res.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        res.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        res.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        res.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        res.m00 = nm00;
        res.m01 = nm01;
        res.m02 = nm02;
        res.m03 = nm03;
        res.m10 = nm10;
        res.m11 = nm11;
        res.m12 = nm12;
        res.m13 = nm13;
        res.m30 = this.m30;
        res.m31 = this.m31;
        res.m32 = this.m32;
        res.m33 = this.m33;
        return res;
    }

    public Mat4 rotateX(double ang) {
        return this.rotateX((float)ang, (Mat4)this);
    }

    public Mat4 rotateX(float ang) {
        return this.rotateX(ang, (Mat4)this);
    }

    public Mat4 rotateX(float ang, Mat4 res) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm11 = cos;
        float rm12 = sin;
        float rm21 = -sin;
        float rm22 = cos;
        float nm10 = this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m13 * rm11 + this.m23 * rm12;
        res.m20 = this.m10 * rm21 + this.m20 * rm22;
        res.m21 = this.m11 * rm21 + this.m21 * rm22;
        res.m22 = this.m12 * rm21 + this.m22 * rm22;
        res.m23 = this.m13 * rm21 + this.m23 * rm22;
        res.m10 = nm10;
        res.m11 = nm11;
        res.m12 = nm12;
        res.m13 = nm13;
        res.m00 = this.m00;
        res.m01 = this.m01;
        res.m02 = this.m02;
        res.m03 = this.m03;
        res.m30 = this.m30;
        res.m31 = this.m31;
        res.m32 = this.m32;
        res.m33 = this.m33;
        return res;
    }

    public Mat4 rotateY(double ang) {
        return this.rotateY((float)ang, (Mat4)this);
    }

    public Mat4 rotateY(float ang) {
        return this.rotateY(ang, (Mat4)this);
    }

    public Mat4 rotateY(float ang, Mat4 res) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm00 = cos;
        float rm02 = -sin;
        float rm20 = sin;
        float rm22 = cos;
        float nm00 = this.m00 * rm00 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m23 * rm02;
        res.m20 = this.m00 * rm20 + this.m20 * rm22;
        res.m21 = this.m01 * rm20 + this.m21 * rm22;
        res.m22 = this.m02 * rm20 + this.m22 * rm22;
        res.m23 = this.m03 * rm20 + this.m23 * rm22;
        res.m00 = nm00;
        res.m01 = nm01;
        res.m02 = nm02;
        res.m03 = nm03;
        res.m10 = this.m10;
        res.m11 = this.m11;
        res.m12 = this.m12;
        res.m13 = this.m13;
        res.m30 = this.m30;
        res.m31 = this.m31;
        res.m32 = this.m32;
        res.m33 = this.m33;
        return res;
    }

    public Mat4 rotateZ(double ang) {
        return this.rotateZ((float)ang, (Mat4)this);
    }

    public Mat4 rotateZ(float ang) {
        return this.rotateZ(ang, (Mat4)this);
    }

    public Mat4 rotateZ(float ang, Mat4 res) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm00 = cos;
        float rm01 = sin;
        float rm10 = -sin;
        float rm11 = cos;
        float nm00 = this.m00 * rm00 + this.m10 * rm01;
        float nm01 = this.m01 * rm00 + this.m11 * rm01;
        float nm02 = this.m02 * rm00 + this.m12 * rm01;
        float nm03 = this.m03 * rm00 + this.m13 * rm01;
        res.m10 = this.m00 * rm10 + this.m10 * rm11;
        res.m11 = this.m01 * rm10 + this.m11 * rm11;
        res.m12 = this.m02 * rm10 + this.m12 * rm11;
        res.m13 = this.m03 * rm10 + this.m13 * rm11;
        res.m00 = nm00;
        res.m01 = nm01;
        res.m02 = nm02;
        res.m03 = nm03;
        res.m20 = this.m20;
        res.m21 = this.m21;
        res.m22 = this.m22;
        res.m23 = this.m23;
        res.m30 = this.m30;
        res.m31 = this.m31;
        res.m32 = this.m32;
        res.m33 = this.m33;
        return res;
    }

    public Mat4 rotationX(float ang) {
        float cos = (float)Math.cos(ang);
        float sin = (float)Math.sin(ang);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = cos;
        this.m12 = sin;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = -sin;
        this.m22 = cos;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return (Mat4)this;
    }

    public Mat4 rotationY(float ang) {
        float cos = (float)Math.cos(ang);
        float sin = (float)Math.sin(ang);
        this.m00 = cos;
        this.m01 = 0.0f;
        this.m02 = -sin;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = sin;
        this.m21 = 0.0f;
        this.m22 = cos;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return (Mat4)this;
    }

    public Mat4 rotationZ(float ang) {
        float cos = (float)Math.cos(ang);
        float sin = (float)Math.sin(ang);
        this.m00 = cos;
        this.m01 = sin;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = -sin;
        this.m11 = cos;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return (Mat4)this;
    }

    public Mat4 scale(float[] f) {
        return this.scale(f[0], f[1], f[2]);
    }

    public Mat4 scale(float s) {
        return this.scale(s, s, s);
    }

    public Mat4 scale(Vec3 v) {
        return this.scale(v.x, v.y, v.z);
    }

    public Mat4 scale(Vec3 v, Mat4 res) {
        return this.scale(v.x, v.y, v.z, res);
    }

    public Mat4 scale(float x, float y, float z) {
        return this.scale(x, y, z, (Mat4)this);
    }

    public Mat4 scale(float x, float y, float z, Mat4 res) {
        res.m00 = this.m00 * x;
        res.m01 = this.m01 * x;
        res.m02 = this.m02 * x;
        res.m03 = this.m03 * x;
        res.m10 = this.m10 * y;
        res.m11 = this.m11 * y;
        res.m12 = this.m12 * y;
        res.m13 = this.m13 * y;
        res.m20 = this.m20 * z;
        res.m21 = this.m21 * z;
        res.m22 = this.m22 * z;
        res.m23 = this.m23 * z;
        res.m30 = this.m30;
        res.m31 = this.m31;
        res.m32 = this.m32;
        res.m33 = this.m33;
        return res;
    }

    public Mat4 translation(Vec3 v) {
        return matrixTransform.translation((Mat4)this, v.x, v.y, v.z);
    }

    public Mat4 translation(float x, float y, float z) {
        return matrixTransform.translation((Mat4)this, x, y, z);
    }

    public static Mat4 translation(Mat4 result, float x, float y, float z) {
        result.m00 = 1.0f;
        result.m01 = 0.0f;
        result.m02 = 0.0f;
        result.m03 = 0.0f;
        result.m10 = 0.0f;
        result.m11 = 1.0f;
        result.m12 = 0.0f;
        result.m13 = 0.0f;
        result.m20 = 0.0f;
        result.m21 = 0.0f;
        result.m22 = 1.0f;
        result.m23 = 0.0f;
        result.m30 = x;
        result.m31 = y;
        result.m32 = z;
        result.m33 = 1.0f;
        return result;
    }

    public Mat4 translate(Vec3 v) {
        return this.translate((Mat4)this, v.x, v.y, v.z);
    }

    public Mat4 translate(float[] t) {
        return this.translate((Mat4)this, t[0], t[1], t[2]);
    }

    public Mat4 translate(float x, float y, float z) {
        return this.translate((Mat4)this, x, y, z);
    }

    public Mat4 translate(Mat4 res, Vec3 v) {
        return this.translate(res, v.x, v.y, v.z);
    }

    public Mat4 translate(Mat4 res, float x, float y, float z) {
        res.m30 = res.m00 * x + res.m10 * y + res.m20 * z + res.m30;
        res.m31 = res.m01 * x + res.m11 * y + res.m21 * z + res.m31;
        res.m32 = res.m02 * x + res.m12 * y + res.m22 * z + res.m32;
        res.m33 = res.m03 * x + res.m13 * y + res.m23 * z + res.m33;
        return (Mat4)this;
    }

    public Mat4 lookAt(Vec3 eye, Vec3 center, Vec3 up) {
        return Glm.lookAt(eye, center, up, (Mat4)this);
    }

    public static Mat4 lookAt(Vec3 eye, Vec3 center, Vec3 up, Mat4 res) {
        return Glm.lookAt(eye, center, up, res);
    }

    public Mat4 ortho(float left, float right, float bottom, float top, float zNear, float zFar) {
        return Glm.ortho((Mat4)this, left, right, bottom, top, zNear, zFar);
    }

    public Mat4 perspective(float fovy, float aspect, float zNear, float zFar) {
        return Glm.perspective(fovy, aspect, zNear, zFar, (Mat4)this);
    }

    public Mat4 perspectiveFov(float fov, float width, float height, float zNear, float zFar) {
        return Glm.perspectiveFov(fov, width, height, zNear, zFar, (Mat4)this);
    }
}

