/*
 * Decompiled with CFR 0.152.
 */
package glmath.benchmark;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.LinkedList;

public class Test {
    protected static final int SIZE = 16;
    protected static final int ITERARIONS = 10000000;

    public static void main(String[] args) {
        float value;
        int pos;
        int i;
        long ns = System.nanoTime();
        LinkedList<Testresult> arrayResults = new LinkedList<Testresult>();
        LinkedList<Testresult> bufferResults = new LinkedList<Testresult>();
        LinkedList<Testresult> bufferDResults = new LinkedList<Testresult>();
        System.out.println("Using arrays of size 16 with 10000000 iterations...");
        float[] fArray = new float[16];
        FloatBuffer buffer = FloatBuffer.allocate(16);
        if (buffer.isDirect()) {
            throw new RuntimeException("Non-direct buffer is direct!");
        }
        FloatBuffer bufferD = ByteBuffer.allocateDirect(64).asFloatBuffer();
        if (!bufferD.isDirect()) {
            throw new RuntimeException("Direct buffer is non-direct!");
        }
        float[] helper = new float[16];
        FloatBuffer bufferHelper = FloatBuffer.allocate(16);
        FloatBuffer bufferDHelper = ByteBuffer.allocateDirect(64).asFloatBuffer();
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            for (pos = 15; pos >= 0; --pos) {
                fArray[pos] = 1.0f;
            }
        }
        arrayResults.add(new Testresult("Loop-write array", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            Arrays.fill(fArray, 1.0f);
        }
        arrayResults.add(new Testresult("Arrays.fill", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            for (pos = 15; pos >= 0; --pos) {
                helper[pos] = fArray[pos];
            }
        }
        arrayResults.add(new Testresult("Loop-read array", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            System.arraycopy(fArray, 0, helper, 0, fArray.length);
        }
        arrayResults.add(new Testresult("System.arraycopy", System.nanoTime() - ns));
        bufferHelper.put(helper);
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            for (pos = 15; pos >= 0; --pos) {
                buffer.put(1.0f);
            }
        }
        bufferResults.add(new Testresult("Loop-put buffer", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            for (pos = 15; pos >= 0; --pos) {
                buffer.put(pos, 1.0f);
            }
        }
        bufferResults.add(new Testresult("Index-put buffer", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            buffer.put(helper);
        }
        bufferResults.add(new Testresult("Bulk-put array->buffer", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            buffer.put(bufferHelper);
        }
        bufferResults.add(new Testresult("Bulk-put buffer->buffer", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            buffer.put(bufferDHelper);
        }
        bufferResults.add(new Testresult("Bulk-put bufferD->buffer", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            for (pos = 15; pos >= 0; --pos) {
                value = buffer.get();
            }
        }
        bufferResults.add(new Testresult("Loop-get buffer", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            for (pos = 15; pos >= 0; --pos) {
                value = buffer.get(pos);
            }
        }
        bufferResults.add(new Testresult("Index-get buffer", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            buffer.rewind();
            buffer.get(helper);
        }
        bufferResults.add(new Testresult("Bulk-get buffer->array", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            for (pos = 15; pos >= 0; --pos) {
                bufferD.put(1.0f);
            }
        }
        bufferDResults.add(new Testresult("Loop-put bufferD", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            for (pos = 15; pos >= 0; --pos) {
                bufferD.put(pos, 1.0f);
            }
        }
        bufferDResults.add(new Testresult("Index-put bufferD", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            bufferD.put(helper);
        }
        bufferDResults.add(new Testresult("Bulk-put array->bufferD", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            bufferD.put(bufferHelper);
        }
        bufferDResults.add(new Testresult("Bulk-put buffer->bufferD", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            bufferD.put(bufferDHelper);
        }
        bufferDResults.add(new Testresult("Bulk-put bufferD->bufferD", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            for (pos = 15; pos >= 0; --pos) {
                value = bufferD.get();
            }
        }
        bufferDResults.add(new Testresult("Loop-get bufferD", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            for (pos = 15; pos >= 0; --pos) {
                value = bufferD.get(pos);
            }
        }
        bufferDResults.add(new Testresult("Index-get bufferD", System.nanoTime() - ns));
        ns = System.nanoTime();
        for (i = 10000000; i > 0; --i) {
            bufferD.rewind();
            bufferD.get(helper);
        }
        bufferDResults.add(new Testresult("Bulk-get bufferD->array", System.nanoTime() - ns));
        long largest = 0L;
        for (Testresult result : arrayResults) {
            largest = Math.max(largest, result.timeNS);
        }
        for (Testresult result : bufferResults) {
            largest = Math.max(largest, result.timeNS);
        }
        for (Testresult result : bufferDResults) {
            largest = Math.max(largest, result.timeNS);
        }
        System.out.println("-- Array tests -----------------------------------------");
        for (Testresult result : arrayResults) {
            result.out(largest);
        }
        System.out.println("-- Buffer tests ----------------------------------------");
        for (Testresult result : bufferResults) {
            result.out(largest);
        }
        System.out.println("-- Direct buffer tests ---------------------------------");
        for (Testresult result : bufferDResults) {
            result.out(largest);
        }
    }

    private static class Testresult {
        public final String description;
        public final long timeNS;

        public Testresult(String description, long timeNS) {
            this.description = description + ":";
            this.timeNS = timeNS;
        }

        public void out(long maxTimeNS) {
            double percent = (double)this.timeNS / (double)maxTimeNS * 100.0;
            System.out.printf("%-29s %15d ns %#6.2f%%%n", this.description, this.timeNS, percent);
        }
    }
}

