/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator.room;

import com.hbm.blocks.ModBlocks;
import com.hbm.world.generator.CellularDungeon;
import com.hbm.world.generator.CellularDungeonRoom;
import com.hbm.world.generator.DungeonToolbox;
import com.hbm.world.generator.JungleDungeon;
import com.hbm.world.generator.TimedGenerator;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class JungleDungeonRoom
extends CellularDungeonRoom {
    public JungleDungeonRoom(CellularDungeon parent) {
        super(parent);
    }

    @Override
    public void generateMain(final World world, final int x, final int y, final int z) {
        if (!(this.parent instanceof JungleDungeon)) {
            return;
        }
        TimedGenerator.ITimedJob job = new TimedGenerator.ITimedJob(){

            @Override
            public void work() {
                DungeonToolbox.generateBox(world, x, y, z, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.floor);
                DungeonToolbox.generateBox(world, x, y + 1, z, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.height - 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, Blocks.field_150350_a.func_176223_P());
                DungeonToolbox.generateBox(world, x, y + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.height - 1, z, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.ceiling);
                int rtd = world.field_73012_v.nextInt(50);
                if (rtd < 5) {
                    List<IBlockState> metas = Arrays.asList(ModBlocks.brick_jungle_cracked.func_176223_P(), ModBlocks.brick_jungle_lava.func_176223_P(), ModBlocks.brick_jungle_lava.func_176223_P());
                    DungeonToolbox.generateBox(world, x + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width / 2 - 1, y, z + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width / 2 - 1, 3, 1, 3, metas);
                } else if (rtd < 10) {
                    world.func_180501_a(new BlockPos(x + 1 + world.field_73012_v.nextInt(((JungleDungeonRoom)JungleDungeonRoom.this).parent.width - 1), y + 1, z + world.field_73012_v.nextInt(((JungleDungeonRoom)JungleDungeonRoom.this).parent.width - 1)), ModBlocks.crate_jungle.func_176223_P(), 2);
                } else if (rtd < 20 && !((JungleDungeon)((JungleDungeonRoom)JungleDungeonRoom.this).parent).hasHole) {
                    boolean punched = false;
                    for (int a = 0; a < 3; ++a) {
                        for (int b = 0; b < 3; ++b) {
                            Block bl = world.func_180495_p(new BlockPos(x + 1 + a, y - 4, z + 1 + b)).func_177230_c();
                            if (world.func_180495_p(new BlockPos(x + 1 + a, y - 1, z + 1 + b)).func_177230_c() != Blocks.field_150350_a || bl != ModBlocks.brick_jungle && bl != ModBlocks.brick_jungle_cracked && bl != ModBlocks.brick_jungle_lava && bl != ModBlocks.brick_jungle_trap) continue;
                            world.func_175698_g(new BlockPos(x + 1 + a, y, z + 1 + b));
                            punched = true;
                        }
                    }
                    if (punched) {
                        ((JungleDungeon)((JungleDungeonRoom)JungleDungeonRoom.this).parent).hasHole = true;
                    }
                }
            }
        };
        TimedGenerator.addOp(world, job);
    }

    @Override
    public void generateWall(final World world, final int x, final int y, final int z, final EnumFacing wall, final boolean door) {
        TimedGenerator.ITimedJob job = new TimedGenerator.ITimedJob(){

            @Override
            public void work() {
                if (wall == EnumFacing.NORTH) {
                    DungeonToolbox.generateBox(world, x, y + 1, z, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.height - 2, 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.wall);
                    if (door) {
                        DungeonToolbox.generateBox(world, x + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width / 2 - 1, y + 1, z, 3, 3, 1, Blocks.field_150350_a.func_176223_P());
                    }
                } else if (wall == EnumFacing.SOUTH) {
                    DungeonToolbox.generateBox(world, x, y + 1, z + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width - 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.height - 2, 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.wall);
                    if (door) {
                        DungeonToolbox.generateBox(world, x + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width / 2 - 1, y + 1, z + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width - 1, 3, 3, 1, Blocks.field_150350_a.func_176223_P());
                    }
                } else if (wall == EnumFacing.WEST) {
                    DungeonToolbox.generateBox(world, x, y + 1, z, 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.height - 2, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.wall);
                    if (door) {
                        DungeonToolbox.generateBox(world, x, y + 1, z + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width / 2 - 1, 1, 3, 3, Blocks.field_150350_a.func_176223_P());
                    }
                } else if (wall == EnumFacing.EAST) {
                    DungeonToolbox.generateBox(world, x + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width - 1, y + 1, z, 1, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.height - 2, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width, ((JungleDungeonRoom)JungleDungeonRoom.this).parent.wall);
                    if (door) {
                        DungeonToolbox.generateBox(world, x + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width - 1, y + 1, z + ((JungleDungeonRoom)JungleDungeonRoom.this).parent.width / 2 - 1, 1, 3, 3, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        };
        TimedGenerator.addOp(world, job);
    }
}

