/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator;

import com.hbm.blocks.ModBlocks;
import com.hbm.world.generator.CellularDungeon;
import com.hbm.world.generator.TimedGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class JungleDungeon
extends CellularDungeon {
    public boolean hasHole = false;

    public JungleDungeon(int width, int height, int dimX, int dimZ, int tries, int branches) {
        super(width, height, dimX, dimZ, tries, branches);
        this.floor.add(ModBlocks.brick_jungle.func_176223_P());
        this.floor.add(ModBlocks.brick_jungle_cracked.func_176223_P());
        this.wall.add(ModBlocks.brick_jungle.func_176223_P());
        this.wall.add(ModBlocks.brick_jungle_cracked.func_176223_P());
        this.ceiling.add(ModBlocks.brick_jungle.func_176223_P());
        this.ceiling.add(ModBlocks.brick_jungle_cracked.func_176223_P());
    }

    @Override
    public void generate(World world, int x, int y, int z, Random rand) {
        super.generate(world, x, y, z, rand);
        TimedGenerator.addOp(world, () -> {
            JungleDungeon that = this;
            if (!that.hasHole) {
                this.generateCircleRoom(world, x, y, z);
                this.connectCircleRoomToDungeon(world, x, y, z);
            }
            that.hasHole = false;
        });
    }

    public void generateCircleRoom(World world, int x, int y, int z) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(x, y, z);
        for (int i = 0; i < 5; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -2; k < 3; ++k) {
                    p.func_181079_c(x + j, y + i, z + k);
                    if (i > 0 && i < 4 && Math.abs(j) < 2 && Math.abs(k) < 2) {
                        world.func_175698_g((BlockPos)p);
                        continue;
                    }
                    if (i == 0) {
                        if (j == 0 && k == 0) {
                            world.func_175656_a((BlockPos)p, ModBlocks.brick_jungle_circle.func_176223_P());
                            continue;
                        }
                        if (Math.abs(j) == 2 || Math.abs(k) == 2) {
                            world.func_175656_a((BlockPos)p, ModBlocks.brick_dungeon_flat.func_176223_P());
                            continue;
                        }
                        world.func_175656_a((BlockPos)p, ModBlocks.brick_jungle.func_176223_P());
                        continue;
                    }
                    if (i == 2 && (j == 0 || k == 0)) {
                        world.func_175656_a((BlockPos)p, ModBlocks.brick_dungeon_tile.func_176223_P());
                        continue;
                    }
                    if (i == 4 || Math.abs(j) == 2 && Math.abs(k) == 2) {
                        world.func_175656_a((BlockPos)p, ModBlocks.brick_jungle.func_176223_P());
                        continue;
                    }
                    world.func_175656_a((BlockPos)p, ModBlocks.brick_dungeon.func_176223_P());
                }
            }
        }
    }

    public int getDungeonDistance(World world, int x, int y, int z, EnumFacing dir) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(x, y, z);
        for (int i = 0; i < 100; ++i) {
            p.func_189536_c(dir);
            Block b = world.func_180495_p((BlockPos)p).func_177230_c();
            if (b != ModBlocks.brick_jungle && b != ModBlocks.brick_jungle_cracked) continue;
            return i;
        }
        return -1;
    }

    public void buildTunnel(World world, int x, int y, int z, int dist, EnumFacing dir, Block b) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(x, y, z);
        boolean isNorthSouth = dir.func_82601_c() != 0;
        for (int i = 0; i < dist; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -2; k < 3; ++k) {
                    BlockPos bp = p.func_177982_a(isNorthSouth ? 0 : j, k, isNorthSouth ? j : 0);
                    if (Math.abs(j) == 2 || Math.abs(k) == 2) {
                        world.func_175656_a(bp, b.func_176223_P());
                        continue;
                    }
                    world.func_175698_g(bp);
                }
            }
            p.func_189536_c(dir);
        }
    }

    public void connectCircleRoomToDungeon(World world, int x, int y, int z) {
        EnumFacing direction = null;
        int distance = 200;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            Block b = world.func_180495_p(new BlockPos(x, y, z).func_177967_a(dir, 3)).func_177230_c();
            if (b == ModBlocks.brick_jungle || b == ModBlocks.brick_jungle_cracked) {
                return;
            }
            int d = this.getDungeonDistance(world, x, y + 2, z, dir);
            if (d <= 0 || d >= distance) continue;
            distance = d;
            direction = dir;
        }
        if (direction != null && distance > 3) {
            this.buildTunnel(world, x + direction.func_82601_c() * 3, y + 2, z + direction.func_82599_e() * 3, distance - 1, direction, ModBlocks.brick_jungle);
        }
    }
}

