/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.inventory.AnvilRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.util.ItemStackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtil {
    public static ItemStack tryAddItemToInventory(ItemStack[] inv, int start, int end, ItemStack stack) {
        ItemStack rem = InventoryUtil.tryAddItemToExistingStack(inv, start, end, stack);
        if (rem == null || rem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean didAdd = InventoryUtil.tryAddItemToNewSlot(inv, start, end, rem);
        if (didAdd) {
            return ItemStack.field_190927_a;
        }
        return rem;
    }

    public static ItemStack tryAddItemToExistingStack(ItemStack[] inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int i = start; i <= end; ++i) {
            int transfer;
            if (!InventoryUtil.doesStackDataMatch(inv[i], stack) || (transfer = Math.min(stack.func_190916_E(), inv[i].func_77976_d() - inv[i].func_190916_E())) <= 0) continue;
            inv[i].func_190920_e(inv[i].func_190916_E() + transfer);
            stack.func_190920_e(stack.func_190916_E() - transfer);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean tryAddItemToNewSlot(ItemStack[] inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return true;
        }
        for (int i = start; i <= end; ++i) {
            if (inv[i] != null && !inv[i].func_190926_b()) continue;
            inv[i] = stack;
            return true;
        }
        return false;
    }

    public static ItemStack tryAddItemToInventory(IItemHandlerModifiable inv, int start, int end, ItemStack stack) {
        ItemStack rem = InventoryUtil.tryAddItemToExistingStack(inv, start, end, stack);
        if (rem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean didAdd = InventoryUtil.tryAddItemToNewSlot(inv, start, end, rem);
        if (didAdd) {
            return ItemStack.field_190927_a;
        }
        return rem;
    }

    public static ItemStack tryAddItemToExistingStack(IItemHandlerModifiable inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int i = start; i <= end; ++i) {
            int transfer;
            if (!InventoryUtil.doesStackDataMatch(inv.getStackInSlot(i), stack) || (transfer = Math.min(stack.func_190916_E(), inv.getStackInSlot(i).func_77976_d() - inv.getStackInSlot(i).func_190916_E())) <= 0) continue;
            inv.getStackInSlot(i).func_190920_e(inv.getStackInSlot(i).func_190916_E() + transfer);
            stack.func_190920_e(stack.func_190916_E() - transfer);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean tryAddItemToNewSlot(IItemHandlerModifiable inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return true;
        }
        for (int i = start; i <= end; ++i) {
            if (!inv.getStackInSlot(i).func_190926_b()) continue;
            inv.setStackInSlot(i, stack);
            return true;
        }
        return false;
    }

    public static boolean doesStackDataMatch(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null && stack2 != null) {
            return false;
        }
        if (stack1 != null && stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (!stack1.func_77942_o() && !stack2.func_77942_o()) {
            return true;
        }
        if (stack1.func_77942_o() && !stack2.func_77942_o()) {
            return false;
        }
        if (!stack1.func_77942_o() && stack2.func_77942_o()) {
            return false;
        }
        return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
    }

    public static boolean doesPlayerHaveAStacks(EntityPlayer player, List<RecipesCommon.AStack> stacks, boolean shouldRemove) {
        int i;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        NonNullList original = player.field_71071_by.field_70462_a;
        ItemStack[] inventory = new ItemStack[original.size()];
        RecipesCommon.AStack[] input = new RecipesCommon.AStack[stacks.size()];
        for (i = 0; i < input.length; ++i) {
            input[i] = stacks.get(i).copy();
        }
        for (i = 0; i < original.size(); ++i) {
            inventory[i] = ((ItemStack)original.get(i)).func_77946_l();
        }
        block2: for (i = 0; i < input.length; ++i) {
            RecipesCommon.AStack stack = input[i];
            for (int j = 0; j < inventory.length; ++j) {
                ItemStack inv = inventory[j];
                if (!stack.matchesRecipe(inv, true)) continue;
                int size = Math.min(stack.count(), inv.func_190916_E());
                stack.setCount(stack.count() - size);
                inv.func_190920_e(inv.func_190916_E() - size);
                if (stack.count() <= 0) {
                    input[i] = null;
                    continue block2;
                }
                if (inv.func_190916_E() > 0) continue;
                inventory[j] = ItemStack.field_190927_a;
            }
        }
        for (RecipesCommon.AStack stack : input) {
            if (stack == null) continue;
            return false;
        }
        if (shouldRemove) {
            for (int i2 = 0; i2 < original.size(); ++i2) {
                if (inventory[i2] != null && inventory[i2].func_190916_E() <= 0) {
                    original.set(i2, (Object)ItemStack.field_190927_a);
                    continue;
                }
                original.set(i2, (Object)inventory[i2]);
            }
        }
        return true;
    }

    public static void giveChanceStacksToPlayer(EntityPlayer player, List<AnvilRecipes.AnvilOutput> stacks) {
        for (AnvilRecipes.AnvilOutput out : stacks) {
            if (out.chance != 1.0f && !(player.func_70681_au().nextFloat() < out.chance) || player.field_71071_by.func_70441_a(out.stack.func_77946_l())) continue;
            player.func_71019_a(out.stack.func_77946_l(), false);
        }
    }

    public static boolean hasOreDictMatches(EntityPlayer player, String dict, int count) {
        return InventoryUtil.countOreDictMatches(player, dict) >= count;
    }

    public static int countOreDictMatches(EntityPlayer player, String dict) {
        int count = 0;
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            int[] ids;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack == null) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)id).equals(dict)) continue;
                count += stack.func_190916_E();
                continue block0;
            }
        }
        return count;
    }

    public static void consumeOreDictMatches(EntityPlayer player, String dict, int count) {
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            int[] ids;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack == null) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)id).equals(dict)) continue;
                int toConsume = Math.min(count, stack.func_190916_E());
                player.field_71071_by.func_70298_a(i, toConsume);
                count -= toConsume;
                continue block0;
            }
        }
    }

    public static boolean doesArrayHaveIngredients(IItemHandler inv, int start, int end, List<RecipesCommon.AStack> ingredients) {
        ItemStack[] copy = ItemStackUtil.carefulCopyArrayTruncate(inv, start, end);
        RecipesCommon.AStack[] req = new RecipesCommon.AStack[ingredients.size()];
        for (int idx = 0; idx < req.length; ++idx) {
            req[idx] = ingredients.get(idx) == null ? null : ingredients.get(idx).copy();
        }
        for (RecipesCommon.AStack ingredient : req) {
            if (ingredient == null) continue;
            for (ItemStack input : copy) {
                if (input == null || input.func_190926_b() || !ingredient.matchesRecipe(input, true)) continue;
                int size = Math.min(input.func_190916_E(), ingredient.count());
                ingredient.setCount(ingredient.count() - size);
                input.func_190920_e(input.func_190916_E() - size);
                if (ingredient.count() == 0) break;
            }
            if (ingredient.count() <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean doesArrayHaveIngredients(IItemHandler inv, int start, int end, RecipesCommon.AStack ... ingredients) {
        return InventoryUtil.doesArrayHaveIngredients(inv, start, end, Arrays.asList(ingredients));
    }

    public static boolean doesArrayHaveSpace(IItemHandler inv, int start, int end, ItemStack[] items) {
        ItemStack[] copy = ItemStackUtil.carefulCopyArrayTruncate(inv, start, end);
        for (ItemStack item : items) {
            ItemStack remainder;
            if (item.func_190926_b() || (remainder = InventoryUtil.tryAddItemToInventory(copy, 0, copy.length - 1, item.func_77946_l())).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean tryConsumeAStack(IItemHandlerModifiable inv, int start, int end, RecipesCommon.AStack stack) {
        RecipesCommon.AStack copy = stack.copy();
        for (int i = start; i <= end; ++i) {
            ItemStack input = inv.getStackInSlot(i);
            if (!stack.matchesRecipe(input, true)) continue;
            int size = Math.min(copy.count(), input.func_190916_E());
            inv.extractItem(i, size, false);
            copy.setCount(copy.count() - size);
            if (copy.count() != 0) continue;
            return true;
        }
        return false;
    }
}

