/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.block.ICrucibleAcceptor;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.lib.ForgeDirection;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CrucibleUtil {
    public static Mats.MaterialStack pourSingleStack(World world, double x, double y, double z, double range, boolean safe, Mats.MaterialStack stack, int quanta, Vec3 impactPosHolder) {
        RayTraceResult[] mopHolder = new RayTraceResult[1];
        ICrucibleAcceptor acc = CrucibleUtil.getPouringTarget(world, new Vec3d(x, y, z), new Vec3d(x, y - range, z), mopHolder);
        RayTraceResult mop = mopHolder[0];
        if (acc == null) {
            CrucibleUtil.spill(mop, safe, stack, quanta, impactPosHolder);
            return stack;
        }
        Mats.MaterialStack ret = CrucibleUtil.tryPourStack(world, acc, mop, stack, impactPosHolder);
        if (ret != null) {
            return ret;
        }
        CrucibleUtil.spill(mop, safe, stack, quanta, impactPosHolder);
        return stack;
    }

    public static Mats.MaterialStack pourFullStack(World world, double x, double y, double z, double range, boolean safe, List<Mats.MaterialStack> stacks, int quanta, Vec3 impactPosHolder) {
        if (stacks.isEmpty()) {
            return null;
        }
        RayTraceResult[] mopHolder = new RayTraceResult[1];
        ICrucibleAcceptor acc = CrucibleUtil.getPouringTarget(world, new Vec3d(x, y, z), new Vec3d(x, y - range, z), mopHolder);
        RayTraceResult mop = mopHolder[0];
        if (acc == null) {
            return CrucibleUtil.spill(mop, safe, stacks, quanta, impactPosHolder);
        }
        for (Mats.MaterialStack stack : stacks) {
            int amountToPour = Math.min(stack.amount, quanta);
            Mats.MaterialStack toPour = new Mats.MaterialStack(stack.material, amountToPour);
            Mats.MaterialStack left = CrucibleUtil.tryPourStack(world, acc, mop, toPour, impactPosHolder);
            if (left == null) continue;
            stack.amount -= amountToPour - left.amount;
            return new Mats.MaterialStack(stack.material, stack.amount - left.amount);
        }
        return CrucibleUtil.spill(mop, safe, stacks, quanta, impactPosHolder);
    }

    public static Mats.MaterialStack tryPourStack(World world, ICrucibleAcceptor acc, RayTraceResult mop, Mats.MaterialStack stack, Vec3 impactPosHolder) {
        Vec3d hit = mop.field_72307_f;
        if (stack.material.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) {
            return null;
        }
        if (acc.canAcceptPartialPour(world, mop.func_178782_a(), hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, ForgeDirection.getOrientation(mop.field_178784_b), stack)) {
            Mats.MaterialStack left = acc.pour(world, mop.func_178782_a(), hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, ForgeDirection.getOrientation(mop.field_178784_b), stack);
            if (left == null) {
                left = new Mats.MaterialStack(stack.material, 0);
            }
            impactPosHolder.xCoord = hit.field_72450_a;
            impactPosHolder.yCoord = hit.field_72448_b;
            impactPosHolder.zCoord = hit.field_72449_c;
            return left;
        }
        return null;
    }

    public static ICrucibleAcceptor getPouringTarget(World world, Vec3d start, Vec3d end, RayTraceResult[] mopHolder) {
        RayTraceResult mop = world.func_147447_a(start, end, true, true, true);
        if (mopHolder != null) {
            mopHolder[0] = mop;
        }
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        Block b = world.func_180495_p(mop.func_178782_a()).func_177230_c();
        if (!(b instanceof ICrucibleAcceptor)) {
            return null;
        }
        return (ICrucibleAcceptor)b;
    }

    public static Mats.MaterialStack spill(RayTraceResult mop, boolean safe, List<Mats.MaterialStack> stacks, int quanta, Vec3 impactPos) {
        Mats.MaterialStack top = stacks.get(0);
        Mats.MaterialStack ret = CrucibleUtil.spill(mop, safe, top, quanta, impactPos);
        stacks.removeIf(o -> o.amount <= 0);
        return ret;
    }

    public static Mats.MaterialStack spill(RayTraceResult mop, boolean safe, Mats.MaterialStack stack, int quanta, Vec3 impactPos) {
        if (safe) {
            return null;
        }
        Mats.MaterialStack toWaste = new Mats.MaterialStack(stack.material, Math.min(stack.amount, quanta));
        stack.amount -= toWaste.amount;
        if (impactPos != null && mop != null) {
            impactPos.xCoord = mop.field_72307_f.field_72450_a;
            impactPos.yCoord = mop.field_72307_f.field_72448_b;
            impactPos.zCoord = mop.field_72307_f.field_72449_c;
        }
        return toWaste;
    }
}

