/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network.energy;

import api.hbm.energy.IEnergyConductor;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEPylonSenderPacket;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.network.energy.TileEntityCableBaseNT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityPylonBase
extends TileEntityCableBaseNT {
    public List<BlockPos> connected = new ArrayList<BlockPos>();

    public static boolean canConnect(TileEntityPylonBase first, TileEntityPylonBase second) {
        if (first.getConnectionType() != second.getConnectionType()) {
            return false;
        }
        if (first == second) {
            return false;
        }
        double len = Math.min(first.getMaxWireLength(), second.getMaxWireLength());
        BlockPos firstPos = first.getConnectionPoint();
        BlockPos secondPos = second.getConnectionPoint();
        Vec3 delta = Vec3.createVectorHelper(secondPos.func_177958_n() - firstPos.func_177958_n(), secondPos.func_177956_o() - firstPos.func_177956_o(), secondPos.func_177952_p() - firstPos.func_177952_p());
        return len >= delta.length();
    }

    public void addConnection(BlockPos targetPos) {
        if (this.connected.contains(targetPos)) {
            return;
        }
        this.connected.add(targetPos);
        if (this.getPowerNet() != null) {
            this.getPowerNet().reevaluate();
            this.network = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEPylonSenderPacket(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), true), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
        }
        this.func_70296_d();
    }

    public void removeConnection(BlockPos pos) {
        this.connected.remove(pos);
    }

    public void disconnect(BlockPos targetPos) {
        TileEntity te = this.field_145850_b.func_175625_s(targetPos);
        if (te == this) {
            return;
        }
        if (te instanceof TileEntityPylonBase) {
            TileEntityPylonBase pylon = (TileEntityPylonBase)te;
            if (pylon.connected.contains(this.field_174879_c)) {
                pylon.removeConnection(this.field_174879_c);
                if (!this.field_145850_b.field_72995_K) {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEPylonSenderPacket(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), false), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
                }
                pylon.func_70296_d();
            }
        }
    }

    public void disconnectAll() {
        for (BlockPos targetPos : this.connected) {
            this.disconnect(targetPos);
        }
    }

    @Override
    protected void connect() {
        for (BlockPos targetPos : this.getConnectionPoints()) {
            TileEntity te = this.field_145850_b.func_175625_s(targetPos);
            if (!(te instanceof IEnergyConductor)) continue;
            IEnergyConductor conductor = (IEnergyConductor)te;
            if (this.getPowerNet() == null && conductor.getPowerNet() != null) {
                conductor.getPowerNet().joinLink(this);
            }
            if (this.getPowerNet() == null || conductor.getPowerNet() == null || this.getPowerNet() == conductor.getPowerNet()) continue;
            conductor.getPowerNet().joinNetworks(this.getPowerNet());
        }
    }

    @Override
    public List<BlockPos> getConnectionPoints() {
        return new ArrayList<BlockPos>(this.connected);
    }

    public abstract ConnectionType getConnectionType();

    public abstract Vec3[] getMountPos();

    public abstract int getMaxWireLength();

    public BlockPos getConnectionPoint() {
        Vec3[] mounts = this.getMountPos();
        if (mounts == null || mounts.length == 0) {
            return this.field_174879_c.func_177963_a(0.5, 0.5, 0.5);
        }
        return mounts[0].toBlockPos().func_177971_a((Vec3i)this.field_174879_c);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        int[] conX = new int[this.connected.size()];
        int[] conY = new int[this.connected.size()];
        int[] conZ = new int[this.connected.size()];
        for (int i = 0; i < this.connected.size(); ++i) {
            conX[i] = this.connected.get(i).func_177958_n();
            conY[i] = this.connected.get(i).func_177956_o();
            conZ[i] = this.connected.get(i).func_177952_p();
        }
        nbt.func_74783_a("conX", conX);
        nbt.func_74783_a("conY", conY);
        nbt.func_74783_a("conZ", conZ);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.connected.clear();
        int[] conX = nbt.func_74759_k("conX");
        int[] conY = nbt.func_74759_k("conY");
        int[] conZ = nbt.func_74759_k("conZ");
        BlockPos[] con = new BlockPos[conX.length];
        for (int i = 0; i < conX.length; ++i) {
            this.connected.add(new BlockPos(conX[i], conY[i], conZ[i]));
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static enum ConnectionType {
        SINGLE,
        QUAD;

    }
}

