/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.block.IConveyorBelt;
import com.hbm.entity.item.EntityMovingPackage;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneBoxer;
import com.hbm.inventory.gui.GUICraneBoxer;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityCraneBoxer
extends TileEntityCraneBase
implements IGUIProvider,
IControlReceiver {
    public byte mode = 0;
    public static final byte MODE_1 = 0;
    public static final byte MODE_2 = 1;
    public static final byte MODE_4 = 2;
    public static final byte MODE_8 = 3;
    public static final byte MODE_16 = 4;
    public static final byte MODE_REDSTONE = 5;
    private int tickCounter = 0;
    public static int[] allowed_slots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    private boolean lastRedstone = false;

    public TileEntityCraneBoxer() {
        super(21);
    }

    @Override
    public String getName() {
        return "container.craneBoxer";
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            ItemStack[] box;
            ++this.tickCounter;
            int xCoord = this.field_174879_c.func_177958_n();
            int yCoord = this.field_174879_c.func_177956_o();
            int zCoord = this.field_174879_c.func_177952_p();
            boolean redstone = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.mode == 5 && redstone && !this.lastRedstone && this.tickCounter % 10 == 0) {
                this.tickCounter = 0;
                EnumFacing outputSide = this.getOutputSide();
                BlockPos outputPos = this.field_174879_c.func_177972_a(outputSide);
                Block block = this.field_145850_b.func_180495_p(outputPos).func_177230_c();
                IConveyorBelt belt = null;
                if (block instanceof IConveyorBelt) {
                    belt = (IConveyorBelt)block;
                }
                int pack = 0;
                for (int index : allowed_slots) {
                    ItemStack stack2 = this.inventory.getStackInSlot(index);
                    if (stack2.func_190926_b()) continue;
                    ++pack;
                }
                if (belt != null && pack > 0) {
                    box = new ItemStack[pack];
                    for (int index : allowed_slots) {
                        if (pack <= 0 || (stack = this.inventory.getStackInSlot(index)).func_190926_b()) continue;
                        box[--pack] = stack.func_77946_l();
                        this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
                    }
                    EntityMovingPackage moving = new EntityMovingPackage(this.field_145850_b);
                    Vec3d pos = new Vec3d((double)xCoord + 0.5 + (double)outputSide.func_176730_m().func_177958_n() * 0.55, (double)yCoord + 0.5 + (double)outputSide.func_176730_m().func_177956_o() * 0.55, (double)zCoord + 0.5 + (double)outputSide.func_176730_m().func_177952_p() * 0.55);
                    Vec3d snap = belt.getClosestSnappingPosition(this.field_145850_b, outputPos, pos);
                    moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                    moving.setItemStacks(box);
                    this.field_145850_b.func_72838_d((Entity)moving);
                }
            }
            this.lastRedstone = redstone;
            if (this.mode != 5 && this.tickCounter % 10 == 0) {
                int n;
                this.tickCounter = 0;
                switch (this.mode) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 8;
                        break;
                    }
                    case 4: {
                        n = 16;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int pack = n;
                int fullStacks = 0;
                for (int index : allowed_slots) {
                    ItemStack stack3 = this.inventory.getStackInSlot(index);
                    if (stack3.func_190926_b() || stack3.func_190916_E() != stack3.func_77976_d()) continue;
                    ++fullStacks;
                }
                EnumFacing enumFacing = this.getOutputSide();
                Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(enumFacing)).func_177230_c();
                IConveyorBelt belt = null;
                if (b instanceof IConveyorBelt) {
                    belt = (IConveyorBelt)b;
                }
                if (belt != null && fullStacks >= pack) {
                    box = new ItemStack[pack];
                    for (int index : allowed_slots) {
                        stack = this.inventory.getStackInSlot(index);
                        if (stack.func_190926_b() || stack.func_190916_E() != stack.func_77976_d() || --pack < 0) continue;
                        box[pack] = stack.func_77946_l();
                        this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
                    }
                    EntityMovingPackage moving = new EntityMovingPackage(this.field_145850_b);
                    Vec3d posV = new Vec3d((double)xCoord + 0.5 + (double)enumFacing.func_176730_m().func_177958_n() * 0.55, (double)yCoord + 0.5 + (double)enumFacing.func_176730_m().func_177956_o() * 0.55, (double)zCoord + 0.5 + (double)enumFacing.func_176730_m().func_177952_p() * 0.55);
                    Vec3d snap = belt.getClosestSnappingPosition(this.field_145850_b, this.field_174879_c.func_177972_a(enumFacing), posV);
                    moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                    moving.setItemStacks(box);
                    this.field_145850_b.func_72838_d((Entity)moving);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("mode", this.mode);
            this.networkPack(data, 15);
        }
    }

    public void tryFillTe() {
        EnumFacing outputSide = this.getOutputSide();
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(outputSide));
        int meta = this.func_145832_p();
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputSide)) {
            IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputSide);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.tryFillContainerCap(cap, i);
            }
        }
    }

    public boolean tryFillTeDirect(ItemStack stack) {
        return this.tryInsertItemCap((IItemHandler)this.inventory, stack);
    }

    public boolean tryFillContainerCap(IItemHandler chest, int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        return this.tryInsertItemCap(chest, this.inventory.getStackInSlot(slot));
    }

    public boolean tryInsertItemCap(IItemHandler chest, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack outputStack = stack.func_77946_l();
            if (outputStack.func_190926_b() || outputStack.func_190916_E() == 0) {
                return true;
            }
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            int fillAmount = Math.min(chestItem.func_77976_d() - chestItem.func_190916_E(), outputStack.func_190916_E());
            outputStack.func_190920_e(fillAmount);
            ItemStack rest = chest.insertItem(i, outputStack, true);
            if (rest.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a)) continue;
            stack.func_190918_g(outputStack.func_190916_E());
            chest.insertItem(i, outputStack, false);
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return allowed_slots;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneBoxer(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        int xCoord = this.field_174879_c.func_177958_n();
        int yCoord = this.field_174879_c.func_177956_o();
        int zCoord = this.field_174879_c.func_177952_p();
        return new Vec3d((double)xCoord - player.field_70165_t, (double)yCoord - player.field_70163_u, (double)zCoord - player.field_70161_v).func_72433_c() < 20.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneBoxer(player.field_71071_by, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74771_c("mode");
        this.lastRedstone = nbt.func_74767_n("lastRedstone");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("mode", this.mode);
        nbt.func_74757_a("lastRedstone", this.lastRedstone);
        return nbt;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            this.mode = (byte)((this.mode + 1) % 6);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.mode = nbt.func_74771_c("mode");
    }
}

