/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.VacuumDistillRecipes;
import com.hbm.inventory.container.ContainerMachineVacuumDistill;
import com.hbm.inventory.gui.GUIMachineVacuumDistill;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineVacuumDistill
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IFluidHandler,
IEnergyUser,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks = new FluidTank[5];
    private AudioWrapper audio;
    private int audioTime;
    public boolean isOn;
    AxisAlignedBB bb = null;

    public TileEntityMachineVacuumDistill() {
        super(12);
        this.tanks[0] = new FluidTank(64000);
        this.tanks[1] = new FluidTank(24000);
        this.tanks[2] = new FluidTank(24000);
        this.tanks[3] = new FluidTank(24000);
        this.tanks[4] = new FluidTank(24000);
    }

    @Override
    public String getName() {
        return "container.vacuumDistill";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.isOn = false;
            this.updateConnections();
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 1000000L);
            this.tryMoveBattery();
            if (this.inputValidForRecipe()) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 2, 3);
            }
            this.refine();
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 4, 5);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[2], 6, 7);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[3], 8, 9);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[4], 10, 11);
            for (DirPos pos : this.getConPos()) {
                for (int i = 1; i < 5; ++i) {
                    if (this.tanks[i].getFluidAmount() <= 0) continue;
                    FFUtils.fillFluid(this, this.tanks[i], this.field_145850_b, pos.getPos(), 6000);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74757_a("isOn", this.isOn);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            this.networkPack(data, 150);
        } else if (this.isOn) {
            this.audioTime = 20;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    protected boolean inputValidForRecipe() {
        FluidStack containerFluid;
        if (!this.inventory.getStackInSlot(2).func_190926_b() && (containerFluid = FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(2))) != null) {
            return VacuumDistillRecipes.getVacuum(containerFluid.getFluid()) != null;
        }
        return false;
    }

    private void refine() {
        int i;
        if (this.tanks[0].getFluid() == null) {
            return;
        }
        Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack> refinery = VacuumDistillRecipes.getVacuum(this.tanks[0].getFluid().getFluid());
        if (refinery == null) {
            return;
        }
        FluidStack[] stacks = new FluidStack[]{refinery.getW(), refinery.getX(), refinery.getY(), refinery.getZ()};
        if (this.power < 10000L) {
            return;
        }
        if (this.tanks[0].getFluidAmount() < 100) {
            return;
        }
        for (i = 0; i < stacks.length; ++i) {
            if (this.tanks[i + 1].getFluid() == null) continue;
            if (this.tanks[i + 1].getFluid().getFluid() != stacks[i].getFluid()) {
                return;
            }
            if (this.tanks[i + 1].getFluidAmount() + stacks[i].amount <= this.tanks[i + 1].getCapacity()) continue;
            return;
        }
        this.isOn = true;
        this.power -= 10000L;
        this.tanks[0].drain(100, true);
        for (i = 0; i < stacks.length; ++i) {
            this.tanks[i + 1].fill(stacks[i], true);
        }
    }

    public void tryMoveBattery() {
        IBatteryItem itemDrain;
        ItemStack itemStackDrain = this.inventory.getStackInSlot(0);
        Item item = itemStackDrain.func_77973_b();
        if (item instanceof IBatteryItem && (itemDrain = (IBatteryItem)item).getCharge(itemStackDrain) == 0L) {
            this.inventory.getStackInSlot(1);
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.setStackInSlot(1, itemStackDrain);
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2, Library.NEG_Z), new DirPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2, Library.NEG_Z)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 9), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineVacuumDistill(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineVacuumDistill(player.field_71071_by, this);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 5) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
            this.tanks[2].readFromNBT(tags[2]);
            this.tanks[3].readFromNBT(tags[3]);
            this.tanks[4].readFromNBT(tags[4]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0], this.tanks[3].getTankProperties()[0], this.tanks[4].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (VacuumDistillRecipes.getVacuum(resource.getFluid()) != null && (this.tanks[0].getFluid() == null || resource.isFluidEqual(this.tanks[0].getFluid()))) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.isFluidEqual(this.tanks[1].getFluid())) {
            return this.tanks[1].drain(resource.amount, doDrain);
        }
        if (resource.isFluidEqual(this.tanks[2].getFluid())) {
            return this.tanks[2].drain(resource.amount, doDrain);
        }
        if (resource.isFluidEqual(this.tanks[3].getFluid())) {
            return this.tanks[3].drain(resource.amount, doDrain);
        }
        if (resource.isFluidEqual(this.tanks[4].getFluid())) {
            return this.tanks[4].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks[1].getFluid() != null) {
            return this.tanks[1].drain(maxDrain, doDrain);
        }
        if (this.tanks[2].getFluid() != null) {
            return this.tanks[2].drain(maxDrain, doDrain);
        }
        if (this.tanks[3].getFluid() != null) {
            return this.tanks[3].drain(maxDrain, doDrain);
        }
        if (this.tanks[4].getFluid() != null) {
            return this.tanks[4].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

