/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachinePumpjack;
import com.hbm.config.MachineConfig;
import com.hbm.entity.particle.EntityGasFX;
import com.hbm.forgefluid.FFUtils;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEPumpjackPacket;
import com.hbm.tileentity.machine.oil.TileEntityOilDrillBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachinePumpjack
extends TileEntityOilDrillBase {
    public boolean isProgressing;
    public float rotation;
    public float prevRotation;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.getCustomName() : "container.pumpjack";
    }

    @Override
    public long getMaxPower() {
        return 200000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.rotation = compound.func_74760_g("rotation");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74776_a("rotation", this.rotation);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        int timer = MachineConfig.delayPerOperationPumpjack;
        this.prevRotation = this.rotation;
        ++this.age;
        ++this.age2;
        if (this.age >= timer) {
            this.age -= timer;
        }
        if (this.age2 >= 20) {
            this.age2 -= 20;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            int tank0Amount = this.tanks[0].getFluidAmount();
            int tank1Amount = this.tanks[1].getFluidAmount();
            if (this.age2 == 9 || this.age2 == 19) {
                this.fillFluidInit(this.tanks[0]);
                this.fillFluidInit(this.tanks[1]);
            }
            if (FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 1, 2)) {
                this.needsUpdate = true;
            }
            if (FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 3, 4)) {
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, this.getMaxPower());
            if (this.power >= (long)MachineConfig.powerConsumptionPerOperationPumpjack && tank0Amount < this.tanks[0].getCapacity() && tank1Amount < this.tanks[1].getCapacity()) {
                if (this.age == timer - 1) {
                    this.warning = 0;
                    for (int i = this.field_174879_c.func_177956_o() - 1; i > this.field_174879_c.func_177956_o() - 1 - 250; --i) {
                        if (i <= 0) {
                            this.warning = 2;
                            break;
                        }
                        Block b = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p())).func_177230_c();
                        if (b == ModBlocks.oil_pipe) continue;
                        if ((b.func_176200_f((IBlockAccess)this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p())) || b.func_149638_a(null) < 1000.0f) && b != ModBlocks.ore_oil && b != ModBlocks.ore_oil_empty && b != ModBlocks.ore_bedrock_oil) {
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p()), ModBlocks.oil_pipe.func_176223_P());
                            if (i != this.field_174879_c.func_177956_o() - 250) break;
                            this.warning = 2;
                            break;
                        }
                        if (this.tanks[0].getFluidAmount() < this.tanks[0].getCapacity() && this.tanks[1].getFluidAmount() < this.tanks[1].getCapacity()) {
                            if (this.succ(this.field_174879_c.func_177958_n(), i, this.field_174879_c.func_177952_p()) == 1) {
                                int oilCollected = MachineConfig.oilPerDepositBlockMinPumpjack + (MachineConfig.oilPerDepositBlockMaxExtraPumpjack > 0 ? this.field_145850_b.field_73012_v.nextInt(MachineConfig.oilPerDepositBlockMaxExtraPumpjack) : 0);
                                int gasCollected = MachineConfig.gasPerDepositBlockMinPumpjack + (MachineConfig.gasPerDepositBlockMaxExtraPumpjack > 0 ? this.field_145850_b.field_73012_v.nextInt(MachineConfig.gasPerDepositBlockMaxExtraPumpjack) : 0);
                                this.tanks[0].fill(new FluidStack(this.tankTypes[0], oilCollected), true);
                                this.tanks[1].fill(new FluidStack(this.tankTypes[1], gasCollected), true);
                                this.needsUpdate = true;
                                break;
                            }
                            this.warning = 2;
                            break;
                        }
                        this.warning = 1;
                        break;
                    }
                }
                this.power -= (long)MachineConfig.powerConsumptionPerOperationPumpjack;
            } else {
                this.warning = 1;
            }
            this.warning2 = 0;
            if (this.tanks[1].getFluidAmount() > 0) {
                if (this.inventory.getStackInSlot(5).func_77973_b() == ModItems.fuse || this.inventory.getStackInSlot(5).func_77973_b() == ModItems.screwdriver) {
                    this.warning2 = 2;
                    this.tanks[1].drain(50, true);
                    this.needsUpdate = true;
                    this.field_145850_b.func_72838_d((Entity)new EntityGasFX(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 6.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, 0.0, 0.0, 0.0));
                } else {
                    this.warning2 = 1;
                }
            }
            this.isProgressing = this.warning == 0;
            this.rotation += (float)(this.warning == 0 ? 5 : 0);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEPumpjackPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.rotation, this.isProgressing), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (tank0Amount != this.tanks[0].getFluidAmount() || tank1Amount != this.tanks[1].getFluidAmount()) {
                this.func_70296_d();
            }
        }
    }

    protected void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)MachinePumpjack.FACING)).ordinal());
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * 2 + dir.offsetX * 2, 0, rot.offsetZ * 2 + dir.offsetZ * 2), dir);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * 2 + dir.offsetX * 2, 0, rot.offsetZ * 4 - dir.offsetZ * 2), dir.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * 4 - dir.offsetX * 2, 0, rot.offsetZ * 4 + dir.offsetZ * 2), dir);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * 4 - dir.offsetX * 2, 0, rot.offsetZ * 2 - dir.offsetZ * 2), dir.getOpposite());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void fillFluidInit(FluidTank tank) {
        EnumFacing e = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)MachinePumpjack.FACING);
        if ((e = e.func_176746_e()) == EnumFacing.EAST) {
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, -2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-4, 0, 2), 2000) || this.needsUpdate;
            boolean bl = this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-4, 0, -2), 2000) || this.needsUpdate;
        }
        if (e == EnumFacing.SOUTH) {
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, -2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -4), 2000) || this.needsUpdate;
            boolean bl = this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, -4), 2000) || this.needsUpdate;
        }
        if (e == EnumFacing.WEST) {
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(4, 0, 2), 2000) || this.needsUpdate;
            boolean bl = this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(4, 0, -2), 2000) || this.needsUpdate;
        }
        if (e == EnumFacing.NORTH) {
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 2), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 4), 2000) || this.needsUpdate;
            this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 4), 2000) || this.needsUpdate;
        }
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.getFluid() == this.tankTypes[0]) {
            return this.tanks[0].drain(resource.amount, doDrain);
        }
        if (resource.getFluid() == this.tankTypes[1]) {
            return this.tanks[1].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks[0].getFluidAmount() > 0) {
            return this.tanks[0].drain(maxDrain, doDrain);
        }
        if (this.tanks[1].getFluidAmount() > 0) {
            return this.tanks[1].drain(maxDrain, doDrain);
        }
        return null;
    }
}

