/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.LiquefactionRecipes;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerLiquefactor;
import com.hbm.inventory.gui.GUILiquefactor;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.DirPos;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineLiquefactor
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 100000L;
    public static final int usageBase = 500;
    public int usage;
    public int progress;
    public static final int processTimeBase = 200;
    public boolean needsUpdate = false;
    public int processTime;
    public Fluid fluidType = null;
    public FluidTank tank;
    private final UpgradeManager upgradeManager = new UpgradeManager();
    AxisAlignedBB bb = null;

    public TileEntityMachineLiquefactor() {
        super(4);
        this.tank = new FluidTank(24000);
    }

    @Override
    public String getName() {
        return "container.machineLiquefactor";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 1, this.power, 100000L);
            this.updateConnections();
            this.upgradeManager.eval((IItemHandler)this.inventory, 2, 3);
            int speed = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            int power = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            this.processTime = 200 - 50 * speed;
            this.usage = (500 + 500 * speed) / (power + 1);
            if (this.canProcess()) {
                this.process();
            } else {
                this.progress = 0;
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.sendFluid();
            }
            NBTTagCompound data = new NBTTagCompound();
            if (this.fluidType != null) {
                data.func_74778_a("fluidType", this.fluidType.getName());
            }
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("usage", this.usage);
            data.func_74768_a("processTime", this.processTime);
            this.tank.writeToNBT(data);
            this.networkPack(data, 50);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
        }
    }

    private void sendFluid() {
        for (DirPos pos : this.getConPos()) {
            if (this.tank.getFluidAmount() <= 0) continue;
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, pos.getPos(), 8000);
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 4, this.field_174879_c.func_177952_p(), Library.POS_Y), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), Library.NEG_Y), new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - 2, Library.NEG_Z)};
    }

    public boolean canProcess() {
        if (this.power < (long)this.usage) {
            return false;
        }
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        FluidStack out = LiquefactionRecipes.getOutput(this.inventory.getStackInSlot(0));
        if (out == null) {
            return false;
        }
        if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null && out.getFluid() != this.tank.getFluid().getFluid()) {
            return false;
        }
        this.fluidType = out.getFluid();
        return out.amount + this.tank.getFluidAmount() <= this.tank.getCapacity();
    }

    public void process() {
        this.power -= (long)this.usage;
        ++this.progress;
        if (this.progress >= this.processTime) {
            FluidStack out = LiquefactionRecipes.getOutput(this.inventory.getStackInSlot(0));
            this.tank.fill(out.copy(), true);
            this.inventory.getStackInSlot(0).func_190918_g(1);
            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
            this.progress = 0;
            this.func_70296_d();
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        return i == 0 && LiquefactionRecipes.getOutput(itemStack) != null;
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return false;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.usage = nbt.func_74762_e("usage");
        this.processTime = nbt.func_74762_e("processTime");
        if (nbt.func_74764_b("fluidType")) {
            this.fluidType = FluidRegistry.getFluid((String)nbt.func_74779_i("fluidType"));
        }
        this.tank.readFromNBT(nbt);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerLiquefactor(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUILiquefactor(player.field_71071_by, this);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

