/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.HydrotreatingRecipes;
import com.hbm.inventory.container.ContainerMachineHydrotreater;
import com.hbm.inventory.gui.GUIMachineHydrotreater;
import com.hbm.items.ModItems;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineHydrotreater
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IFluidHandler,
IEnergyUser,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks = new FluidTank[4];
    AxisAlignedBB bb = null;

    public TileEntityMachineHydrotreater() {
        super(11);
        this.tanks[0] = new FluidTank(64000);
        this.tanks[1] = new FluidTank(64000);
        this.tanks[2] = new FluidTank(24000);
        this.tanks[3] = new FluidTank(24000);
    }

    @Override
    public String getName() {
        return "container.hydrotreater";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 1000000L);
            this.tryMoveBattery();
            if (this.inputValidForRecipe()) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 2, 3);
            }
            if (this.inputValidForTank()) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 4, 5);
            }
            if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                this.reform();
            }
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[2], 6, 7);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[3], 8, 9);
            for (DirPos pos : this.getConPos()) {
                for (int i = 2; i < 4; ++i) {
                    if (this.tanks[i].getFluidAmount() <= 0) continue;
                    FFUtils.fillFluid(this, this.tanks[i], this.field_145850_b, pos.getPos(), 8000);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            this.networkPack(data, 150);
        }
    }

    protected boolean inputValidForRecipe() {
        FluidStack containerFluid;
        if (!this.inventory.getStackInSlot(2).func_190926_b() && (containerFluid = FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(2))) != null) {
            return HydrotreatingRecipes.getOutput(containerFluid.getFluid()) != null;
        }
        return false;
    }

    protected boolean inputValidForTank() {
        FluidStack containerFluid;
        if (!this.inventory.getStackInSlot(4).func_190926_b() && (containerFluid = FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(4))) != null && this.tanks[0].getFluid() != null) {
            Tuple.Triplet<FluidStack, FluidStack, FluidStack> out = HydrotreatingRecipes.getOutput(this.tanks[0].getFluid().getFluid());
            return out != null && containerFluid.getFluid() == out.getX().getFluid();
        }
        return false;
    }

    public void tryMoveBattery() {
        IBatteryItem itemDrain;
        ItemStack itemStackDrain = this.inventory.getStackInSlot(0);
        Item item = itemStackDrain.func_77973_b();
        if (item instanceof IBatteryItem && (itemDrain = (IBatteryItem)item).getCharge(itemStackDrain) == 0L) {
            this.inventory.getStackInSlot(1);
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.setStackInSlot(1, itemStackDrain);
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
    }

    private void reform() {
        if (this.power < 20000L) {
            return;
        }
        if (this.tanks[0].getFluidAmount() < 100 || this.tanks[0].getFluid() == null) {
            return;
        }
        Tuple.Triplet<FluidStack, FluidStack, FluidStack> out = HydrotreatingRecipes.getOutput(this.tanks[0].getFluid().getFluid());
        if (out == null) {
            return;
        }
        if (this.tanks[1].getFluidAmount() < out.getX().amount || !out.getX().isFluidEqual(this.tanks[1].getFluid())) {
            return;
        }
        if (this.inventory.getStackInSlot(10).func_190926_b() || this.inventory.getStackInSlot(10).func_77973_b() != ModItems.catalytic_converter) {
            return;
        }
        if (this.tanks[2].getFluidAmount() + out.getY().amount > this.tanks[2].getCapacity() || this.tanks[2].getFluid() != null && !out.getY().isFluidEqual(this.tanks[2].getFluid())) {
            return;
        }
        if (this.tanks[3].getFluidAmount() + out.getZ().amount > this.tanks[3].getCapacity() || this.tanks[3].getFluid() != null && !out.getZ().isFluidEqual(this.tanks[3].getFluid())) {
            return;
        }
        this.tanks[0].drain(100, true);
        this.tanks[1].drain(out.getX().amount, true);
        this.tanks[2].fill(out.getY(), true);
        this.tanks[3].fill(out.getZ(), true);
        this.power -= 20000L;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, Library.POS_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, Library.NEG_X), new DirPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2, Library.POS_Z), new DirPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2, Library.NEG_Z), new DirPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2, Library.NEG_Z)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 7), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineHydrotreater(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineHydrotreater(player.field_71071_by, this);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 4) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
            this.tanks[2].readFromNBT(tags[2]);
            this.tanks[3].readFromNBT(tags[3]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0], this.tanks[3].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        Tuple.Triplet<FluidStack, FluidStack, FluidStack> out;
        if (resource == null) {
            return 0;
        }
        if (HydrotreatingRecipes.getOutput(resource.getFluid()) != null && (this.tanks[0].getFluid() == null || resource.isFluidEqual(this.tanks[0].getFluid()))) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (this.tanks[0].getFluid() != null && (out = HydrotreatingRecipes.getOutput(this.tanks[0].getFluid().getFluid())) != null && out.getX().isFluidEqual(resource)) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.isFluidEqual(this.tanks[2].getFluid())) {
            return this.tanks[2].drain(resource.amount, doDrain);
        }
        if (resource.isFluidEqual(this.tanks[3].getFluid())) {
            return this.tanks[3].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks[2].getFluid() != null) {
            return this.tanks[2].drain(maxDrain, doDrain);
        }
        if (this.tanks[3].getFluid() != null) {
            return this.tanks[3].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

