/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.FractionRecipes;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.util.Tuple;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineFractionTower
extends TileEntity
implements INBTPacketReceiver,
ITickable,
IFluidHandler {
    public FluidTank[] tanks = new FluidTank[3];
    public Fluid[] types = new Fluid[3];
    AxisAlignedBB bb = null;

    public TileEntityMachineFractionTower() {
        this.types[0] = ModForgeFluids.HEAVYOIL;
        this.types[1] = ModForgeFluids.BITUMEN;
        this.types[2] = ModForgeFluids.SMEAR;
        this.tanks[0] = new FluidTank(ModForgeFluids.HEAVYOIL, 0, 4000);
        this.tanks[1] = new FluidTank(ModForgeFluids.BITUMEN, 0, 4000);
        this.tanks[2] = new FluidTank(ModForgeFluids.SMEAR, 0, 4000);
    }

    public void setTankType(int idx, Fluid type) {
        if (this.types[idx] != type) {
            this.types[idx] = type;
            if (type != null) {
                this.tanks[idx].setFluid(new FluidStack(type, 0));
            } else {
                this.tanks[idx].setFluid(null);
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity stack = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(3));
            if (stack instanceof TileEntityMachineFractionTower) {
                TileEntityMachineFractionTower frac = (TileEntityMachineFractionTower)stack;
                for (int i = 0; i < 3; ++i) {
                    frac.setTankType(i, this.types[i]);
                }
                int oil = Math.min(this.tanks[0].getFluidAmount(), frac.tanks[0].getCapacity() - frac.tanks[0].getFluidAmount());
                int left = Math.min(frac.tanks[1].getFluidAmount(), this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount());
                int right = Math.min(frac.tanks[2].getFluidAmount(), this.tanks[2].getCapacity() - this.tanks[2].getFluidAmount());
                this.tanks[0].drain(oil, true);
                this.tanks[1].fill(new FluidStack(this.types[1], left), true);
                this.tanks[2].fill(new FluidStack(this.types[2], right), true);
                frac.tanks[0].fill(new FluidStack(frac.types[0], oil), true);
                frac.tanks[1].drain(left, true);
                frac.tanks[2].drain(right, true);
            }
            this.setupTanks();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.fractionate();
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.tanks[1]);
                this.fillFluidInit(this.tanks[2]);
                this.networkPack();
            }
        }
    }

    public void networkPack() {
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.types[i] != null) {
                this.tanks[i].setFluid(new FluidStack(this.types[i], this.tanks[i].getFluidAmount()));
                continue;
            }
            this.tanks[i].setFluid(null);
        }
        data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        INBTPacketReceiver.networkPack(this, data, 25);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.types[i] = this.tanks[i].getFluid() != null ? this.tanks[i].getFluid().getFluid() : null;
        }
    }

    private void setupTanks() {
        Tuple.Quartet<Fluid, Fluid, Integer, Integer> quart = FractionRecipes.getFractions(this.types[0]);
        if (quart != null) {
            this.setTankType(1, quart.getW());
            this.setTankType(2, quart.getX());
        }
    }

    private void fractionate() {
        Tuple.Quartet<Fluid, Fluid, Integer, Integer> quart = FractionRecipes.getFractions(this.types[0]);
        if (quart != null) {
            int left = quart.getY();
            int right = quart.getZ();
            if (this.tanks[0].getFluidAmount() >= 100 && this.hasSpace(left, right)) {
                this.tanks[0].drain(100, true);
                this.tanks[1].fill(new FluidStack(this.types[1], left), true);
                this.tanks[2].fill(new FluidStack(this.types[2], right), true);
            }
        }
    }

    private boolean hasSpace(int left, int right) {
        return this.tanks[1].getFluidAmount() + left <= this.tanks[1].getCapacity() && this.tanks[2].getFluidAmount() + right <= this.tanks[2].getCapacity();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.types[i] = this.tanks[i].getFluid() != null ? this.tanks[i].getFluid().getFluid() : null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.types[i] != null) {
                this.tanks[i].setFluid(new FluidStack(this.types[i], this.tanks[i].getFluidAmount()));
                continue;
            }
            this.tanks[i].setFluid(null);
        }
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return nbt;
    }

    public void fillFluidInit(FluidTank tank) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation(i);
            this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * 2, tank);
        }
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), tank.getCapacity());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.types[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drain = null;
        if (resource.getFluid() == this.types[1]) {
            drain = this.tanks[1].drain(resource, doDrain);
        }
        if (resource.getFluid() == this.types[2]) {
            drain = this.tanks[2].drain(resource, doDrain);
        }
        return drain;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drain = this.tanks[1].drain(maxDrain, doDrain);
        if (drain == null) {
            drain = this.tanks[2].drain(maxDrain, doDrain);
        }
        return drain;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

