/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.CrackRecipes;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.INBTPacketReceiver;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineCatalyticCracker
extends TileEntity
implements INBTPacketReceiver,
ITickable,
IFluidHandler {
    public FluidTank[] tanks = new FluidTank[5];
    public Fluid[] types = new Fluid[5];
    AxisAlignedBB bb = null;

    public TileEntityMachineCatalyticCracker() {
        this.tanks[0] = new FluidTank(ModForgeFluids.BITUMEN, 0, 4000);
        this.types[0] = ModForgeFluids.BITUMEN;
        this.tanks[1] = new FluidTank(ModForgeFluids.STEAM, 0, 8000);
        this.types[1] = ModForgeFluids.STEAM;
        this.tanks[2] = new FluidTank(ModForgeFluids.OIL, 0, 4000);
        this.types[2] = ModForgeFluids.OIL;
        this.tanks[3] = new FluidTank(ModForgeFluids.AROMATICS, 0, 4000);
        this.types[3] = ModForgeFluids.AROMATICS;
        this.tanks[4] = new FluidTank(ModForgeFluids.SPENTSTEAM, 0, 4000);
        this.types[4] = ModForgeFluids.SPENTSTEAM;
    }

    public void setTankType(int idx, Fluid type) {
        if (this.types[idx] != type) {
            this.types[idx] = type;
            if (type != null) {
                this.tanks[idx].setFluid(new FluidStack(type, 0));
            } else {
                this.tanks[idx].setFluid(null);
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.setupTanks();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.crack();
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.tanks[2]);
                this.fillFluidInit(this.tanks[3]);
                this.fillFluidInit(this.tanks[4]);
                this.networkPack();
            }
        }
    }

    public void networkPack() {
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.types[i] != null) {
                this.tanks[i].setFluid(new FluidStack(this.types[i], this.tanks[i].getFluidAmount()));
                continue;
            }
            this.tanks[i].setFluid(null);
        }
        data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        INBTPacketReceiver.networkPack(this, data, 25);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.types[i] = this.tanks[i].getFluid() != null ? this.tanks[i].getFluid().getFluid() : null;
        }
    }

    private void setupTanks() {
        FluidStack[] fluids = CrackRecipes.getOutputsFromFluid(this.types[0]);
        if (fluids != null) {
            this.setTankType(1, ModForgeFluids.STEAM);
            this.setTankType(2, fluids[0].getFluid());
            if (fluids.length == 2) {
                this.setTankType(3, fluids[1].getFluid());
                this.setTankType(4, ModForgeFluids.SPENTSTEAM);
            } else {
                this.setTankType(3, ModForgeFluids.SPENTSTEAM);
                this.setTankType(4, null);
            }
        } else {
            this.setTankType(0, null);
            this.setTankType(1, null);
            this.setTankType(2, null);
            this.setTankType(3, null);
            this.setTankType(4, null);
        }
    }

    private void crack() {
        FluidStack[] outputFluids = CrackRecipes.getOutputsFromFluid(this.types[0]);
        if (outputFluids != null) {
            while (this.tanks[0].getFluidAmount() >= 100 && this.tanks[1].getFluidAmount() >= 200 && this.hasSpace(outputFluids)) {
                this.tanks[0].drain(100, true);
                this.tanks[1].drain(200, true);
                if (outputFluids.length == 2) {
                    this.tanks[2].fill(outputFluids[0].copy(), true);
                    this.tanks[3].fill(outputFluids[1].copy(), true);
                    this.tanks[4].fill(new FluidStack(ModForgeFluids.SPENTSTEAM, 2), true);
                    continue;
                }
                this.tanks[2].fill(outputFluids[0].copy(), true);
                this.tanks[3].fill(new FluidStack(ModForgeFluids.SPENTSTEAM, 2), true);
            }
        }
    }

    private boolean hasSpace(FluidStack[] outputFluids) {
        if (outputFluids.length == 2) {
            return this.tanks[2].getFluidAmount() + outputFluids[0].amount <= this.tanks[2].getCapacity() && this.tanks[3].getFluidAmount() + outputFluids[1].amount <= this.tanks[3].getCapacity() && this.tanks[4].getFluidAmount() + 2 <= this.tanks[4].getCapacity();
        }
        return this.tanks[2].getFluidAmount() + outputFluids[0].amount <= this.tanks[2].getCapacity() && this.tanks[3].getFluidAmount() + 2 <= this.tanks[3].getCapacity();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.types[i] = this.tanks[i].getFluid() != null ? this.tanks[i].getFluid().getFluid() : null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.types[i] != null) {
                this.tanks[i].setFluid(new FluidStack(this.types[i], this.tanks[i].getFluidAmount()));
                continue;
            }
            this.tanks[i].setFluid(null);
        }
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return nbt;
    }

    public void fillFluidInit(FluidTank tank) {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * 4 + rot.offsetX * 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * 4 + rot.offsetZ * 1, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * 4 - rot.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * 4 - rot.offsetZ * 2, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - dir.offsetX * 4 + rot.offsetX * 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ * 4 + rot.offsetZ * 1, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - dir.offsetX * 4 - rot.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ * 4 - rot.offsetZ * 2, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * 2 + rot.offsetX * 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * 2 + rot.offsetZ * 3, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * 2 - rot.offsetX * 4, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * 2 - rot.offsetZ * 4, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - dir.offsetX * 2 + rot.offsetX * 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ * 2 + rot.offsetZ * 3, tank);
        this.fillFluid(this.field_174879_c.func_177958_n() - dir.offsetX * 2 - rot.offsetX * 4, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ * 2 - rot.offsetZ * 4, tank);
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), tank.getCapacity());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 3), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 3), (double)(this.field_174879_c.func_177958_n() + 4), (double)(this.field_174879_c.func_177956_o() + 16), (double)(this.field_174879_c.func_177952_p() + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0], this.tanks[3].getTankProperties()[0], this.tanks[4].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            if (resource.getFluid() == this.types[0]) {
                return this.tanks[0].fill(resource, doFill);
            }
            if (resource.getFluid() == this.types[1]) {
                return this.tanks[1].fill(resource, doFill);
            }
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drain = null;
        if (resource.getFluid() == this.types[2]) {
            drain = this.tanks[2].drain(resource, doDrain);
        }
        if (resource.getFluid() == this.types[3]) {
            drain = this.tanks[3].drain(resource, doDrain);
        }
        if (resource.getFluid() == this.types[4]) {
            drain = this.tanks[4].drain(resource, doDrain);
        }
        return drain;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drain = this.tanks[2].drain(maxDrain, doDrain);
        if (drain == null) {
            drain = this.tanks[3].drain(maxDrain, doDrain);
        }
        if (drain == null) {
            drain = this.tanks[4].drain(maxDrain, doDrain);
        }
        return drain;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

