/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.WasteDrumRecipes;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import org.jetbrains.annotations.NotNull;

public class TileEntityWasteDrum
extends TileEntityMachineBase
implements ITickable {
    private static final int[] slots_arr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private int water = 0;

    public TileEntityWasteDrum() {
        super(12, 1);
    }

    @Override
    public String getName() {
        return "container.wasteDrum";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemRBMKRod) {
            return true;
        }
        return WasteDrumRecipes.hasRecipe(item);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return slots_arr;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemRBMKRod) {
            return ItemRBMKRod.getCoreHeat(itemStack) < 50.0 && ItemRBMKRod.getHullHeat(itemStack) < 50.0;
        }
        return WasteDrumRecipes.isCold(item);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.water = compound.func_74762_e("water");
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("water", this.water);
        return super.func_189515_b(compound);
    }

    @Override
    public void onLoad() {
        this.updateWater();
    }

    public void updateWater() {
        this.water = 0;
        Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f()).func_177230_c();
        if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            ++this.water;
        }
        if ((b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e()).func_177230_c()) == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            ++this.water;
        }
        if ((b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c()) == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            ++this.water;
        }
        if ((b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c()) == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            ++this.water;
        }
        if ((b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d()).func_177230_c()) == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            ++this.water;
        }
        if ((b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c()).func_177230_c()) == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            ++this.water;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.water > 0) {
            int r = 72000 / this.water;
            for (int i = 0; i < 12; ++i) {
                Item waste_hot;
                ItemStack waste_cold;
                if (this.inventory.getStackInSlot(i).func_77973_b() instanceof ItemRBMKRod) {
                    ItemRBMKRod rod = (ItemRBMKRod)this.inventory.getStackInSlot(i).func_77973_b();
                    rod.updateHeat(this.field_145850_b, this.inventory.getStackInSlot(i), 0.025);
                    rod.provideHeat(this.field_145850_b, this.inventory.getStackInSlot(i), 20.0, 0.025);
                    continue;
                }
                if (this.field_145850_b.field_73012_v.nextInt(r) != 0 || this.inventory.getStackInSlot(i).func_190926_b() || (waste_cold = WasteDrumRecipes.getOutput(waste_hot = this.inventory.getStackInSlot(i).func_77973_b())) == null) continue;
                this.inventory.setStackInSlot(i, waste_cold.func_77946_l());
            }
        }
    }
}

