/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.hazard.HazardSystem;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.StorageDrumRecipes;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ContaminationUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class TileEntityStorageDrum
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public FluidTank[] tanks = new FluidTank[2];
    private static final int[] slots_arr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    public int age = 0;
    private static final float decayRate = 0.99654025f;

    public TileEntityStorageDrum() {
        super(24, 1);
        this.tanks[0] = new FluidTank(16000);
        this.tanks[1] = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.storageDrum";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            float rad = 0.0f;
            int liquid = 0;
            int gas = 0;
            for (i = 0; i < 24; ++i) {
                int[] wasteData;
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                ItemStack itemStack = this.inventory.getStackInSlot(i);
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    rad += HazardSystem.getRawRadsFromStack(itemStack);
                }
                if ((wasteData = StorageDrumRecipes.getWaste(this.inventory.getStackInSlot(i))) != null) {
                    ItemStack outputStack;
                    if (this.field_145850_b.field_73012_v.nextInt(wasteData[0]) != 0 || (outputStack = StorageDrumRecipes.getOutput(this.inventory.getStackInSlot(i))) == null) continue;
                    liquid += wasteData[1];
                    gas += wasteData[2];
                    this.inventory.setStackInSlot(i, outputStack.func_77946_l());
                    continue;
                }
                ContaminationUtil.neutronActivateItem(this.inventory.getStackInSlot(i), 0.0f, 0.99654025f);
            }
            for (i = 0; i < 2; ++i) {
                int overflow = Math.max(this.tanks[i].getFluidAmount() + (i == 0 ? liquid : gas) - this.tanks[i].getCapacity(), 0);
                if (overflow <= 0) continue;
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, (float)overflow * 0.5f, Float.MAX_VALUE);
            }
            this.tanks[0].fill(new FluidStack(ModForgeFluids.WASTEFLUID, liquid), true);
            this.tanks[1].fill(new FluidStack(ModForgeFluids.WASTEGAS, gas), true);
            ++this.age;
            if (this.age >= 20) {
                this.age -= 20;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[0]);
            }
            if (this.age == 8 || this.age == 18) {
                this.fillFluidInit(this.tanks[1]);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (rad > 0.0f) {
                ContaminationUtil.radiate(this.field_145850_b, this.field_174879_c.func_177952_p(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177958_n(), 32.0, rad);
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        return StorageDrumRecipes.getOutput(itemStack) != null || ContaminationUtil.isContaminated(itemStack);
    }

    @Override
    public boolean canInsertItem(int i, ItemStack itemStack, int j) {
        return this.isItemValidForSlot(i, itemStack);
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return !ContaminationUtil.isContaminated(itemStack) && StorageDrumRecipes.getOutput(itemStack) == null;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing side) {
        return slots_arr;
    }

    public void fillFluidInit(FluidTank type) {
        this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), type);
        this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), type);
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), type);
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), type);
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1, type);
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1, type);
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), tank.getCapacity());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt.func_74775_l("liquid"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("gas"));
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("liquid", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("gas", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack stack = this.tanks[0].drain(resource, doDrain);
        if (stack == null) {
            stack = this.tanks[1].drain(resource, doDrain);
        }
        return stack;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack stack = this.tanks[0].drain(maxDrain, doDrain);
        if (stack == null) {
            stack = this.tanks[1].drain(maxDrain, doDrain);
        }
        return stack;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

