/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.entity.missile.EntitySoyuz;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.MissileStruct;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemSoyuz;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntitySoyuzLauncher
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks;
    public byte mode;
    public boolean starting;
    public int countdown;
    public static final int maxCount = 600;
    public byte rocketType = (byte)-1;
    private AudioWrapper audio;
    public MissileStruct load;

    public TileEntitySoyuzLauncher() {
        super(27);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(128000);
        this.tanks[1] = new FluidTank(128000);
    }

    @Override
    public String getName() {
        return "container.soyuzLauncher";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            if (this.isValidFluidForTank(4, 0)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 4, 5);
            }
            if (this.isValidFluidForTank(6, 1)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 6, 7);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 8, this.power, 1000000L);
            if (!this.starting || !this.canLaunch()) {
                this.countdown = 600;
                this.starting = false;
            } else if (this.countdown > 0) {
                --this.countdown;
                if (this.countdown % 100 == 0 && this.countdown > 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.alarmHatch, SoundCategory.BLOCKS, 100.0f, 1.1f);
                }
            } else {
                this.liftOff();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74774_a("mode", this.mode);
            data.func_74757_a("starting", this.starting);
            data.func_74774_a("type", this.getType());
            this.networkPack(data, 250);
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.starting || !this.canLaunch()) {
                if (this.audio != null) {
                    this.audio.stopSound();
                    this.audio = null;
                }
                this.countdown = 600;
            } else if (this.countdown > 0) {
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound(HBMSoundHandler.soyuzReady, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 1.0f, 1.0f);
                    this.audio.updateVolume(100.0f);
                    this.audio.startSound();
                }
                --this.countdown;
            }
            List entities = this.field_145850_b.func_72872_a(EntitySoyuz.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 0.5, (double)this.field_174879_c.func_177958_n() + 1.5, (double)(this.field_174879_c.func_177956_o() + 10), (double)this.field_174879_c.func_177952_p() + 1.5));
            if (!entities.isEmpty()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "smoke");
                data.func_74778_a("mode", "shockRand");
                data.func_74768_a("count", 50);
                data.func_74780_a("strength", this.field_145850_b.field_73012_v.nextGaussian() * 3.0 + 6.0);
                data.func_74780_a("posX", (double)this.field_174879_c.func_177958_n() + 0.5);
                data.func_74780_a("posY", (double)(this.field_174879_c.func_177956_o() - 3));
                data.func_74780_a("posZ", (double)this.field_174879_c.func_177952_p() + 0.5);
                MainRegistry.proxy.effectNT(data);
            }
        }
    }

    private void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, dir.offsetX * 10), rot.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, dir.offsetX * -9), rot);
    }

    private boolean isValidFluidForTank(int slot, int tank) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        if (f == null) {
            return false;
        }
        return tank == 0 && f.getFluid() == ModForgeFluids.KEROSENE || tank == 1 && f.getFluid() == ModForgeFluids.OXYGEN;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.mode = data.func_74771_c("mode");
        this.starting = data.func_74767_n("starting");
        this.rocketType = data.func_74771_c("type");
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void startCountdown() {
        if (this.canLaunch()) {
            this.starting = true;
        }
    }

    public void liftOff() {
        this.starting = false;
        int req = this.getFuelRequired();
        int pow = this.getPowerRequired();
        EntitySoyuz soyuz = new EntitySoyuz(this.field_145850_b);
        soyuz.setSkin(this.getType());
        soyuz.mode = this.mode;
        soyuz.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)soyuz);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.soyuzTakeOff, SoundCategory.BLOCKS, 100.0f, 1.1f);
        this.tanks[0].drain(req, true);
        this.tanks[1].drain(req, true);
        this.power -= (long)pow;
        if (this.mode == 0) {
            soyuz.setSat(this.inventory.getStackInSlot(2));
            if (this.orbital() == 2) {
                this.inventory.setStackInSlot(3, ItemStack.field_190927_a);
            }
            this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
        }
        if (this.mode == 1) {
            ArrayList<ItemStack> payload = new ArrayList<ItemStack>();
            for (int i = 9; i < 27; ++i) {
                payload.add(this.inventory.getStackInSlot(i));
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            soyuz.targetX = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("xCoord");
            soyuz.targetZ = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("zCoord");
            soyuz.setPayload(payload);
        }
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
    }

    public boolean canLaunch() {
        return this.hasRocket() && this.hasFuel() && this.hasRocket() && this.hasPower() && this.designator() != 1 && this.orbital() != 1 && this.satellite() != 1;
    }

    public boolean hasFuel() {
        return this.tanks[0].getFluidAmount() >= this.getFuelRequired();
    }

    public boolean hasOxy() {
        return this.tanks[1].getFluidAmount() >= this.getFuelRequired();
    }

    public int getFuelRequired() {
        if (this.mode == 1) {
            return 20000 + this.getDist();
        }
        return 128000;
    }

    public int getDist() {
        if (this.designator() == 2) {
            int x = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("xCoord");
            int z = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("zCoord");
            return (int)Vec3.createVectorHelper(this.field_174879_c.func_177958_n() - x, 0.0, this.field_174879_c.func_177952_p() - z).length();
        }
        return 0;
    }

    public boolean hasPower() {
        return this.power >= (long)this.getPowerRequired();
    }

    public int getPowerRequired() {
        return 750000;
    }

    private byte getType() {
        if (!this.hasRocket()) {
            return -1;
        }
        Item rocket = this.inventory.getStackInSlot(0).func_77973_b();
        if (rocket == ModItems.missile_soyuz0) {
            return 0;
        }
        if (rocket == ModItems.missile_soyuz1) {
            return 1;
        }
        if (rocket == ModItems.missile_soyuz2) {
            return 2;
        }
        return 0;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public boolean hasRocket() {
        return this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemSoyuz;
    }

    public int designator() {
        if (this.mode == 0) {
            return 0;
        }
        if ((this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator || this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator_range || this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator_manual) && this.inventory.getStackInSlot(1).func_77942_o()) {
            return 2;
        }
        return 1;
    }

    public int satellite() {
        if (this.mode == 1) {
            return 0;
        }
        if (!this.inventory.getStackInSlot(2).func_190926_b()) {
            return 2;
        }
        return 1;
    }

    public int orbital() {
        if (this.mode == 1) {
            return 0;
        }
        if (this.inventory.getStackInSlot(2).func_77973_b() == ModItems.sat_gerald) {
            if (this.inventory.getStackInSlot(3).func_77973_b() == ModItems.missile_soyuz_lander) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.mode = compound.func_74771_c("mode");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74774_a("mode", this.mode);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(compound);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == ModForgeFluids.KEROSENE) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == ModForgeFluids.OXYGEN) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

