/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IAnimatedDoor;
import com.hbm.interfaces.IDoor;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemKeyPin;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEDoorAnimationPacket;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySlidingBlastDoor
extends TileEntityLockableBase
implements ITickable,
IAnimatedDoor {
    public IDoor.DoorState state = IDoor.DoorState.CLOSED;
    public byte texture = 0;
    public long sysTime;
    private int timer = 0;
    public boolean shouldUseBB = true;
    public boolean redstoned = false;
    public boolean keypadLocked = false;
    private AudioWrapper audio;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IDoor.DoorState oldState = this.state;
            if (this.state.isStationaryState()) {
                this.timer = 0;
            } else {
                ++this.timer;
                if (this.state == IDoor.DoorState.CLOSING) {
                    if (this.timer == 2) {
                        this.placeDummy(-2);
                        this.placeDummy(2);
                    } else if (this.timer == 6) {
                        this.placeDummy(-1);
                        this.placeDummy(1);
                    } else if (this.timer == 12) {
                        this.placeDummy(0);
                    }
                    if (this.timer > 24) {
                        this.state = IDoor.DoorState.CLOSED;
                        if (this.state != oldState) {
                            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
                        }
                    }
                } else if (this.state == IDoor.DoorState.OPENING) {
                    if (this.timer == 12) {
                        this.removeDummy(0);
                    } else if (this.timer == 16) {
                        this.removeDummy(-1);
                        this.removeDummy(1);
                    } else if (this.timer == 20) {
                        this.removeDummy(-2);
                        this.removeDummy(2);
                    } else if (this.timer > 24) {
                        this.state = IDoor.DoorState.OPEN;
                    }
                }
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEDoorAnimationPacket(this.field_174879_c, (byte)this.state.ordinal(), this.texture), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c, this.shouldUseBB ? 1 : 0, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
        }
    }

    public boolean tryOpen(EntityPlayer player) {
        if (this.state == IDoor.DoorState.CLOSED) {
            if (!this.field_145850_b.field_72995_K && this.canAccess(player)) {
                this.open();
            }
            return true;
        }
        return false;
    }

    public boolean tryToggle(EntityPlayer player) {
        if (this.state == IDoor.DoorState.CLOSED) {
            return this.tryOpen(player);
        }
        if (this.state == IDoor.DoorState.OPEN) {
            return this.tryClose(player);
        }
        return false;
    }

    public boolean tryClose(EntityPlayer player) {
        if (this.state == IDoor.DoorState.OPEN) {
            if (!this.field_145850_b.field_72995_K && this.canAccess(player)) {
                this.close();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.keypadLocked && player != null) {
            return false;
        }
        if (!this.isLocked()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemKeyPin && ItemKeyPin.getPins(stack) == this.lock) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (stack.func_77973_b() == ModItems.key_red) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return this.tryPick(player);
    }

    private void placeDummy(int offset2) {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        BlockPos placePos = null;
        switch (dir) {
            case SOUTH: {
                placePos = this.field_174879_c.func_177982_a(offset2, 0, 0);
                break;
            }
            case NORTH: {
                placePos = this.field_174879_c.func_177982_a(-offset2, 0, 0);
                break;
            }
            case EAST: {
                placePos = this.field_174879_c.func_177982_a(0, 0, offset2);
                break;
            }
            case WEST: {
                placePos = this.field_174879_c.func_177982_a(0, 0, -offset2);
                break;
            }
            default: {
                return;
            }
        }
        if (offset2 == 0) {
            this.shouldUseBB = true;
        } else {
            ((BlockDummyable)this.func_145838_q()).removeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o(), placePos.func_177952_p());
        }
        ((BlockDummyable)this.func_145838_q()).removeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o() + 1, placePos.func_177952_p());
        ((BlockDummyable)this.func_145838_q()).removeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o() + 2, placePos.func_177952_p());
        ((BlockDummyable)this.func_145838_q()).removeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o() + 3, placePos.func_177952_p());
    }

    private void removeDummy(int offset2) {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        BlockPos placePos = null;
        switch (dir) {
            case SOUTH: {
                placePos = this.field_174879_c.func_177982_a(offset2, 0, 0);
                break;
            }
            case NORTH: {
                placePos = this.field_174879_c.func_177982_a(-offset2, 0, 0);
                break;
            }
            case EAST: {
                placePos = this.field_174879_c.func_177982_a(0, 0, offset2);
                break;
            }
            case WEST: {
                placePos = this.field_174879_c.func_177982_a(0, 0, -offset2);
                break;
            }
            default: {
                return;
            }
        }
        BlockDummyable.safeRem = true;
        if (offset2 == 0) {
            this.shouldUseBB = false;
        } else {
            ((BlockDummyable)this.func_145838_q()).makeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o(), placePos.func_177952_p());
        }
        ((BlockDummyable)this.func_145838_q()).makeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o() + 1, placePos.func_177952_p());
        ((BlockDummyable)this.func_145838_q()).makeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o() + 2, placePos.func_177952_p());
        ((BlockDummyable)this.func_145838_q()).makeExtra(this.field_145850_b, placePos.func_177958_n(), placePos.func_177956_o() + 3, placePos.func_177952_p());
        BlockDummyable.safeRem = false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.state = IDoor.DoorState.values()[compound.func_74771_c("state")];
        this.sysTime = compound.func_74763_f("sysTime");
        this.timer = compound.func_74762_e("timer");
        this.redstoned = compound.func_74767_n("redstoned");
        this.keypadLocked = compound.func_74767_n("keypadLocked");
        this.shouldUseBB = compound.func_74767_n("shouldUseBB");
        this.texture = compound.func_74771_c("texture");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("state", (byte)this.state.ordinal());
        compound.func_74772_a("sysTime", this.sysTime);
        compound.func_74768_a("timer", this.timer);
        compound.func_74757_a("redstoned", this.redstoned);
        compound.func_74757_a("keypadLocked", this.keypadLocked);
        compound.func_74757_a("shouldUseBB", this.shouldUseBB);
        compound.func_74774_a("texture", this.texture);
        return super.func_189515_b(compound);
    }

    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        super.func_145843_s();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleNewState(IDoor.DoorState newState) {
        if (this.state != newState) {
            if (this.state == IDoor.DoorState.CLOSED && newState == IDoor.DoorState.OPENING && this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSoundStartStop(this.field_145850_b, HBMSoundHandler.qe_sliding_opening, null, HBMSoundHandler.qe_sliding_opened, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 2.0f, 1.0f);
                this.audio.startSound();
            }
            if (this.state == IDoor.DoorState.OPEN && newState == IDoor.DoorState.CLOSING && this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSoundStartStop(this.field_145850_b, HBMSoundHandler.qe_sliding_opening, null, HBMSoundHandler.qe_sliding_shut, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 2.0f, 1.0f);
                this.audio.startSound();
            }
            if (this.state.isMovingState() && newState.isStationaryState() && this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            if (this.state.isStationaryState() && newState.isMovingState()) {
                this.sysTime = System.currentTimeMillis();
            }
            this.state = newState;
        }
    }

    @Override
    public void open() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.toggle();
        }
    }

    @Override
    public void close() {
        if (this.state == IDoor.DoorState.OPEN) {
            this.toggle();
        }
    }

    @Override
    public IDoor.DoorState getState() {
        return this.state;
    }

    @Override
    public void toggle() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.state = IDoor.DoorState.OPENING;
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        } else if (this.state == IDoor.DoorState.OPEN) {
            this.state = IDoor.DoorState.CLOSING;
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void setTextureState(byte tex) {
        this.texture = tex;
    }

    @Override
    public boolean setTexture(String tex) {
        if (tex.equals("sliding_blast_door")) {
            this.texture = 0;
            return true;
        }
        if (tex.equals("sliding_blast_door_variant1")) {
            this.texture = 1;
            return true;
        }
        if (tex.equals("sliding_blast_door_variant2")) {
            this.texture = (byte)2;
            return true;
        }
        return false;
    }
}

