/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.SILEXRecipes;
import com.hbm.items.machine.ItemFELCrystal;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import com.hbm.util.WeightedRandomObject;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntitySILEX
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public ItemFELCrystal.EnumWavelengths mode = ItemFELCrystal.EnumWavelengths.NULL;
    public boolean hasLaser;
    public FluidTank tank = new FluidTank(16000);
    public RecipesCommon.ComparableStack current;
    public int currentFill;
    public static final int maxFill = 16000;
    public int progress;
    public final int processTime = 80;
    public static final HashMap<Fluid, RecipesCommon.ComparableStack> fluidConversion = new HashMap();
    int loadDelay;

    public TileEntitySILEX() {
        super(10);
    }

    public Fluid getTankType() {
        return this.tank.getFluid() == null ? null : this.tank.getFluid().getFluid();
    }

    @Override
    public String getName() {
        return "container.machineSILEX";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 1, 2);
            this.loadFluid();
            if (!this.process()) {
                this.progress = 0;
            }
            this.dequeue();
            if (this.currentFill <= 0) {
                this.current = null;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("fill", this.currentFill);
            data.func_74768_a("progress", this.progress);
            data.func_74778_a("mode", this.mode.toString());
            if (this.current != null) {
                data.func_74768_a("item", Item.func_150891_b((Item)this.current.item));
                data.func_74768_a("meta", this.current.meta);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            this.networkPack(data, 50);
            this.mode = ItemFELCrystal.EnumWavelengths.NULL;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.currentFill = nbt.func_74762_e("fill");
        this.progress = nbt.func_74762_e("progress");
        this.mode = ItemFELCrystal.EnumWavelengths.valueOf(nbt.func_74779_i("mode"));
        this.current = this.currentFill > 0 ? new RecipesCommon.ComparableStack(Item.func_150899_d((int)nbt.func_74762_e("item")), 1, nbt.func_74762_e("meta")) : null;
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        this.currentFill = 0;
        this.current = null;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 80;
    }

    public int getFluidScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    public int getFillScaled(int i) {
        return this.currentFill * i / 16000;
    }

    public void loadFluid() {
        RecipesCommon.ComparableStack conv = fluidConversion.get(this.getTankType());
        if (conv != null) {
            if (this.currentFill == 0) {
                this.current = (RecipesCommon.ComparableStack)conv.copy();
            }
            if (this.current != null && this.current.equals(conv)) {
                int toFill = Math.min(10, Math.min(16000 - this.currentFill, this.tank.getFluidAmount()));
                this.currentFill += toFill;
                this.tank.drain(toFill, true);
            }
        }
        ++this.loadDelay;
        if (this.loadDelay > 20) {
            this.loadDelay = 0;
        }
        if (this.loadDelay == 0 && !this.inventory.getStackInSlot(0).func_190926_b() && this.getTankType() != null && this.getTankType().getName().equals(ModForgeFluids.ACID.getName()) && (this.current == null || this.current.equals(new RecipesCommon.ComparableStack(this.inventory.getStackInSlot(0)).makeSingular()))) {
            SILEXRecipes.SILEXRecipe recipe = SILEXRecipes.getOutput(this.inventory.getStackInSlot(0));
            if (recipe == null) {
                return;
            }
            int load = recipe.fluidProduced;
            if (load <= 16000 - this.currentFill && load <= this.tank.getFluidAmount()) {
                this.currentFill += load;
                this.current = new RecipesCommon.ComparableStack(this.inventory.getStackInSlot(0)).makeSingular();
                this.tank.drain(load * 3, true);
                this.inventory.getStackInSlot(0).func_190918_g(1);
            }
        }
    }

    private boolean process() {
        if (this.current == null || this.currentFill <= 0) {
            return false;
        }
        SILEXRecipes.SILEXRecipe recipe = SILEXRecipes.getOutput(this.current.toStack());
        if (recipe == null) {
            return false;
        }
        if (recipe.laserStrength.ordinal() > this.mode.ordinal()) {
            return false;
        }
        if (this.currentFill < recipe.fluidConsumed) {
            return false;
        }
        if (!this.inventory.getStackInSlot(3).func_190926_b()) {
            return false;
        }
        this.progress = (int)((double)this.progress + Math.pow(1.5, this.mode.ordinal() - recipe.laserStrength.ordinal()));
        if (this.progress >= 80) {
            this.currentFill -= recipe.fluidConsumed;
            ItemStack out = ((WeightedRandomObject)WeightedRandom.func_76271_a((Random)this.field_145850_b.field_73012_v, recipe.outputs)).asStack();
            this.inventory.setStackInSlot(3, out.func_77946_l());
            this.progress = 0;
            this.func_70296_d();
        }
        return true;
    }

    private void dequeue() {
        if (!this.inventory.getStackInSlot(3).func_190926_b()) {
            int i;
            for (i = 4; i < 10; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_190916_E() >= this.inventory.getStackInSlot(i).func_77976_d() || !InventoryUtil.doesStackDataMatch(this.inventory.getStackInSlot(3), this.inventory.getStackInSlot(i))) continue;
                this.inventory.getStackInSlot(i).func_190917_f(1);
                this.inventory.getStackInSlot(3).func_190918_g(1);
                return;
            }
            for (i = 4; i < 10; ++i) {
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.setStackInSlot(i, this.inventory.getStackInSlot(3).func_77946_l());
                this.inventory.setStackInSlot(3, ItemStack.field_190927_a);
                return;
            }
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing p_94128_1_) {
        return new int[]{0, 4, 5, 6, 7, 8, 9};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        if (i == 0) {
            return SILEXRecipes.getOutput(itemStack) != null;
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
        return slot >= 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.currentFill = nbt.func_74762_e("fill");
        if (this.currentFill > 0) {
            this.current = new RecipesCommon.ComparableStack(Item.func_150899_d((int)nbt.func_74762_e("item")), 1, nbt.func_74762_e("meta"));
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("fill", this.currentFill);
        nbt.func_74778_a("mode", this.mode.toString());
        if (this.current != null) {
            nbt.func_74768_a("item", Item.func_150891_b((Item)this.current.item));
            nbt.func_74768_a("meta", this.current.meta);
        }
        return nbt;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && (resource.getFluid().getName().equals(ModForgeFluids.ACID.getName()) || fluidConversion.containsKey(resource.getFluid()))) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }

    static {
        fluidConversion.put(ModForgeFluids.UF6, new RecipesCommon.NbtComparableStack(ItemFluidIcon.getStack(ModForgeFluids.UF6)));
        fluidConversion.put(ModForgeFluids.PUF6, new RecipesCommon.NbtComparableStack(ItemFluidIcon.getStack(ModForgeFluids.PUF6)));
    }
}

