/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineUUCreator
extends TileEntityMachineBase
implements IEnergyUser,
IFluidHandler,
ITickable,
ITankPacketAcceptor {
    public int[] log = new int[20];
    public static final long rfPerMbOfUU = 1000000L;
    public FluidTank tank = new FluidTank(2000000000);
    public long power;
    public static final long maxPower = 5000000000000000L;
    public double producedmb = 0.0;
    public boolean isOn;

    public TileEntityMachineUUCreator() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.uuCreator";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int producedUUmB;
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.tank);
            }
            this.updateConnections();
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 5000000000000000L);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 2, 3);
            int loggedProducedMB = 0;
            if (this.isOn && this.power >= 1000000L && this.tank.getFluidAmount() < this.tank.getCapacity() && (producedUUmB = (int)Math.min(this.power / 1000000L, (long)(this.tank.getCapacity() - this.tank.getFluidAmount()))) > 0) {
                producedUUmB = this.tank.fill(new FluidStack(ModForgeFluids.UU_MATTER, producedUUmB), true);
                this.power -= (long)producedUUmB * 1000000L;
                this.func_70296_d();
                loggedProducedMB = producedUUmB;
            }
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[this.log.length - 1] = loggedProducedMB;
            this.producedmb = this.getAvgUU();
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isOn", this.isOn);
            data.func_74772_a("power", this.power);
            data.func_74780_a("uuMB", this.producedmb);
            this.networkPack(data, 250);
        }
    }

    public double getAvgUU() {
        long sum = 0L;
        for (int i = 0; i < this.log.length; ++i) {
            sum += (long)this.log[i];
        }
        return (double)sum / (double)this.log.length;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.isOn = data.func_74767_n("isOn");
        this.power = data.func_74763_f("power");
        this.producedmb = data.func_74769_h("uuMB");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            this.isOn = !this.isOn;
        }
    }

    public int getPowerScaled(int i) {
        double powerScaled = (double)this.power / 5.0E15;
        return (int)((double)i * powerScaled);
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 3, 0), ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 3, 0), ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 3, 0), ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 3, 2), ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 3, -2), ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 0), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, -1, 0), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, -1, 0), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 2), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, -2), ForgeDirection.DOWN);
    }

    private void fillFluidInit(FluidTank tank) {
        boolean update = false;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 3, 0), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 3, 0), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 3, 0), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 3, 2), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 3, -2), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 0), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, -1, 0), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, -1, 0), 1000000000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 2), 1000000000) || update;
        boolean bl = update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, -2), 1000000000) || update;
        if (update) {
            this.func_70296_d();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 3), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 3), (double)(this.field_174879_c.func_177958_n() + 4), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 4));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isOn = nbt.func_74767_n("isOn");
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74772_a("power", this.power);
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.isFluidEqual(this.tank.getFluid())) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tank.getFluid() != null) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 5000000000000000L;
    }
}

