/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.container.ContainerMachineStrandCaster;
import com.hbm.inventory.gui.GUIMachineStrandCaster;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMold;
import com.hbm.items.machine.ItemScraps;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.machine.TileEntityFoundryCastingBase;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineStrandCaster
extends TileEntityFoundryCastingBase
implements IGUIProvider,
IFluidHandler,
ITankPacketAcceptor,
INBTPacketReceiver {
    public static final int duration = 200;
    public static final int moldCount = 10;
    public FluidTank[] tanks = new FluidTank[2];
    public long lastProgressTick = 0L;
    public boolean isOn = false;
    private static final int invSize = 7;
    AxisAlignedBB bb = null;

    @NotNull
    public String getName() {
        return "container.machineStrandCaster";
    }

    public TileEntityMachineStrandCaster() {
        super(7);
        this.tanks[0] = new FluidTank(FluidRegistry.WATER, 0, 64000);
        this.tanks[1] = new FluidTank(ModForgeFluids.SPENTSTEAM, 0, 64000);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int moldsToCast;
            if (this.lastType != this.type || this.lastAmount != this.amount) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3);
                this.lastType = this.type;
                this.lastAmount = this.amount;
            }
            if (this.amount > this.getCapacity()) {
                ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(this.type, Math.max(this.amount - this.getCapacity(), 0)));
                EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.5, scrap);
                this.field_145850_b.func_72838_d((Entity)item);
                this.amount = this.getCapacity();
            }
            if (this.amount == 0) {
                this.type = null;
            }
            boolean bl = this.isOn = (moldsToCast = this.maxProcessable()) > 0;
            if (moldsToCast > 0 && this.field_145850_b.func_82737_E() > this.lastProgressTick + 200L) {
                int initialRemaining;
                ItemMold.Mold mold = this.getInstalledMold();
                this.amount -= moldsToCast * mold.getCost();
                ItemStack out = mold.getOutput(this.type);
                int itemsPerCast = out.func_190916_E();
                int remaining = initialRemaining = itemsPerCast * moldsToCast;
                int itemMaxStackSize = out.func_77976_d();
                for (int i = 1; i < 7 && remaining > 0; ++i) {
                    int toDeposit;
                    ItemStack slotStack = this.inventory.getStackInSlot(i);
                    int slotLimit = Math.min(this.inventory.getSlotLimit(i), itemMaxStackSize);
                    if (slotStack.func_190926_b()) {
                        toDeposit = Math.min(remaining, slotLimit);
                        if (toDeposit <= 0) continue;
                        ItemStack put = out.func_77946_l();
                        put.func_190920_e(toDeposit);
                        this.inventory.setStackInSlot(i, put);
                        remaining -= toDeposit;
                        continue;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slotStack, (ItemStack)out) || (toDeposit = Math.min(remaining, slotLimit - slotStack.func_190916_E())) <= 0) continue;
                    slotStack.func_190917_f(toDeposit);
                    this.inventory.setStackInSlot(i, slotStack);
                    remaining -= toDeposit;
                }
                int producedItems = initialRemaining - remaining;
                int castsMade = producedItems / itemsPerCast;
                if (castsMade > 0) {
                    this.tanks[0].drain(this.getWaterRequired() * castsMade, true);
                    this.tanks[1].fill(new FluidStack(ModForgeFluids.SPENTSTEAM, this.getWaterRequired() * castsMade), true);
                    this.func_70296_d();
                    this.lastProgressTick = this.field_145850_b.func_82737_E();
                }
            }
            this.fillFluidInit();
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("o", this.isOn);
            data.func_74772_a("p", this.lastProgressTick);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            INBTPacketReceiver.networkPack(this, data, 25);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.lastProgressTick = nbt.func_74763_f("p");
        this.isOn = nbt.func_74767_n("o");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    public double getProgress() {
        if (!this.isOn) {
            return 0.0;
        }
        return Math.max(0.0, Math.min(1.0, (double)(this.field_145850_b.func_82737_E() - this.lastProgressTick) / 199.0));
    }

    private int maxProcessable() {
        ItemMold.Mold mold = this.getInstalledMold();
        if (this.type == null || mold == null) {
            return 0;
        }
        ItemStack out = mold.getOutput(this.type);
        if (out == null || out.func_190926_b()) {
            return 0;
        }
        int freeSlots = 0;
        int stackLimit = mold.getOutput(this.type).func_77976_d();
        for (int i = 1; i < 7; ++i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.func_190926_b()) {
                freeSlots += stackLimit;
                continue;
            }
            if (!itemStack.func_77969_a(mold.getOutput(this.type))) continue;
            freeSlots += stackLimit - itemStack.func_190916_E();
        }
        int moldsToCast = Math.min(10, this.amount / mold.getCost());
        moldsToCast = Math.min(moldsToCast, freeSlots / mold.getOutput(this.type).func_190916_E());
        moldsToCast = Math.min(moldsToCast, this.tanks[0].getFluidAmount() / this.getWaterRequired());
        moldsToCast = Math.min(moldsToCast, (this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount()) / this.getWaterRequired());
        return moldsToCast;
    }

    public DirPos[] getFluidConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n() + rot.offsetX * 2 - dir.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + rot.offsetZ * 2 - dir.offsetZ, rot), new DirPos(this.field_174879_c.func_177958_n() - rot.offsetX - dir.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - rot.offsetZ - dir.offsetZ, rot.getOpposite()), new DirPos(this.field_174879_c.func_177958_n() + rot.offsetX * 2 - dir.offsetX * 5, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + rot.offsetZ * 2 - dir.offsetZ * 5, rot), new DirPos(this.field_174879_c.func_177958_n() - rot.offsetX - dir.offsetX * 5, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - rot.offsetZ - dir.offsetZ * 5, rot.getOpposite())};
    }

    public int[][] getMetalPourPos() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new int[][]{{this.field_174879_c.func_177958_n() + rot.offsetX - dir.offsetX, this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p() + rot.offsetZ - dir.offsetZ}, {this.field_174879_c.func_177958_n() - dir.offsetX, this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p() - dir.offsetZ}, {this.field_174879_c.func_177958_n() + rot.offsetX, this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p() + rot.offsetZ}, {this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p()}};
    }

    @Override
    public ItemMold.Mold getInstalledMold() {
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemMold) {
            ItemMold mold = (ItemMold)item;
            return mold.getMold(itemStack);
        }
        return null;
    }

    @Override
    public int getMoldSize() {
        return this.getInstalledMold().size;
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos pos, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        if (side != ForgeDirection.UP) {
            return false;
        }
        for (int[] pourPos : this.getMetalPourPos()) {
            if (pourPos[0] != pos.func_177958_n() || pourPos[1] != pos.func_177956_o() || pourPos[2] != pos.func_177952_p()) continue;
            return this.standardCheck(world, pos, side, stack);
        }
        return false;
    }

    @Override
    public boolean standardCheck(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.type != null && this.type != stack.material) {
            return false;
        }
        return this.amount < this.getCapacity() && this.getInstalledMold() != null;
    }

    @Override
    public int getCapacity() {
        ItemMold.Mold mold = this.getInstalledMold();
        return mold == null ? 50000 : mold.getCost() * 10 * 2;
    }

    private int getWaterRequired() {
        return this.getInstalledMold() != null ? 5 * this.getInstalledMold().getCost() : 50;
    }

    private void fillFluidInit() {
        for (DirPos dirPos : this.getFluidConPos()) {
            FFUtils.fillFluid(this, this.tanks[1], this.field_145850_b, dirPos.getPos(), 32000);
        }
    }

    @Override
    public Mats.MaterialStack standardAdd(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        this.type = stack.material;
        int limit = this.getCapacity();
        if (stack.amount + this.amount <= limit) {
            this.amount += stack.amount;
            return null;
        }
        int required = limit - this.amount;
        this.amount = limit;
        stack.amount -= required;
        this.lastProgressTick = world.func_82737_E();
        return stack;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineStrandCaster(player.field_71071_by, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiInfoContainer provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineStrandCaster(player.field_71071_by, this);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        nbt.func_74772_a("t", this.lastProgressTick);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        this.lastProgressTick = nbt.func_74763_f("t");
    }

    @Override
    public boolean isItemValidForSlot(int i, @NotNull ItemStack stack) {
        if (i == 0) {
            return stack.func_77973_b() == ModItems.mold;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing side) {
        return new int[]{1, 2, 3, 4, 5, 6};
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int side) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
        return !this.isItemValidForSlot(slot, itemStack);
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 7), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 7), (double)(this.field_174879_c.func_177958_n() + 7), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 7));
        }
        return this.bb;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == ModForgeFluids.SPENTSTEAM) {
            return this.tanks[1].drain(resource, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 128.0;
    }
}

