/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.NuclearTransmutationRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCapacitor;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineSchrabidiumTransmutator
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power = 0L;
    public int process = 0;
    public static final long maxPower = 50000000L;
    public static final int processSpeed = 600;
    private AudioWrapper audio;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 2};
    private static final int[] slots_side = new int[]{3, 2};
    private long detectPower;

    public TileEntityMachineSchrabidiumTransmutator() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.machine_schrabidium_transmutator";
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        switch (i) {
            case 0: {
                if (NuclearTransmutationRecipes.getOutput(stack) == null) break;
                return true;
            }
            case 2: {
                if (stack.func_77973_b() != ModItems.redcoil_capacitor && stack.func_77973_b() != ModItems.euphemium_capacitor) break;
                return true;
            }
            case 3: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean canExtractItem(int i, ItemStack stack, int amount) {
        if (i == 2 && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.redcoil_capacitor && ItemCapacitor.getDura(stack) <= 0) {
            return true;
        }
        if (i == 1) {
            return true;
        }
        if (i == 3) {
            return stack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)stack.func_77973_b()).getCharge(stack) == 0L;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.power = compound.func_74763_f("power");
        this.process = compound.func_74762_e("process");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("process", this.process);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 3, this.power, 50000000L);
            if (this.canProcess()) {
                this.process();
            } else {
                this.process = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.process);
            this.networkPack(data, 50);
            this.detectAndSendChanges();
        } else if (this.process > 0) {
            if (this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSound(HBMSoundHandler.tauChargeLoop, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 1.0f, 1.0f);
                this.audio.startSound();
            }
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.process = data.func_74762_e("progress");
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 50000000L;
    }

    public int getProgressScaled(int i) {
        return this.process * i / 600;
    }

    public boolean hasCoil() {
        if (this.inventory.getStackInSlot(2).func_77973_b() == ModItems.redcoil_capacitor && ItemCapacitor.getDura(this.inventory.getStackInSlot(2)) > 0) {
            return true;
        }
        return this.inventory.getStackInSlot(2).func_77973_b() == ModItems.euphemium_capacitor;
    }

    public boolean canProcess() {
        if (!this.hasCoil()) {
            return false;
        }
        if (this.inventory.getStackInSlot(0) == null || this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        long recipePower = NuclearTransmutationRecipes.getCombustionEnergy(this.inventory.getStackInSlot(0));
        if (recipePower < 0L) {
            return false;
        }
        if (recipePower > this.power) {
            return false;
        }
        ItemStack outputItem = NuclearTransmutationRecipes.getOutput(this.inventory.getStackInSlot(0));
        return this.inventory.getStackInSlot(1) == null || this.inventory.getStackInSlot(1).func_190926_b() || this.inventory.getStackInSlot(1).func_77973_b() == outputItem.func_77973_b() && this.inventory.getStackInSlot(1).func_190916_E() < this.inventory.getStackInSlot(1).func_77976_d();
    }

    public boolean isProcessing() {
        return this.process > 0;
    }

    public void process() {
        ++this.process;
        if (this.process >= 600) {
            this.power -= NuclearTransmutationRecipes.getCombustionEnergy(this.inventory.getStackInSlot(0));
            if (this.power < 0L) {
                this.power = 0L;
            }
            this.process = 0;
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.setStackInSlot(1, NuclearTransmutationRecipes.getOutput(this.inventory.getStackInSlot(0)).func_77946_l());
            } else {
                this.inventory.getStackInSlot(1).func_190917_f(1);
            }
            if (!this.inventory.getStackInSlot(2).func_190926_b() && this.inventory.getStackInSlot(2).func_77973_b() == ModItems.redcoil_capacitor) {
                ItemCapacitor.setDura(this.inventory.getStackInSlot(2), ItemCapacitor.getDura(this.inventory.getStackInSlot(2)) - 1);
            }
            this.inventory.getStackInSlot(0).func_190918_g(1);
            if (this.inventory.getStackInSlot(0).func_190916_E() == 0) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187754_de, SoundCategory.BLOCKS, 10000.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000000L;
    }
}

