/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.MobConfig;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFuelRod;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.FluidTypePacketTest;
import com.hbm.packet.LargeReactorPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineReactorLarge
extends TileEntity
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public ItemStackHandler inventory;
    public ICapabilityProvider dropProvider;
    public int hullHeat;
    public final int maxHullHeat = 100000;
    public int coreHeat;
    public final int maxCoreHeat = 50000;
    public int rods;
    public final int rodsMax = 100;
    public int age = 0;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public ReactorFuelType type;
    public int fuel;
    public int maxFuel = 240 * fuelMult;
    public int waste;
    public int maxWaste = 240 * fuelMult;
    public int compression;
    public static int fuelMult = 1000;
    public static int cycleDuration = 24000;
    private static int fuelBase = 240 * fuelMult;
    private String customName;
    private int height = 0;
    private int depth = 0;
    public int size = 1;
    static List<ReactorFuelEntry> fuels = new ArrayList<ReactorFuelEntry>();
    static List<ReactorWasteEntry> wastes = new ArrayList<ReactorWasteEntry>();

    public TileEntityMachineReactorLarge() {
        this.inventory = new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                TileEntityMachineReactorLarge.this.func_70296_d();
                super.onContentsChanged(slot);
            }
        };
        this.dropProvider = new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)TileEntityMachineReactorLarge.this.inventory) : null);
            }
        };
        this.tanks = new FluidTank[3];
        this.tankTypes = new Fluid[3];
        this.tanks[0] = new FluidTank(512000);
        this.tankTypes[0] = FluidRegistry.WATER;
        this.tanks[1] = new FluidTank(64000);
        this.tankTypes[1] = ModForgeFluids.COOLANT;
        this.tanks[2] = new FluidTank(512000);
        this.tankTypes[2] = ModForgeFluids.STEAM;
        this.type = ReactorFuelType.URANIUM;
        this.compression = 0;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.reactorLarge";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.coreHeat = compound.func_74762_e("heat");
        this.hullHeat = compound.func_74762_e("hullHeat");
        this.rods = compound.func_74762_e("rods");
        this.fuel = compound.func_74762_e("fuel");
        this.waste = compound.func_74762_e("waste");
        if (compound.func_74764_b("compression")) {
            this.compression = compound.func_74762_e("compression");
        }
        this.tankTypes[0] = FluidRegistry.WATER;
        this.tankTypes[1] = ModForgeFluids.COOLANT;
        if (this.compression == 0) {
            this.tankTypes[2] = ModForgeFluids.STEAM;
        } else if (this.compression == 1) {
            this.tankTypes[2] = ModForgeFluids.HOTSTEAM;
        } else if (this.compression == 2) {
            this.tankTypes[2] = ModForgeFluids.SUPERHOTSTEAM;
        }
        this.type = ReactorFuelType.getEnum(compound.func_74762_e("type"));
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("heat", this.coreHeat);
        compound.func_74768_a("hullHeat", this.hullHeat);
        compound.func_74768_a("rods", this.rods);
        compound.func_74768_a("fuel", this.fuel);
        compound.func_74768_a("waste", this.waste);
        compound.func_74768_a("compression", this.compression);
        compound.func_74768_a("type", this.type.getID());
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(compound);
    }

    public int getCoreHeatScaled(int i) {
        return this.coreHeat * i / 50000;
    }

    public int getHullHeatScaled(int i) {
        return this.hullHeat * i / 100000;
    }

    public int getFuelScaled(int i) {
        return this.fuel * i / this.maxFuel;
    }

    public int getWasteScaled(int i) {
        return this.waste * i / this.maxWaste;
    }

    public int getRodsScaled(int i) {
        return this.rods * i / 100;
    }

    public int getSteamScaled(int i) {
        return this.tanks[2].getFluidAmount() * i / this.tanks[2].getCapacity();
    }

    public boolean hasCoreHeat() {
        return this.coreHeat > 0;
    }

    public boolean hasHullHeat() {
        return this.hullHeat > 0;
    }

    public void compress(int level) {
        if (level == this.compression) {
            return;
        }
        if (level >= 0 && level < 3) {
            int newAmount;
            if (this.compression == 0) {
                if (level == 1) {
                    this.tankTypes[2] = ModForgeFluids.HOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() / 10.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
                if (level == 2) {
                    this.tankTypes[2] = ModForgeFluids.SUPERHOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() / 100.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
            }
            if (this.compression == 1) {
                if (level == 0) {
                    this.tankTypes[2] = ModForgeFluids.STEAM;
                    newAmount = this.tanks[2].getFluidAmount() * 10;
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
                if (level == 2) {
                    this.tankTypes[2] = ModForgeFluids.SUPERHOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() / 10.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
            }
            if (this.compression == 2) {
                if (level == 0) {
                    this.tankTypes[2] = ModForgeFluids.STEAM;
                    newAmount = this.tanks[2].getFluidAmount() * 100;
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
                if (level == 1) {
                    this.tankTypes[2] = ModForgeFluids.HOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() * 10.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
            }
            this.compression = level;
        }
    }

    public boolean checkBody() {
        int z;
        int y;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int x = this.field_174879_c.func_177958_n();
        return this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y = this.field_174879_c.func_177956_o(), (z = this.field_174879_c.func_177952_p()) + 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y, z + 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y, z - 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y, z - 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y, z)).func_177230_c() == ModBlocks.reactor_control && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y, z)).func_177230_c() == ModBlocks.reactor_control && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 1)).func_177230_c() == ModBlocks.reactor_control && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z - 1)).func_177230_c() == ModBlocks.reactor_control;
    }

    public boolean checkSegment(int offset2) {
        int z;
        int y;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int x = this.field_174879_c.func_177958_n();
        return this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, (y = this.field_174879_c.func_177956_o()) + offset2, (z = this.field_174879_c.func_177952_p()) + 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y + offset2, z + 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y + offset2, z - 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y + offset2, z - 1)).func_177230_c() == ModBlocks.reactor_element && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y + offset2, z)).func_177230_c() == ModBlocks.reactor_control && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y + offset2, z)).func_177230_c() == ModBlocks.reactor_control && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y + offset2, z + 1)).func_177230_c() == ModBlocks.reactor_control && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y + offset2, z - 1)).func_177230_c() == ModBlocks.reactor_control && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y + offset2, z)).func_177230_c() == ModBlocks.reactor_conductor;
    }

    private float checkHull() {
        float max = this.getSize() * 12;
        float count = 0.0f;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int x = this.field_174879_c.func_177958_n();
        int z = this.field_174879_c.func_177952_p();
        for (int y = this.field_174879_c.func_177956_o() - this.depth; y <= this.field_174879_c.func_177956_o() + this.height; ++y) {
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x - 1, y, z + 2))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x, y, z + 2))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x + 1, y, z + 2))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x - 1, y, z - 2))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x, y, z - 2))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x + 1, y, z - 2))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x + 2, y, z - 1))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x + 2, y, z))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x + 2, y, z + 1))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x - 2, y, z - 1))) {
                count += 1.0f;
            }
            if (this.blocksRad((BlockPos)mPos.func_181079_c(x - 2, y, z))) {
                count += 1.0f;
            }
            if (!this.blocksRad((BlockPos)mPos.func_181079_c(x - 2, y, z + 1))) continue;
            count += 1.0f;
        }
        if (count == 0.0f) {
            return 1.0f;
        }
        return 1.0f - count / max;
    }

    private boolean blocksRad(BlockPos pos) {
        Block b = this.field_145850_b.func_180495_p(pos).func_177230_c();
        if (RadiationSystemNT.isRadResistant(this.field_145850_b, b, pos)) {
            return true;
        }
        return b == ModBlocks.reactor_hatch || b == ModBlocks.reactor_ejector || b == ModBlocks.reactor_inserter;
    }

    private void caluclateSize() {
        int i;
        this.height = 0;
        this.depth = 0;
        for (i = 0; i < 7 && this.checkSegment(i + 1); ++i) {
            ++this.height;
        }
        for (i = 0; i < 7 && this.checkSegment(-i - 1); ++i) {
            ++this.depth;
        }
        this.size = this.height + this.depth + 1;
    }

    private int getSize() {
        return this.size;
    }

    private void generate() {
        int consumption = this.maxFuel / cycleDuration * this.rods / 100;
        if (consumption > this.fuel) {
            consumption = this.fuel;
        }
        if (consumption + this.waste > this.maxWaste) {
            consumption = this.maxWaste - this.waste;
        }
        this.fuel -= consumption;
        this.waste += consumption;
        int heat = consumption / this.size * this.type.heat / fuelMult;
        this.coreHeat += heat;
        if (consumption > 0 || heat > 0) {
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int z;
            int y;
            int x;
            BlockPos.MutableBlockPos mPos;
            int absorbed;
            int cont;
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1], this.tanks[2]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            if (this.checkBody()) {
                ++this.age;
                if (this.age >= 20) {
                    this.age = 0;
                }
                if (this.age == 1) {
                    this.caluclateSize();
                }
                this.fillFluidInit(this.tanks[2]);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c, this.size, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTypePacketTest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new Fluid[]{this.tankTypes[2]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            this.maxWaste = this.maxFuel = fuelBase * this.getSize();
            if (this.waste > this.maxWaste) {
                this.waste = this.maxWaste;
            }
            if (this.fuel > this.maxFuel) {
                this.fuel = this.maxFuel;
            }
            if (this.inputValidForTank(0, 0)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 0, 1);
            }
            if (this.inputValidForTank(1, 2)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 2, 3);
            }
            if (this.fuel == 0 && !TileEntityMachineReactorLarge.getFuelType(this.inventory.getStackInSlot(4).func_77973_b()).toString().equals(ReactorFuelType.UNKNOWN.toString())) {
                this.type = TileEntityMachineReactorLarge.getFuelType(this.inventory.getStackInSlot(4).func_77973_b());
                this.waste = 0;
            }
            if (this.coreHeat > 0 && this.inventory.getStackInSlot(4).func_77973_b() == ModItems.meteorite_sword_bred) {
                this.inventory.setStackInSlot(4, new ItemStack(ModItems.meteorite_sword_irradiated));
            }
            if (TileEntityMachineReactorLarge.getFuelContent(this.inventory.getStackInSlot(4), this.type) > 0 && this.fuel + (cont = TileEntityMachineReactorLarge.getFuelContent(this.inventory.getStackInSlot(4), this.type) * fuelMult) <= this.maxFuel) {
                if (!this.inventory.getStackInSlot(4).func_77973_b().hasContainerItem(this.inventory.getStackInSlot(4))) {
                    this.inventory.getStackInSlot(4).func_190918_g(1);
                    this.fuel += cont;
                } else if (this.inventory.getStackInSlot(5).func_190926_b()) {
                    this.inventory.setStackInSlot(5, new ItemStack(this.inventory.getStackInSlot(4).func_77973_b().func_77668_q()));
                    this.inventory.getStackInSlot(4).func_190918_g(1);
                    this.fuel += cont;
                } else if (this.inventory.getStackInSlot(4).func_77973_b().func_77668_q() == this.inventory.getStackInSlot(5).func_77973_b() && this.inventory.getStackInSlot(5).func_190916_E() < this.inventory.getStackInSlot(5).func_77976_d()) {
                    this.inventory.getStackInSlot(4).func_190918_g(1);
                    this.inventory.getStackInSlot(5).func_190917_f(1);
                    this.fuel += cont;
                }
                if (this.inventory.getStackInSlot(4).func_190926_b()) {
                    this.inventory.setStackInSlot(4, ItemStack.field_190927_a);
                }
            }
            if (TileEntityMachineReactorLarge.getWasteAbsorbed(this.inventory.getStackInSlot(6).func_77973_b(), this.type) > 0 && (absorbed = TileEntityMachineReactorLarge.getWasteAbsorbed(this.inventory.getStackInSlot(6).func_77973_b(), this.type) * fuelMult) <= this.waste) {
                if (this.inventory.getStackInSlot(7).func_190926_b()) {
                    this.waste -= absorbed;
                    this.inventory.setStackInSlot(7, new ItemStack(TileEntityMachineReactorLarge.getWaste(this.inventory.getStackInSlot(6).func_77973_b(), this.type)));
                    this.inventory.getStackInSlot(6).func_190918_g(1);
                } else if (this.inventory.getStackInSlot(7).func_77973_b() == TileEntityMachineReactorLarge.getWaste(this.inventory.getStackInSlot(6).func_77973_b(), this.type) && this.inventory.getStackInSlot(7).func_190916_E() < this.inventory.getStackInSlot(7).func_77976_d()) {
                    this.waste -= absorbed;
                    this.inventory.getStackInSlot(7).func_190917_f(1);
                    this.inventory.getStackInSlot(6).func_190918_g(1);
                }
                if (this.inventory.getStackInSlot(6).func_190926_b()) {
                    this.inventory.setStackInSlot(6, ItemStack.field_190927_a);
                }
            }
            if (this.rods > 0) {
                this.generate();
            }
            if (this.coreHeat > 0 && this.tanks[1].getFluidAmount() > 0 && this.hullHeat < this.maxHullHeat) {
                this.hullHeat = (int)((double)this.hullHeat + (double)this.coreHeat * 0.175);
                this.coreHeat = (int)((double)this.coreHeat - (double)this.coreHeat * 0.1);
                this.tanks[1].drain(10, true);
            }
            if (this.hullHeat > 100000) {
                this.hullHeat = 100000;
            }
            if (this.hullHeat > 0 && this.tanks[0].getFluidAmount() > 0) {
                this.generateSteam();
                this.hullHeat = (int)((double)this.hullHeat - (double)this.hullHeat * 0.085);
            }
            if (this.coreHeat > 50000) {
                this.explode();
            }
            if (this.rods > 0 && this.coreHeat > 0 && this.age == 5) {
                float rad = (float)this.coreHeat / 50000.0f * 50.0f;
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, rad *= this.checkHull(), 200.0f);
            }
            if (this.field_145850_b.func_180495_p((BlockPos)(mPos = new BlockPos.MutableBlockPos()).func_181079_c(x = this.field_174879_c.func_177958_n(), y = this.field_174879_c.func_177956_o(), (z = this.field_174879_c.func_177952_p()) - 2)).func_177230_c() == ModBlocks.reactor_ejector && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z - 2)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.NORTH) {
                this.tryEjectInto((BlockPos)mPos.func_181079_c(x, y, z - 3));
            }
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 2)).func_177230_c() == ModBlocks.reactor_ejector && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 2)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.SOUTH) {
                this.tryEjectInto((BlockPos)mPos.func_181079_c(x, y, z + 3));
            }
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 2, y, z)).func_177230_c() == ModBlocks.reactor_ejector && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 2, y, z)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.WEST) {
                this.tryEjectInto((BlockPos)mPos.func_181079_c(x - 3, y, z));
            }
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 2, y, z)).func_177230_c() == ModBlocks.reactor_ejector && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 2, y, z)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.EAST) {
                this.tryEjectInto((BlockPos)mPos.func_181079_c(x + 3, y, z));
            }
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z - 2)).func_177230_c() == ModBlocks.reactor_inserter && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z - 2)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.NORTH) {
                this.tryInsertFrom((BlockPos)mPos.func_181079_c(x, y, z - 3));
            }
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 2)).func_177230_c() == ModBlocks.reactor_inserter && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 2)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.SOUTH) {
                this.tryInsertFrom((BlockPos)mPos.func_181079_c(x, y, z + 3));
            }
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 2, y, z)).func_177230_c() == ModBlocks.reactor_inserter && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 2, y, z)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.WEST) {
                this.tryInsertFrom((BlockPos)mPos.func_181079_c(x - 3, y, z));
            }
            if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 2, y, z)).func_177230_c() == ModBlocks.reactor_inserter && this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 2, y, z)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == EnumFacing.EAST) {
                this.tryInsertFrom((BlockPos)mPos.func_181079_c(x + 3, y, z));
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new LargeReactorPacket(this.field_174879_c, this.rods, this.coreHeat, this.hullHeat, this.fuel, this.maxFuel, this.waste, this.maxWaste, this.type.getID()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (!this.inventory.getStackInSlot(slot).func_190926_b() && this.tanks[tank] != null) {
            return this.inventory.getStackInSlot(slot).func_77973_b() == ModItems.fluid_barrel_infinite || this.isValidFluidForTank(tank, FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
        }
        return false;
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tanks[tank] == null) {
            return false;
        }
        return stack.getFluid() == this.tankTypes[tank];
    }

    private void tryEjectInto(BlockPos pos) {
        int wSize;
        int n = wSize = this.type.toString().equals(ReactorFuelType.SCHRABIDIUM.toString()) ? 60 * fuelMult : 6 * fuelMult;
        if (this.waste < wSize) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler chest = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            Item waste = ModItems.waste_uranium_hot;
            switch (this.type) {
                case PLUTONIUM: {
                    waste = ModItems.waste_plutonium_hot;
                    break;
                }
                case MOX: {
                    waste = ModItems.waste_mox_hot;
                    break;
                }
                case SCHRABIDIUM: {
                    waste = ModItems.waste_schrabidium_hot;
                    break;
                }
                case THORIUM: {
                    waste = ModItems.waste_thorium_hot;
                    break;
                }
                default: {
                    waste = ModItems.waste_uranium_hot;
                }
            }
            for (int i = 0; i < chest.getSlots(); ++i) {
                if (!chest.insertItem(i, new ItemStack(waste), false).func_190926_b()) continue;
                this.waste -= wSize;
                return;
            }
        }
    }

    private void tryInsertFrom(BlockPos pos) {
        block6: {
            IItemHandler check;
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || !((check = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IItemHandlerModifiable)) break block6;
            IItemHandlerModifiable chest = (IItemHandlerModifiable)check;
            if (this.fuel > 0) {
                for (int i = 0; i < chest.getSlots(); ++i) {
                    int cont;
                    if (chest.getStackInSlot(i).func_190926_b() || (cont = TileEntityMachineReactorLarge.getFuelContent(chest.getStackInSlot(i), this.type) * fuelMult) <= 0 || this.fuel + cont > this.maxFuel) continue;
                    Item container = chest.getStackInSlot(i).func_77973_b().func_77668_q();
                    chest.getStackInSlot(i).func_190918_g(1);
                    if (chest.getStackInSlot(i).func_190926_b()) {
                        chest.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    this.fuel += cont;
                    if (!chest.getStackInSlot(i).func_190926_b() || container == null) continue;
                    chest.setStackInSlot(i, new ItemStack(container));
                }
            } else {
                for (int i = 0; i < chest.getSlots(); ++i) {
                    int cont;
                    if (chest.getStackInSlot(i).func_190926_b() || (cont = TileEntityMachineReactorLarge.getFuelContent(chest.getStackInSlot(i), TileEntityMachineReactorLarge.getFuelType(chest.getStackInSlot(i).func_77973_b())) * fuelMult) <= 0 || this.fuel + cont > this.maxFuel) continue;
                    Item container = chest.getStackInSlot(i).func_77973_b().func_77668_q();
                    this.type = TileEntityMachineReactorLarge.getFuelType(chest.getStackInSlot(i).func_77973_b());
                    chest.getStackInSlot(i).func_190918_g(1);
                    if (chest.getStackInSlot(i).func_190926_b()) {
                        chest.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    this.fuel += cont;
                    if (!chest.getStackInSlot(i).func_190926_b() || container == null) continue;
                    chest.setStackInSlot(i, new ItemStack(container));
                }
            }
        }
    }

    private void generateSteam() {
        double statSteMaFiFiLe = 32000.0;
        int waterConsumption = (int)((double)this.hullHeat / 100000.0 * (statSteMaFiFiLe / 50.0) * (double)this.size);
        int steamMul = 1;
        if (this.tankTypes[2] == ModForgeFluids.STEAM) {
            steamMul = 100;
        } else if (this.tankTypes[2] == ModForgeFluids.HOTSTEAM) {
            steamMul = 10;
        } else if (this.tankTypes[2] == ModForgeFluids.SUPERHOTSTEAM) {
            steamMul = 1;
        }
        int steamProduction = waterConsumption * steamMul;
        int waterFill = this.tanks[0].getFluidAmount();
        if (waterFill > 0) {
            if (waterFill < waterConsumption) {
                waterConsumption = waterFill;
                steamProduction = waterConsumption * steamMul;
            }
            this.tanks[0].drain(waterConsumption, true);
            this.tanks[2].fill(new FluidStack(this.tankTypes[2], steamProduction), true);
        }
    }

    private void explode() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        int rad = (int)((long)this.fuel * 25000L / ((long)fuelBase * 15L));
        RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, rad, 75000.0f);
        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 7.5f, true);
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 35);
        for (int i = this.field_174879_c.func_177956_o() - this.depth; i <= this.field_174879_c.func_177956_o() + this.height; ++i) {
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_174879_c.func_177958_n() + 1, i, this.field_174879_c.func_177952_p() + 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_174879_c.func_177958_n() + 1, i, this.field_174879_c.func_177952_p() - 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_174879_c.func_177958_n() - 1, i, this.field_174879_c.func_177952_p() - 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.randomizeRadBlock(this.field_174879_c.func_177958_n() - 1, i, this.field_174879_c.func_177952_p() + 1);
            }
            if (this.field_145850_b.field_73012_v.nextInt(5) != 0) continue;
            this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0f, true);
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.sellafield_core.func_176203_a(this.field_145850_b.field_73012_v.nextInt(4)));
        if (MobConfig.enableElementals) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_72314_b(100.0, 100.0, 100.0));
            for (EntityPlayer player : players) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", true);
            }
        }
    }

    private void randomizeRadBlock(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        int rand = this.field_145850_b.field_73012_v.nextInt(20);
        if (rand < 3) {
            this.field_145850_b.func_175656_a(pos, ModBlocks.corium_block.func_176223_P());
        } else if (rand < 10) {
            this.field_145850_b.func_175656_a(pos, ModBlocks.block_corium.func_176223_P());
        } else {
            this.field_145850_b.func_175656_a(pos, ModBlocks.block_corium_cobble.func_176223_P());
        }
    }

    public void fillFluidInit(FluidTank tank) {
        int z;
        int y;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int x = this.field_174879_c.func_177958_n();
        if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x - 2, y = this.field_174879_c.func_177956_o(), z = this.field_174879_c.func_177952_p())).func_177230_c() == ModBlocks.reactor_hatch) {
            FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n() - 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), 2560000);
        }
        if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x + 2, y, z)).func_177230_c() == ModBlocks.reactor_hatch) {
            FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n() + 3, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), 2560000);
        }
        if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z - 2)).func_177230_c() == ModBlocks.reactor_hatch) {
            FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 3), 2560000);
        }
        if (this.field_145850_b.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 2)).func_177230_c() == ModBlocks.reactor_hatch) {
            FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 3), 2560000);
        }
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + this.height + 1, this.field_174879_c.func_177952_p()), 2560000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - this.depth - 1, this.field_174879_c.func_177952_p()), 2560000);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == this.tankTypes[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == this.tankTypes[1]) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.tankTypes[2]) {
            return this.tanks[2].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[2].drain(maxDrain, doDrain);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 3) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
            this.tanks[2].readFromNBT(tags[2]);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing));
    }

    public static void registerFuelEntry(int nuggets, ReactorFuelType type, Item fuel) {
        fuels.add(new ReactorFuelEntry(nuggets, type, fuel));
    }

    public static void registerWasteEntry(int nuggets, ReactorFuelType type, Item in, Item out) {
        wastes.add(new ReactorWasteEntry(nuggets, type, in, out));
    }

    public static int getFuelContent(ItemStack item, ReactorFuelType type) {
        if (item == null || item.func_190926_b()) {
            return 0;
        }
        for (ReactorFuelEntry ent : fuels) {
            if (ent.item != item.func_77973_b() || !type.toString().equals(ent.type.toString())) continue;
            int value = ent.value;
            if (item.func_77973_b() instanceof ItemFuelRod) {
                double mult = 1.0 - (double)ItemFuelRod.getLifeTime(item) / (double)((ItemFuelRod)item.func_77973_b()).getMaxLifeTime();
                return (int)Math.floor(mult * (double)value);
            }
            return value;
        }
        return 0;
    }

    public static ReactorFuelType getFuelType(Item item) {
        for (ReactorFuelEntry ent : fuels) {
            if (ent.item != item) continue;
            return ent.type;
        }
        return ReactorFuelType.UNKNOWN;
    }

    public static Item getWaste(Item item, ReactorFuelType type) {
        for (ReactorWasteEntry ent : wastes) {
            if (ent.in != item || !type.toString().equals(ent.type.toString())) continue;
            return ent.out;
        }
        return null;
    }

    public static int getWasteAbsorbed(Item item, ReactorFuelType type) {
        for (ReactorWasteEntry ent : wastes) {
            if (ent.in != item || !type.toString().equals(ent.type.toString())) continue;
            return ent.value;
        }
        return 0;
    }

    public static enum ReactorFuelType {
        URANIUM(250000),
        THORIUM(200000),
        PLUTONIUM(312500),
        MOX(250000),
        SCHRABIDIUM(2085000),
        UNKNOWN(1);

        private final int heat;

        private ReactorFuelType(int i) {
            this.heat = i;
        }

        public int getHeat() {
            return this.heat;
        }

        public int getID() {
            return Arrays.asList(ReactorFuelType.values()).indexOf((Object)this);
        }

        public static ReactorFuelType getEnum(int i) {
            if (i < ReactorFuelType.values().length) {
                return ReactorFuelType.values()[i];
            }
            return URANIUM;
        }
    }

    static class ReactorFuelEntry {
        int value;
        ReactorFuelType type;
        Item item;

        public ReactorFuelEntry(int value, ReactorFuelType type, Item item) {
            this.value = value;
            this.type = type;
            this.item = item;
        }
    }

    static class ReactorWasteEntry {
        int value;
        ReactorFuelType type;
        Item in;
        Item out;

        public ReactorWasteEntry(int value, ReactorFuelType type, Item in, Item out) {
            this.value = value;
            this.type = type;
            this.in = in;
            this.out = out;
        }
    }
}

