/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.items.machine.ItemRTGPellet;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityMachineRTG
extends TileEntityMachineBase
implements ITickable,
IEnergyGenerator {
    public int heat;
    public final int heatMax = 6000;
    public long power;
    public final long maxPower = 1000000L;
    public static final long powerPerTU = 25L;
    private int detectHeat;
    private long detectPower;

    public TileEntityMachineRTG() {
        super(15);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendPower(this.field_145850_b, this.field_174879_c);
            int[] slots = new int[this.inventory.getSlots()];
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                slots[i] = i;
            }
            this.heat = RTGUtil.updateRTGs(this.inventory, slots);
            if (this.heat > 6000) {
                this.heat = 6000;
            }
            this.power += (long)this.heat * 25L;
            if (this.power > 1000000L) {
                this.power = 1000000L;
            }
            this.detectAndSendChanges();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.heat = compound.func_74762_e("heat");
        this.detectHeat = this.heat + 1;
        this.power = compound.func_74763_f("power");
        this.detectPower = this.power + 1L;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("heat", this.heat);
        compound.func_74772_a("power", this.power);
        return super.func_189515_b(compound);
    }

    @Override
    public String getName() {
        return "container.rtg";
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 6000;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean hasHeat() {
        return this.heat > 0;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectHeat != this.heat) {
            mark = true;
            this.detectHeat = this.heat;
        }
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return !(itemStack.func_77973_b() instanceof ItemRTGPellet);
    }
}

