/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.config.MachineConfig;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.MixerRecipes;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMixer;
import com.hbm.inventory.gui.GUIMixer;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.DirPos;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineMixer
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IFluidHandler,
IEnergyUser,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 10000L;
    public int progress;
    public int processTime;
    public Fluid outputFluid = null;
    public float rotation;
    public float prevRotation;
    public boolean wasOn = false;
    private int consumption = 50;
    public boolean uuMixer = false;
    public static final int uuConsumption = 1000000;
    public static final long uuMaxPower = 200000000L;
    public static final int normalConsumption = 50;
    public FluidTank[] tanks;
    private final UpgradeManager upgradeManager = new UpgradeManager();
    AxisAlignedBB aabb;

    public TileEntityMachineMixer() {
        super(5);
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(16000);
        this.tanks[1] = new FluidTank(16000);
        this.tanks[2] = new FluidTank(24000);
    }

    @Override
    public String getName() {
        if (this.uuMixer) {
            return "container.machineUUMixer";
        }
        return "container.machineMixer";
    }

    public void func_73660_a() {
        this.updateTankSizes();
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, this.getMaxPower());
            this.upgradeManager.eval((IItemHandler)this.inventory, 3, 4);
            int speedLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            int powerLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.uuMixer = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SCREAM) > 0;
            this.updateTankType();
            if (this.uuMixer) {
                this.updateInputUUtank();
            } else {
                this.updateInputTankTypes();
            }
            this.consumption = this.getConsumption();
            this.consumption *= speedLevel + 1;
            this.consumption *= overLevel * 3 + 1;
            this.consumption /= powerLevel + 1;
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
            }
            this.wasOn = this.canProcess();
            if (this.wasOn) {
                ++this.progress;
                this.power -= (long)this.consumption;
                this.processTime -= this.processTime * speedLevel / 4;
                this.processTime /= overLevel + 1;
                if (this.processTime <= 0) {
                    this.processTime = 1;
                }
                if (this.progress >= this.processTime) {
                    this.process();
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[2].getFluidAmount() <= 0) continue;
                FFUtils.fillFluid(this, this.tanks[2], this.field_145850_b, pos.getPos(), this.tanks[2].getCapacity() >> 1);
            }
            NBTTagCompound data = new NBTTagCompound();
            if (this.outputFluid != null) {
                data.func_74778_a("f", this.outputFluid.getName());
            } else if (this.tanks[2].getFluid() != null) {
                data.func_74778_a("f", this.tanks[2].getFluid().getFluid().getName());
            } else {
                data.func_74778_a("f", "None");
            }
            if (!this.uuMixer && this.power > this.getMaxPower()) {
                this.power = this.getMaxPower();
            }
            data.func_74772_a("power", this.power);
            data.func_74768_a("processTime", this.processTime);
            data.func_74768_a("progress", this.progress);
            data.func_74757_a("wasOn", this.wasOn);
            data.func_74757_a("uu", this.uuMixer);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            this.networkPack(data, 50);
        } else {
            this.prevRotation = this.rotation;
            if (this.wasOn) {
                this.rotation = this.uuMixer ? (this.rotation += 40.0f) : (this.rotation += 20.0f);
            }
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    private void updateTankType() {
        Fluid fluid;
        ItemStack slotId = this.inventory.getStackInSlot(2);
        Item itemId = slotId.func_77973_b();
        if (itemId == ModItems.forge_fluid_identifier && this.outputFluid != (fluid = ItemForgeFluidIdentifier.getType(slotId)) && (this.uuMixer && MachineConfig.isFluidAllowed(fluid) || MixerRecipes.hasMixerRecipe(fluid))) {
            this.outputFluid = fluid;
            this.tanks[2].setFluid(new FluidStack(fluid, 0));
            this.func_70296_d();
        }
    }

    private void updateTankSizes() {
        if (this.uuMixer) {
            if (this.tanks[0].getCapacity() != 2000000000) {
                this.tanks[0] = FFUtils.changeTankSize(this.tanks[0], 2000000000);
                this.tanks[1] = FFUtils.changeTankSize(this.tanks[1], 2000000000);
                this.tanks[2] = FFUtils.changeTankSize(this.tanks[2], 2000000000 / MachineConfig.uuMixerFluidRatio);
                this.func_70296_d();
            }
        } else if (this.tanks[0].getCapacity() != 16000) {
            this.tanks[0] = FFUtils.changeTankSize(this.tanks[0], 16000);
            this.tanks[1] = FFUtils.changeTankSize(this.tanks[1], 16000);
            this.tanks[2] = FFUtils.changeTankSize(this.tanks[2], 24000);
            this.func_70296_d();
        }
    }

    private void updateInputUUtank() {
        if (this.tanks[0].getFluid() == null || this.tanks[0].getFluid().getFluid() != ModForgeFluids.UU_MATTER) {
            this.tanks[0].setFluid(new FluidStack(ModForgeFluids.UU_MATTER, 0));
        }
        if (this.tanks[1].getFluid() != null) {
            this.tanks[1].setFluid(null);
        }
        if (this.outputFluid == null && this.tanks[2].getFluid() != null) {
            this.outputFluid = this.tanks[2].getFluid().getFluid();
        }
    }

    private void updateInputTankTypes() {
        if (this.outputFluid == null) {
            return;
        }
        Fluid[] f = MixerRecipes.getInputFluids(this.outputFluid);
        if (f == null) {
            if (this.tanks[0].getFluid() != null) {
                this.tanks[0].setFluid(null);
            }
            if (this.tanks[1].getFluid() != null) {
                this.tanks[1].setFluid(null);
            }
        } else if (f.length > 0) {
            FluidStack t1 = this.tanks[0].getFluid();
            if (t1 == null || t1.getFluid() != f[0]) {
                this.tanks[0].setFluid(new FluidStack(f[0], 0));
            }
            if (f.length == 2) {
                FluidStack t2 = this.tanks[1].getFluid();
                if (t2 == null || t2.getFluid() != f[1]) {
                    this.tanks[1].setFluid(new FluidStack(f[1], 0));
                }
            } else {
                this.tanks[1].setFluid(null);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        if (nbt.func_74764_b("f")) {
            this.outputFluid = nbt.func_74779_i("f").equals("None") ? null : FluidRegistry.getFluid((String)nbt.func_74779_i("f"));
        }
        this.power = nbt.func_74763_f("power");
        this.processTime = nbt.func_74762_e("processTime");
        this.progress = nbt.func_74762_e("progress");
        this.wasOn = nbt.func_74767_n("wasOn");
        this.uuMixer = nbt.func_74767_n("uu");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    public boolean canProcess() {
        if (this.power < (long)this.consumption) {
            return false;
        }
        if (this.uuMixer) {
            this.processTime = 200;
            return this.outputFluid != null && this.tanks[2].getFluidAmount() < this.tanks[2].getCapacity() && FFUtils.hasEnoughFluid(this.tanks[0], new FluidStack(ModForgeFluids.UU_MATTER, MachineConfig.uuMixerFluidRatio));
        }
        if (!MixerRecipes.hasMixerRecipe(this.outputFluid)) {
            this.outputFluid = null;
            return false;
        }
        FluidStack[] fluidInputs = MixerRecipes.getInputFluidStacks(this.outputFluid);
        if (fluidInputs != null) {
            if (fluidInputs.length >= 1 && !FFUtils.hasEnoughFluid(this.tanks[0], fluidInputs[0])) {
                return false;
            }
            if (fluidInputs.length == 2 && !FFUtils.hasEnoughFluid(this.tanks[1], fluidInputs[1])) {
                return false;
            }
        }
        if (this.tanks[2].getCapacity() - this.tanks[2].getFluidAmount() < MixerRecipes.getFluidOutputAmount(this.outputFluid)) {
            return false;
        }
        if (!MixerRecipes.matchesInputItem(this.outputFluid, this.inventory.getStackInSlot(1))) {
            return false;
        }
        if (this.inventory.getStackInSlot(1).func_190916_E() < MixerRecipes.getInputItemCount(this.outputFluid)) {
            return false;
        }
        this.processTime = MixerRecipes.getRecipeDuration(this.outputFluid);
        return true;
    }

    protected void process() {
        int itemuse;
        if (this.uuMixer) {
            int mbProduction = Math.min(this.tanks[2].getCapacity() - this.tanks[2].getFluidAmount(), this.tanks[0].getFluidAmount() / MachineConfig.uuMixerFluidRatio);
            this.tanks[0].drain(mbProduction * MachineConfig.uuMixerFluidRatio, true);
            this.tanks[2].fill(new FluidStack(this.outputFluid, mbProduction), true);
            this.func_70296_d();
            return;
        }
        FluidStack[] fluidInputs = MixerRecipes.getInputFluidStacks(this.outputFluid);
        if (fluidInputs != null) {
            if (fluidInputs.length >= 1) {
                this.tanks[0].drain(fluidInputs[0].amount, true);
            }
            if (fluidInputs.length == 2) {
                this.tanks[1].drain(fluidInputs[1].amount, true);
            }
        }
        if ((itemuse = MixerRecipes.getInputItemCount(this.outputFluid)) > 0) {
            ItemStack stack = this.inventory.getStackInSlot(1);
            stack.func_190918_g(itemuse);
            if (stack.func_190916_E() == 0) {
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
            }
        }
        this.tanks[2].fill(new FluidStack(this.outputFluid, MixerRecipes.getFluidOutputAmount(this.outputFluid)), true);
        this.func_70296_d();
    }

    public int getConsumption() {
        if (this.uuMixer) {
            return 1000000;
        }
        return 50;
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_174879_c.func_177982_a(0, -1, 0), Library.NEG_Y), new DirPos(this.field_174879_c.func_177982_a(1, 0, 0), Library.POS_X), new DirPos(this.field_174879_c.func_177982_a(-1, 0, 0), Library.NEG_X), new DirPos(this.field_174879_c.func_177982_a(0, 0, 1), Library.POS_Z), new DirPos(this.field_174879_c.func_177982_a(0, 0, -1), Library.NEG_Z)};
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{1};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        if (i == 1) {
            return MixerRecipes.matchesInputItem(this.outputFluid, itemStack);
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("f")) {
            this.outputFluid = nbt.func_74779_i("f").equals("None") ? null : FluidRegistry.getFluid((String)nbt.func_74779_i("f"));
        }
        this.uuMixer = nbt.func_74767_n("uu");
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.outputFluid != null) {
            nbt.func_74778_a("f", this.outputFluid.getName());
        } else if (this.tanks[2].getFluid() != null) {
            nbt.func_74778_a("f", this.tanks[2].getFluid().getFluid().getName());
        } else {
            nbt.func_74778_a("f", "None");
        }
        nbt.func_74757_a("uu", this.uuMixer);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("processTime", this.processTime);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        if (this.uuMixer) {
            return 200000000L;
        }
        return 10000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMixer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMixer(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.aabb != null) {
            return this.aabb;
        }
        this.aabb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 1));
        return this.aabb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 3) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
        this.tanks[2].readFromNBT(tags[2]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.tanks[0].getFluid() != null && resource.isFluidEqual(this.tanks[0].getFluid())) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (this.tanks[1].getFluid() != null && resource.isFluidEqual(this.tanks[1].getFluid())) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.getFluid() != this.outputFluid) {
            return null;
        }
        return this.tanks[2].drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[2].drain(maxDrain, doDrain);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

