/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.google.common.base.Predicate;
import com.google.common.collect.HashBiMap;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineIGenerator
extends TileEntityMachineBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public int lastBurnTime;
    public int burnTime;
    public int temperature;
    public static final int maxTemperature = 1000;
    public int torque;
    public static final int maxTorque = 10000;
    public float limiter = 0.0f;
    public static final int animSpeed = 50;
    @SideOnly(value=Side.CLIENT)
    public float rotation;
    @SideOnly(value=Side.CLIENT)
    public float prevRotation;
    public IGenRTG[] pellets = new IGenRTG[12];
    public FluidTank[] tanks = new FluidTank[3];
    public Fluid[] tankTypes;
    public static final Map<Fluid, Integer> fluidHeat = new HashMap<Fluid, Integer>();
    int ignoreNext = 0;
    private static HashBiMap<Item, IGenRTG> rtgPellets;

    public TileEntityMachineIGenerator() {
        super(13);
        this.tanks[0] = new FluidTank(16000);
        this.tanks[1] = new FluidTank(16000);
        this.tanks[2] = new FluidTank(4000);
        this.tankTypes = new Fluid[3];
        this.tankTypes[0] = FluidRegistry.WATER;
        this.tankTypes[1] = ModForgeFluids.HEATINGOIL;
        this.tankTypes[2] = ModForgeFluids.LUBRICANT;
    }

    @Override
    public String getName() {
        return "container.iGenerator";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendIGenPower();
            FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 7, 8);
            if (FFUtils.checkRestrictions(this.inventory.getStackInSlot(9), (Predicate<FluidStack>)((Predicate)stack -> {
                if (stack != null && fluidHeat.containsKey(stack.getFluid())) {
                    return fluidHeat.get(stack.getFluid()) > 0;
                }
                return false;
            }))) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 9, 10);
            }
            FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[2], 11, 12);
            this.loadFuel();
            this.pelletAction();
            if (this.burnTime > 0) {
                --this.burnTime;
                this.temperature += 100;
            }
            this.fuelAction();
            if (this.temperature > 1000) {
                this.temperature = 1000;
            }
            int displayHeat = this.temperature;
            this.rtgAction();
            this.rotorAction();
            this.generatorAction();
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 6, this.power, 1000000L);
            NBTTagCompound data = new NBTTagCompound();
            int[] rtgs = new int[this.pellets.length];
            for (int i = 0; i < this.pellets.length; ++i) {
                rtgs[i] = this.pellets[i] != null ? this.pellets[i].ordinal() : -1;
            }
            data.func_74783_a("rtgs", rtgs);
            data.func_74768_a("temp", displayHeat);
            data.func_74768_a("torque", this.torque);
            data.func_74768_a("power", (int)this.power);
            data.func_74777_a("burn", (short)this.burnTime);
            data.func_74777_a("lastBurn", (short)this.lastBurnTime);
            data.func_74776_a("dial", this.limiter);
            this.networkPack(data, 250);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1], this.tanks[2]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        } else {
            this.prevRotation = this.rotation;
            this.rotation += (float)(this.torque * 50 / 10000);
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        int[] rtgs = nbt.func_74759_k("rtgs");
        if (rtgs != null) {
            for (int i = 0; i < this.pellets.length; ++i) {
                int pellet = rtgs[i];
                this.pellets[i] = pellet >= 0 && pellet < IGenRTG.values().length ? IGenRTG.values()[pellet] : null;
            }
        }
        this.temperature = nbt.func_74762_e("temp");
        this.torque = nbt.func_74762_e("torque");
        this.power = nbt.func_74762_e("power");
        this.burnTime = nbt.func_74765_d("burn");
        this.lastBurnTime = nbt.func_74765_d("lastBurn");
        if (this.ignoreNext <= 0) {
            this.limiter = nbt.func_74760_g("dial");
        } else {
            --this.ignoreNext;
        }
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            this.pushPellet();
        }
        if (meta == 1) {
            this.popPellet();
        }
        if (meta == 2) {
            this.setDialByAngle(value);
        }
    }

    private void loadFuel() {
        int time;
        if (this.burnTime <= 0 && (time = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(0)) / 2) > 0) {
            if (this.inventory.getStackInSlot(0).func_77973_b().hasContainerItem(this.inventory.getStackInSlot(0)) && this.inventory.getStackInSlot(0).func_190916_E() == 1) {
                this.inventory.setStackInSlot(0, this.inventory.getStackInSlot(0).func_77973_b().getContainerItem(this.inventory.getStackInSlot(0)));
            } else {
                this.inventory.getStackInSlot(0).func_190918_g(1);
            }
            this.burnTime = time;
            this.lastBurnTime = time;
            this.func_70296_d();
        }
    }

    private void pelletAction() {
        for (int i = 0; i < this.pellets.length; ++i) {
            if (this.pellets[i] == null) continue;
            this.temperature += this.pellets[i].heat;
        }
    }

    private void fuelAction() {
        int heat = this.getHeatFromFuel(this.tanks[1].getFluid());
        int maxBurn = 2;
        if (this.tanks[1].getFluidAmount() > 0) {
            int burn = Math.min(maxBurn, this.tanks[1].getFluidAmount());
            this.tanks[1].drain(burn, true);
            this.temperature += heat * burn;
        }
    }

    public int getHeatFromFuel(FluidStack fluid) {
        if (fluid == null) {
            return 0;
        }
        return fluidHeat.get(fluid.getFluid());
    }

    private void rtgAction() {
        int rtg = 0;
        for (int i = 3; i <= 5; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.thermo_element) continue;
            rtg += 15;
        }
        int pow = Math.min(this.temperature, rtg);
        this.temperature -= pow;
        this.power += (long)pow;
        if (this.power > 1000000L) {
            this.power = 1000000L;
        }
    }

    private void rotorAction() {
        int conversion = this.getConversion();
        if (this.temperature > 10 && this.tanks[0].getFluidAmount() > 0) {
            this.tanks[0].drain(1, true);
        }
        if (this.torque > 10 && this.tanks[2].getFluidAmount() > 0 && this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            this.tanks[2].drain(1, true);
        }
        this.torque = (int)((double)this.torque + (double)conversion * (this.tanks[0].getFluidAmount() > 0 ? 1.5 : 1.0));
        this.temperature -= conversion;
        if (this.torque > 10000) {
            this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 5.0f, true);
        }
    }

    private void generatorAction() {
        double balanceFactor = 0.25;
        this.power = (long)((double)this.power + (double)this.torque * balanceFactor);
        this.torque -= this.getBrake();
        if (this.power > 1000000L) {
            this.power = 1000000L;
        }
    }

    public int getBrake() {
        return (int)Math.ceil((double)this.torque * 0.1 * (this.tanks[2].getFluidAmount() > 0 ? 0.5 : 1.0));
    }

    public int getConversion() {
        return (int)((float)this.temperature * this.limiter);
    }

    private void pushPellet() {
        IGenRTG pellet;
        if (this.pellets[11] != null) {
            return;
        }
        if (!this.inventory.getStackInSlot(1).func_190926_b() && (pellet = IGenRTG.getPellet(this.inventory.getStackInSlot(1).func_77973_b())) != null) {
            for (int i = 0; i < this.pellets.length; ++i) {
                if (this.pellets[i] != null) continue;
                this.pellets[i] = pellet;
                this.inventory.getStackInSlot(1).func_190918_g(1);
                this.func_70296_d();
                return;
            }
        }
    }

    private void popPellet() {
        if (!this.inventory.getStackInSlot(2).func_190926_b()) {
            return;
        }
        if (this.pellets[0] == null) {
            return;
        }
        this.inventory.setStackInSlot(2, new ItemStack((Item)rtgPellets.inverse().get((Object)this.pellets[0])));
        for (int i = 0; i < this.pellets.length - 1; ++i) {
            this.pellets[i] = this.pellets[i + 1];
        }
        this.pellets[this.pellets.length - 1] = null;
        this.func_70296_d();
    }

    public double getSolidGauge() {
        return (double)this.burnTime / (double)this.lastBurnTime;
    }

    public double getPowerGauge() {
        return (double)this.power / 1000000.0;
    }

    public double getTempGauge() {
        return (double)this.temperature / 1000.0;
    }

    public double getTorqueGauge() {
        return (double)this.torque / 10000.0;
    }

    public float getAngleFromDial() {
        return (45.0f + this.limiter * 270.0f) % 360.0f;
    }

    public void setDialByAngle(float angle) {
        this.limiter = (angle - 45.0f) / 270.0f;
        this.ignoreNext = 5;
    }

    public void sendIGenPower() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        int[] rot = MultiblockHandlerXR.rotate(new int[]{1, 0, 4, 0, 8, 8}, dir.toEnumFacing());
        for (int ix = -rot[4]; ix <= rot[5]; ++ix) {
            for (int iz = -rot[2]; iz <= rot[3]; ++iz) {
                if (ix != -rot[4] && ix != rot[5] && iz != -rot[2] && iz != rot[3]) continue;
                this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 2 + ix, -1, dir.offsetZ * 2 + iz), ForgeDirection.DOWN);
            }
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            if (resource.getFluid() == this.tankTypes[0]) {
                return this.tanks[0].fill(resource, doFill);
            }
            if (fluidHeat.get(resource.getFluid()) > 0) {
                return this.tanks[1].fill(resource, doFill);
            }
            if (resource.getFluid() == this.tankTypes[2]) {
                return this.tanks[2].fill(resource, doFill);
            }
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 3) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
            this.tanks[2].readFromNBT(tags[2]);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        for (int i = 0; i < this.pellets.length; ++i) {
            short s = nbt.func_74765_d("pellet" + i);
            this.pellets[i] = s >= 0 && s < IGenRTG.values().length ? IGenRTG.values()[s] : null;
        }
        this.burnTime = nbt.func_74762_e("burn");
        this.lastBurnTime = nbt.func_74762_e("lastBurn");
        this.limiter = nbt.func_74760_g("limiter");
        super.func_145839_a(nbt);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        for (int i = 0; i < this.pellets.length; ++i) {
            if (this.pellets[i] != null) {
                nbt.func_74777_a("pellet" + i, (short)this.pellets[i].ordinal());
                continue;
            }
            nbt.func_74777_a("pellet" + i, (short)-1);
        }
        nbt.func_74768_a("burn", this.burnTime);
        nbt.func_74768_a("lastBurn", this.lastBurnTime);
        nbt.func_74776_a("limiter", this.limiter);
        return super.func_189515_b(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    static {
        fluidHeat.put(ModForgeFluids.SMEAR, 75);
        fluidHeat.put(ModForgeFluids.HEATINGOIL, 150);
        fluidHeat.put(ModForgeFluids.DIESEL, 225);
        fluidHeat.put(ModForgeFluids.KEROSENE, 300);
        fluidHeat.put(ModForgeFluids.RECLAIMED, 100);
        fluidHeat.put(ModForgeFluids.PETROIL, 125);
        fluidHeat.put(ModForgeFluids.BIOFUEL, 200);
        fluidHeat.put(ModForgeFluids.NITAN, 2500);
        rtgPellets = HashBiMap.create();
    }

    public static enum IGenRTG {
        RADIUM(ModItems.pellet_rtg_radium, 9, 3),
        URANIUM(ModItems.pellet_rtg_weak, 9, 5),
        PLUTONIUM(ModItems.pellet_rtg, 18, 10),
        STRONTIUM(ModItems.pellet_rtg_strontium, 18, 12),
        COBALT(ModItems.pellet_rtg_cobalt, 18, 16),
        ACTINIUM(ModItems.pellet_rtg_actinium, 0, 20),
        AMERICIUM(ModItems.pellet_rtg_americium, 0, 25);

        public final int offset;
        public final int heat;

        private IGenRTG(Item item, int offset2, int heat) {
            rtgPellets.put((Object)item, (Object)this);
            this.offset = offset2;
            this.heat = heat;
        }

        public static IGenRTG getPellet(Item item) {
            return (IGenRTG)((Object)rtgPellets.get((Object)item));
        }
    }
}

