/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.GasCentrifugeRecipes;
import com.hbm.inventory.UpgradeManager;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineGasCent
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
ITankPacketAcceptor,
IFluidHandler {
    public long power;
    public int progress;
    public int processTime = 200;
    public boolean isProgressing;
    public static final int maxPower = 100000;
    public static final int processingSpeed = 200;
    public static final int baseConsumption = 200;
    public boolean needsUpdate = false;
    public boolean hasCentUpgrade = false;
    public FluidTank tank;
    private final UpgradeManager upgradeManager = new UpgradeManager();
    private String customName;
    private long detectPower;
    private int detectProgress;
    private boolean detectIsProgressing;
    private FluidTank detectTank;

    public TileEntityMachineGasCent() {
        super(9);
        this.tank = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.gasCentrifuge";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("powerTime");
        this.progress = nbt.func_74765_d("CookTime");
        this.tank.readFromNBT(nbt);
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        super.func_145839_a(nbt);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74777_a("cookTime", (short)this.progress);
        this.tank.writeToNBT(nbt);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / this.processTime;
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 100000L;
    }

    private boolean canProcess() {
        if (this.power > 0L && this.tank.getFluid() != null) {
            if (this.tank.getFluidAmount() < GasCentrifugeRecipes.getFluidConsumedGasCent(this.hasCentUpgrade, this.tank.getFluid().getFluid())) {
                return false;
            }
            GasCentrifugeRecipes.GasCentRecipe recipe = GasCentrifugeRecipes.getGasCentRecipe(this.tank.getFluid().getFluid());
            if (recipe == null) {
                return false;
            }
            if (recipe.outputListA.isEmpty() || recipe.outputListA.size() > 4) {
                return false;
            }
            List<GasCentrifugeRecipes.GasCentOutput> list = this.hasCentUpgrade && recipe.outputListB != null ? recipe.outputListB : recipe.outputListA;
            for (int i = 0; i < list.size(); ++i) {
                int slot = i + 5;
                if (this.inventory.getStackInSlot(slot).func_190926_b() || this.inventory.getStackInSlot(slot).func_77973_b() == list.get((int)i).output.func_77973_b() && this.inventory.getStackInSlot(slot).func_77952_i() == list.get((int)i).output.func_77952_i() && this.inventory.getStackInSlot(slot).func_190916_E() + list.get((int)i).output.func_190916_E() <= this.inventory.getStackInSlot(slot).func_77976_d()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void process() {
        GasCentrifugeRecipes.GasCentRecipe recipe = GasCentrifugeRecipes.getGasCentRecipe(this.tank.getFluid().getFluid());
        boolean useB = this.hasCentUpgrade && recipe.outputListB != null;
        List<GasCentrifugeRecipes.GasCentOutput> out = useB ? recipe.outputListB : recipe.outputListA;
        int amount = useB ? recipe.amountB : recipe.amountA;
        this.progress = 0;
        this.tank.drain(amount, true);
        ArrayList<GasCentrifugeRecipes.GasCentOutput> random = new ArrayList<GasCentrifugeRecipes.GasCentOutput>();
        for (GasCentrifugeRecipes.GasCentOutput gasCentOutput : out) {
            for (int j = 0; j < gasCentOutput.weight; ++j) {
                random.add(gasCentOutput);
            }
        }
        Collections.shuffle(random);
        GasCentrifugeRecipes.GasCentOutput result = (GasCentrifugeRecipes.GasCentOutput)random.get(this.field_145850_b.field_73012_v.nextInt(random.size()));
        int slot = result.slot + 4;
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            this.inventory.setStackInSlot(slot, result.output.func_77946_l());
        } else {
            this.inventory.getStackInSlot(slot).func_190917_f(result.output.func_190916_E());
        }
    }

    public boolean hasCentUpgrade() {
        return this.inventory.getStackInSlot(1).func_77973_b() == ModItems.upgrade_gc_speed;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.upgradeManager.eval((IItemHandler)this.inventory, 2, 3);
            int speedLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 9);
            int powerLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            int consumption = 200 * (1 + speedLevel);
            consumption *= overLevel * 3 + 1;
            consumption /= 1 + powerLevel;
            this.updateConnectionsExcept(this.field_145850_b, this.field_174879_c, Library.POS_Y);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 100000L);
            if (this.inputValidForTank(-1, 3)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 3, 4);
            }
            this.hasCentUpgrade = this.hasCentUpgrade();
            if (this.power >= (long)consumption && this.canProcess()) {
                this.isProgressing = true;
                ++this.progress;
                this.power -= (long)consumption;
                if (this.power < 0L) {
                    this.power = 0L;
                }
                this.processTime = (int)((double)(200 * (2 + powerLevel)) / 2.0);
                this.processTime -= (int)((double)(this.processTime * speedLevel) / 10.0);
                this.processTime /= overLevel + 1;
                if (this.processTime <= 0) {
                    this.processTime = 1;
                }
                if (this.progress >= this.processTime) {
                    this.process();
                }
                PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedSoundPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            } else {
                this.isProgressing = false;
                this.progress = 0;
            }
            this.detectAndSendChanges();
        }
    }

    public boolean hasMuffler() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir)).func_177230_c() != ModBlocks.muffler) continue;
            return true;
        }
        return false;
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            this.detectPower = this.power;
            mark = true;
        }
        if (this.detectProgress != this.progress) {
            this.detectProgress = this.progress;
            mark = true;
        }
        if (this.detectIsProgressing != this.isProgressing) {
            this.detectIsProgressing = this.isProgressing;
            mark = true;
        }
        if (!FFUtils.areTanksEqual(this.tank, this.detectTank)) {
            this.detectTank = FFUtils.copyTank(this.tank);
            this.needsUpdate = true;
            mark = true;
        }
        NBTTagCompound data = new NBTTagCompound();
        this.tank.writeToNBT(data);
        data.func_74757_a("ip", this.isProgressing);
        data.func_74768_a("pr", this.progress);
        data.func_74768_a("t", this.processTime);
        data.func_74772_a("p", this.power);
        this.networkPack(data, 150);
        if (mark) {
            this.func_70296_d();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt);
        this.isProgressing = nbt.func_74767_n("ip");
        this.progress = nbt.func_74762_e("pr");
        this.processTime = nbt.func_74762_e("t");
        this.power = nbt.func_74763_f("p");
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (!this.inventory.getStackInSlot(slot).func_190926_b()) {
            return this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
        }
        return false;
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return GasCentrifugeRecipes.recipes.containsKey(stack.getFluid());
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot > 3;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 3, 4, 5, 6, 7, 8};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 4, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

