/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.CrystallizerRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineCrystallizer
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public static final int demand = 1000;
    public int acidRequired = 500;
    public short progress;
    public static final short duration = 600;
    public float angle;
    public float prevAngle;
    public FluidTank tank;

    public TileEntityMachineCrystallizer() {
        super(0);
        this.inventory = new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityMachineCrystallizer.this.func_70296_d();
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                super.setStackInSlot(slot, stack);
                if (stack != null && slot >= 5 && slot <= 6 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
                    TileEntityMachineCrystallizer.this.field_145850_b.func_184148_a(null, (double)TileEntityMachineCrystallizer.this.field_174879_c.func_177958_n() + 0.5, (double)TileEntityMachineCrystallizer.this.field_174879_c.func_177956_o() + 0.5, (double)TileEntityMachineCrystallizer.this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.upgradePlug, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        };
        this.tank = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.crystallizer";
    }

    private void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        if (dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 5, 0), ForgeDirection.EAST);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 5, 0), ForgeDirection.WEST);
        } else if (dir == ForgeDirection.EAST || dir == ForgeDirection.WEST) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 5, 2), ForgeDirection.SOUTH);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 5, -2), ForgeDirection.NORTH);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 1, this.power, 1000000L);
            if (this.inputValidForTank(3) && this.tank.getFluidAmount() < this.tank.getCapacity()) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 3, 4);
            }
            int i = 0;
            while ((float)i < this.getCycleCount()) {
                if (this.canProcess()) {
                    this.progress = (short)(this.progress + 1);
                    this.power -= (long)this.getPowerRequired();
                    if (this.progress > this.getDuration()) {
                        this.progress = 0;
                        this.tank.drain(this.getRequiredAcid(), true);
                        this.processItem();
                        this.func_70296_d();
                    }
                } else {
                    this.progress = 0;
                }
                ++i;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("progress", this.progress);
            data.func_74772_a("power", this.power);
            this.networkPack(data, 25);
        } else {
            this.prevAngle = this.angle;
            if (this.progress > 0) {
                this.angle += 5.0f * this.getCycleCount();
                if (this.angle >= 360.0f) {
                    this.angle -= 360.0f;
                    this.prevAngle -= 360.0f;
                }
            }
        }
    }

    protected boolean inputValidForTank(int slot) {
        FluidStack containerFluid;
        if (!this.inventory.getStackInSlot(slot).func_190926_b() && (containerFluid = FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot))) != null && CrystallizerRecipes.isAllowedFluid(containerFluid.getFluid())) {
            this.setTankType(containerFluid.getFluid());
            return true;
        }
        return false;
    }

    public void setTankType(Fluid f) {
        if (f != null && (this.tank.getFluid() == null || this.tank.getFluid() != null && this.tank.getFluid().getFluid() != f)) {
            this.tank.setFluid(new FluidStack(f, 0));
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.progress = data.func_74765_d("progress");
    }

    private void processItem() {
        ItemStack result = CrystallizerRecipes.getOutputItem(this.inventory.getStackInSlot(0));
        if (result == null) {
            return;
        }
        if (this.inventory.getStackInSlot(2).func_190926_b()) {
            this.inventory.setStackInSlot(2, result);
        } else if (this.inventory.getStackInSlot(2).func_190916_E() + result.func_190916_E() <= this.inventory.getStackInSlot(2).func_77976_d()) {
            this.inventory.getStackInSlot(2).func_190917_f(result.func_190916_E());
        }
        float freeChance = this.getFreeChance();
        if (freeChance == 0.0f || freeChance < this.field_145850_b.field_73012_v.nextFloat()) {
            this.inventory.getStackInSlot(0).func_190918_g(1);
        }
    }

    private boolean canProcess() {
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        if (this.power < (long)this.getPowerRequired()) {
            return false;
        }
        ItemStack result = CrystallizerRecipes.getOutputItem(this.inventory.getStackInSlot(0));
        if (result == null) {
            return false;
        }
        if (!(this.inventory.getStackInSlot(2).func_190926_b() || this.inventory.getStackInSlot(2).func_77973_b() == result.func_77973_b() && this.inventory.getStackInSlot(2).func_77952_i() == result.func_77952_i())) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190916_E() >= this.inventory.getStackInSlot(2).func_77976_d()) {
            return false;
        }
        FluidStack acidFluid = CrystallizerRecipes.getOutputFluid(this.inventory.getStackInSlot(0));
        if (acidFluid == null) {
            return false;
        }
        if (this.tank.getFluid() == null) {
            return false;
        }
        if (acidFluid.getFluid() != this.tank.getFluid().getFluid()) {
            return false;
        }
        this.acidRequired = acidFluid.amount;
        return this.tank.getFluidAmount() >= this.getRequiredAcid();
    }

    public int getRequiredAcid() {
        int extra = 0;
        for (int i = 5; i <= 6; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_1) {
                extra += this.acidRequired * 3;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_2) {
                extra += this.acidRequired * 4;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_effect_3) continue;
            extra += this.acidRequired * 5;
        }
        return this.acidRequired + Math.min(extra, 500);
    }

    public float getFreeChance() {
        float chance = 0.0f;
        for (int i = 5; i <= 6; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_1) {
                chance += 0.05f;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_effect_2) {
                chance += 0.1f;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_effect_3) continue;
            chance += 0.15f;
        }
        return Math.min(chance, 0.3f);
    }

    public int getDuration() {
        float durationMod = 1.0f;
        for (int i = 5; i <= 6; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_1) {
                durationMod *= 0.75f;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_2) {
                durationMod *= 0.5f;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_3) {
                durationMod *= 0.25f;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_screm) continue;
            durationMod *= 0.1f;
        }
        return (int)(600.0f * Math.max(durationMod, 0.1f));
    }

    public int getPowerRequired() {
        int consumption = 0;
        for (int i = 5; i <= 6; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_1) {
                consumption += 1000;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_2) {
                consumption += 2000;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_3) {
                consumption += 3000;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_screm) continue;
            consumption += 6000;
        }
        return 1000 + Math.min(consumption, 6000);
    }

    public float getCycleCount() {
        int cycles = 1;
        for (int i = 5; i <= 6; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_overdrive_1) {
                cycles += 2;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_overdrive_2) {
                cycles += 4;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_overdrive_3) continue;
            cycles += 6;
        }
        return Math.min(cycles, 13);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return slot == 0 && CrystallizerRecipes.getOutputItem(itemStack) != null;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 2 || slot == 4;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing face) {
        return new int[]{0, 2, 4};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 1000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.getDuration();
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && CrystallizerRecipes.isAllowedFluid(resource.getFluid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }
}

