/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineBoiler;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.HeatRecipes;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineBoilerElectric
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
IEnergyUser,
ITankPacketAcceptor {
    public long power;
    public int heat = 2000;
    public static final long maxPower = 50000L;
    public static final int maxHeat = 80000;
    public int age = 0;
    boolean needsUpdate = false;
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{4};
    private static final int[] slots_bottom = new int[]{6};
    private static final int[] slots_side = new int[]{4};
    private long detectPower;
    private int detectHeat;
    private FluidTank[] detectTanks = new FluidTank[]{null, null};

    public TileEntityMachineBoilerElectric() {
        super(7);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(16000);
        this.tanks[1] = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.machineElectricBoiler";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 4) {
            return stack != null && stack.func_77973_b() instanceof IBatteryItem;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.heat = nbt.func_74762_e("heat");
        this.power = nbt.func_74763_f("power");
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(nbt);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74772_a("power", this.power);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 80000;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 50000L;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Object[] outs;
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[1]);
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 4, this.power, 50000L);
            if (this.inputValidForTank(0, 2) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 2, 3)) {
                this.needsUpdate = true;
            }
            if (FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 5, 6)) {
                this.needsUpdate = true;
            }
            int usage = 150;
            if (this.tanks[0].getFluid() != null) {
                Fluid f = this.tanks[0].getFluid().getFluid();
                outs = HeatRecipes.getBoilerOutput(f);
                usage = HeatRecipes.getRequiredHeat(f) << 2;
            } else {
                outs = HeatRecipes.getBoilerOutput(null);
            }
            if (this.heat > 2000) {
                this.heat -= 30;
            }
            if (this.power > 0L) {
                this.heat += (int)Math.min((double)this.power / 50000.0 * 300.0, 150.0);
                this.power = Math.max(this.power - (long)usage, 0L);
            } else {
                this.heat -= 100;
            }
            if (this.power <= 0L && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.machine_boiler_electric_on) {
                this.power = 0L;
                MachineBoiler.updateBlockState(false, this.field_145850_b, this.field_174879_c);
            }
            if (this.heat > 80000) {
                this.heat = 80000;
            }
            if (this.power > 0L && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.machine_boiler_electric_off) {
                MachineBoiler.updateBlockState(true, this.field_145850_b, this.field_174879_c);
            }
            if (outs != null) {
                for (int i = 0; i < this.heat / (Integer)outs[3]; ++i) {
                    if (this.tanks[0].getFluidAmount() < (Integer)outs[2] * 5 || this.tanks[1].getFluidAmount() + (Integer)outs[1] * 5 > this.tanks[1].getCapacity()) continue;
                    this.tanks[0].drain((Integer)outs[2] * 5, true);
                    this.tanks[1].fill(new FluidStack((Fluid)outs[0], (Integer)outs[1] * 5), true);
                    if (i == 0) {
                        this.heat -= 35;
                        continue;
                    }
                    this.heat -= 50;
                }
            }
            if (this.heat < 2000) {
                this.heat = 2000;
            }
            this.detectAndSendChanges();
        }
    }

    public void fillFluidInit(FluidTank tank) {
        boolean update = this.needsUpdate;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177976_e(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177974_f(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177977_b(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177984_a(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177978_c(), 16000) || update;
        this.needsUpdate = update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177968_d(), 16000) || update;
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return HeatRecipes.hasBoilRecipe(stack.getFluid());
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tanks[1].getFluid())) {
            return null;
        }
        return this.tanks[1].drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            this.detectPower = this.power;
            mark = true;
        }
        if (this.detectHeat != this.heat) {
            this.detectHeat = this.heat;
            mark = true;
        }
        if (!FFUtils.areTanksEqual(this.tanks[0], this.detectTanks[0])) {
            this.needsUpdate = true;
            this.detectTanks[0] = FFUtils.copyTank(this.tanks[0]);
            mark = true;
        }
        if (!FFUtils.areTanksEqual(this.tanks[1], this.detectTanks[1])) {
            this.needsUpdate = true;
            this.detectTanks[1] = FFUtils.copyTank(this.tanks[1]);
            mark = true;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.heat, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

