/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.container.ContainerAutocrafter;
import com.hbm.inventory.gui.GUIAutocrafter;
import com.hbm.lib.Library;
import com.hbm.modules.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineAutocrafter
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IEnergyUser {
    public ModulePatternMatcher matcher;
    protected InventoryCraftingAuto craftingInventory = new InventoryCraftingAuto(3, 3);
    public List<IRecipe> recipes = new ArrayList<IRecipe>();
    public int recipeIndex;
    public int recipeCount;
    public static int consumption = 1000;
    public static long maxPower = consumption * 1000;
    public long power;
    public int[] access = new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18, 19};

    public TileEntityMachineAutocrafter() {
        super(21);
        this.matcher = new ModulePatternMatcher(9);
    }

    public void nextTemplate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.recipeIndex;
        if (this.recipeIndex >= this.recipes.size()) {
            this.recipeIndex = 0;
        }
        if (!this.recipes.isEmpty()) {
            this.inventory.setStackInSlot(9, this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()));
        } else {
            this.inventory.setStackInSlot(9, ItemStack.field_190927_a);
        }
    }

    @Override
    public String getName() {
        return "container.autocrafter";
    }

    public void nextMode(int i) {
        this.matcher.nextMode(this.field_145850_b, this.inventory.getStackInSlot(i), i);
    }

    public void initPattern(ItemStack stack, int index) {
        this.matcher.initPatternSmart(this.field_145850_b, stack, index);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            IRecipe recipe;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 20, this.power, maxPower);
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            if (!this.recipes.isEmpty() && this.power >= (long)consumption && (recipe = this.recipes.get(this.recipeIndex)).func_77569_a(this.getRecipeGrid(), this.field_145850_b) && !(stack = recipe.func_77572_b(this.getRecipeGrid())).func_190926_b()) {
                boolean didCraft = false;
                if (this.inventory.getStackInSlot(19) == ItemStack.field_190927_a) {
                    this.inventory.setStackInSlot(19, stack.func_77946_l());
                    didCraft = true;
                } else if (this.inventory.getStackInSlot(19).func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.inventory.getStackInSlot(19)) && this.inventory.getStackInSlot(19).func_190916_E() + stack.func_190916_E() <= this.inventory.getStackInSlot(19).func_77976_d()) {
                    this.inventory.getStackInSlot(19).func_190920_e(this.inventory.getStackInSlot(19).func_190916_E() + stack.func_190916_E());
                    didCraft = true;
                }
                if (didCraft) {
                    for (int i = 10; i < 19; ++i) {
                        ItemStack container;
                        ItemStack ingredient = this.inventory.getStackInSlot(i);
                        if (ingredient == ItemStack.field_190927_a) continue;
                        this.inventory.getStackInSlot(i).func_190918_g(1);
                        if (this.inventory.getStackInSlot(i) != ItemStack.field_190927_a || !ingredient.func_77973_b().hasContainerItem(ingredient) || !(container = ingredient.func_77973_b().getContainerItem(ingredient)).func_190926_b() && container.func_77984_f() && container.func_77952_i() > container.func_77958_k()) continue;
                        this.inventory.setStackInSlot(i, container);
                    }
                    this.power -= (long)consumption;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            this.matcher.writeToNBT(data);
            data.func_74768_a("rC", this.recipeCount);
            data.func_74768_a("rI", this.recipeIndex);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.matcher.modes = new String[this.matcher.modes.length];
        this.matcher.readFromNBT(nbt);
        this.recipeCount = nbt.func_74762_e("rC");
        this.recipeIndex = nbt.func_74762_e("rI");
    }

    public void updateTemplateGrid() {
        this.recipes = this.getMatchingRecipes(this.getTemplateGrid());
        this.recipeCount = this.recipes.size();
        this.recipeIndex = 0;
        if (!this.recipes.isEmpty()) {
            this.inventory.setStackInSlot(9, this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()));
        } else {
            this.inventory.setStackInSlot(9, ItemStack.field_190927_a);
        }
    }

    public List<IRecipe> getMatchingRecipes(InventoryCrafting grid) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValues()) {
            if (!recipe.func_77569_a(grid, this.field_145850_b)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return this.access;
    }

    @Override
    public boolean canExtractItem(int i, ItemStack stack, int j) {
        if (i == 19) {
            return true;
        }
        if (i > 9 && i < 19) {
            ItemStack filter = this.inventory.getStackInSlot(i - 10);
            String mode = this.matcher.modes[i - 10];
            if (filter.func_190926_b() || mode == null || mode.isEmpty()) {
                return true;
            }
            return !this.matcher.isValidForFilter(filter, i - 10, stack);
        }
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (stack.func_190916_E() > 1 && stack.func_77973_b().hasContainerItem(stack)) {
            return false;
        }
        if (slot < 10 || slot > 18) {
            return false;
        }
        if (this.inventory.getStackInSlot(slot - 10).func_190926_b()) {
            return false;
        }
        ArrayList<Integer> validSlots = new ArrayList<Integer>();
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.inventory.getStackInSlot(i);
            if (!this.matcher.isValidForFilter(filter, i, stack)) continue;
            validSlots.add(i + 10);
            if (i + 10 != slot || !this.inventory.getStackInSlot(slot).func_190926_b()) continue;
            return true;
        }
        if (!validSlots.contains(slot)) {
            return false;
        }
        int size = this.inventory.getStackInSlot(slot).func_190916_E();
        for (Integer i : validSlots) {
            ItemStack valid = this.inventory.getStackInSlot(i.intValue());
            if (valid.func_190926_b()) {
                return false;
            }
            if (!valid.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)valid, (ItemStack)stack) || valid.func_190916_E() >= size) continue;
            return false;
        }
        return !stack.func_77973_b().hasContainerItem(stack);
    }

    public InventoryCrafting getTemplateGrid() {
        this.craftingInventory.loadInventory(this.inventory, 0);
        return this.craftingInventory;
    }

    public InventoryCrafting getRecipeGrid() {
        this.craftingInventory.loadInventory(this.inventory, 10);
        return this.craftingInventory;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.matcher.modes = new String[this.matcher.modes.length];
        this.matcher.readFromNBT(nbt);
        this.recipes = this.getMatchingRecipes(this.getTemplateGrid());
        this.recipeCount = this.recipes.size();
        this.recipeIndex = nbt.func_74762_e("rec");
        if (!this.recipes.isEmpty()) {
            this.inventory.setStackInSlot(9, this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()));
        } else {
            this.inventory.setStackInSlot(9, ItemStack.field_190927_a);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        this.matcher.writeToNBT(nbt);
        nbt.func_74768_a("rec", this.recipeIndex);
        return super.func_189515_b(nbt);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAutocrafter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIAutocrafter(player.field_71071_by, this);
    }

    public static class InventoryCraftingAuto
    extends InventoryCrafting {
        public InventoryCraftingAuto(int width, int height) {
            super((Container)new ContainerBlank(), width, height);
        }

        public void loadInventory(ItemStackHandler inv, int start) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, inv.getStackInSlot(start + i));
            }
        }

        public void func_174888_l() {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, null);
            }
        }

        public static class ContainerBlank
        extends Container {
            public void func_75130_a(IInventory inventory) {
            }

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }
    }
}

