/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.MultiblockHandler;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemAssemblyTemplate;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineAssembler
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power;
    public static final long maxPower = 2000000L;
    public int progress;
    public boolean needsProcess = true;
    public int maxProgress = 100;
    public boolean isProgressing;
    int age = 0;
    int consumption = 100;
    int speed = 100;
    @SideOnly(value=Side.CLIENT)
    public int recipe;
    private AudioWrapper audio;

    public TileEntityMachineAssembler() {
        super(18);
        this.inventory = new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                TileEntityMachineAssembler.this.func_70296_d();
                TileEntityMachineAssembler.this.OnContentsChanged(slot);
                super.onContentsChanged(slot);
            }
        };
    }

    public void OnContentsChanged(int slot) {
        this.needsProcess = true;
    }

    @Override
    public String getName() {
        return "container.assembler";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.isProgressing = nbt.func_74767_n("progressing");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("progressing", this.isProgressing);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("progress", this.progress);
        return nbt;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 2000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / Math.max(10, this.maxProgress);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IItemHandler cap;
            this.updateConnections();
            this.consumption = 100;
            this.speed = 100;
            double c = 100.0;
            double s = 100.0;
            for (int i = 1; i < 4; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() == ModItems.upgrade_speed_1) {
                    s *= 0.75;
                    c *= 3.0;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_2) {
                    s *= 0.65;
                    c *= 6.0;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_3) {
                    s *= 0.5;
                    c *= 9.0;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_1) {
                    c *= 0.8;
                    s *= 1.25;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_2) {
                    c *= 0.4;
                    s *= 1.5;
                }
                if (stack.func_77973_b() != ModItems.upgrade_power_3) continue;
                c *= 0.2;
                s *= 2.0;
            }
            this.speed = (int)s;
            this.consumption = (int)c;
            if (this.speed < 2) {
                this.speed = 2;
            }
            if (this.consumption < 2) {
                this.consumption = 2;
            }
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 2000000L);
            if (this.needsProcess && AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)) != ItemStack.field_190927_a && AssemblerRecipes.getRecipeFromTempate(this.inventory.getStackInSlot(4)) != null) {
                this.maxProgress = ItemAssemblyTemplate.getProcessTime(this.inventory.getStackInSlot(4)) * this.speed / 100;
                if (this.removeItems(AssemblerRecipes.getRecipeFromTempate(this.inventory.getStackInSlot(4)), (IItemHandlerModifiable)this.cloneItemStackProper((IItemHandlerModifiable)this.inventory))) {
                    if (this.power >= (long)this.consumption && (this.inventory.getStackInSlot(5).func_190926_b() || !this.inventory.getStackInSlot(5).func_190926_b() && this.inventory.getStackInSlot(5).func_77973_b() == AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l().func_77973_b() && this.inventory.getStackInSlot(5).func_190916_E() + AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l().func_190916_E() <= this.inventory.getStackInSlot(5).func_77976_d())) {
                        ++this.progress;
                        this.isProgressing = true;
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            if (this.inventory.getStackInSlot(5).func_190926_b()) {
                                this.inventory.setStackInSlot(5, AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l());
                            } else {
                                this.inventory.getStackInSlot(5).func_190917_f(AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l().func_190916_E());
                            }
                            this.removeItems(AssemblerRecipes.getRecipeFromTempate(this.inventory.getStackInSlot(4)), (IItemHandlerModifiable)this.inventory);
                            if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.meteorite_sword_alloyed) {
                                this.inventory.setStackInSlot(0, new ItemStack(ModItems.meteorite_sword_machined));
                            }
                        }
                        this.power -= (long)this.consumption;
                    }
                } else {
                    this.progress = 0;
                    this.needsProcess = false;
                }
            } else {
                this.progress = 0;
            }
            int meta = this.func_145832_p();
            TileEntity te = null;
            TileEntity te2 = null;
            if (meta == 2) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, 0, 0));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, -1));
            }
            if (meta == 3) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, 0, 0));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, 1));
            }
            if (meta == 4) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 2));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, -3));
            }
            if (meta == 5) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -2));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 3));
            }
            if (!this.isProgressing) {
                this.tryExchangeTemplates(te, te2);
            }
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e()) && (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) != null) {
                this.tryFillContainerCap(cap, 5);
            }
            if (te2 != null && te2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) {
                cap = (IItemHandler)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                if (te2 instanceof TileEntityMachineBase) {
                    TileEntityMachineBase machine = (TileEntityMachineBase)te2;
                    int[] slots = machine.getAccessibleSlotsFromSide(MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                    this.tryFillAssemblerCap(cap, slots, machine);
                } else if (cap != null) {
                    int[] slots = new int[cap.getSlots()];
                    for (int i = 0; i < slots.length; ++i) {
                        slots[i] = i;
                    }
                    this.tryFillAssemblerCap(cap, slots, null);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("maxProgress", this.maxProgress);
            data.func_74757_a("isProgressing", this.isProgressing);
            data.func_74768_a("recipe", !this.inventory.getStackInSlot(4).func_190926_b() ? ItemAssemblyTemplate.getRecipeIndex(this.inventory.getStackInSlot(4)) : -1);
            this.networkPack(data, 150);
        } else {
            float volume = this.getVolume(2);
            if (this.isProgressing && volume > 0.0f) {
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound(HBMSoundHandler.assemblerOperate, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), volume, 1.0f);
                    this.audio.startSound();
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    private void updateConnections() {
        int meta = this.func_145832_p();
        if (meta == 5) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 0), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 1), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, 0), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, 1), Library.POS_X);
        } else if (meta == 3) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -2), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -2), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 3), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 3), Library.POS_Z);
        } else if (meta == 4) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 0), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -1), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, 0), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, -1), Library.NEG_X);
        } else if (meta == 2) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 2), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 2), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -3), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -3), Library.NEG_Z);
        }
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.maxProgress = nbt.func_74762_e("maxProgress");
        this.isProgressing = nbt.func_74767_n("isProgressing");
        this.recipe = nbt.func_74762_e("recipe");
    }

    public boolean tryExchangeTemplates(TileEntity te1, TileEntity te2) {
        boolean te1Valid = this.validateTe(te1);
        boolean te2Valid = this.validateTe(te2);
        if (te1Valid && te2Valid) {
            int i;
            IItemHandlerModifiable iTe1 = (IItemHandlerModifiable)te1.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            IItemHandlerModifiable iTe2 = (IItemHandlerModifiable)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            boolean openSlot = false;
            boolean existingTemplate = false;
            boolean filledContainer = false;
            for (i = 0; i < iTe1.getSlots(); ++i) {
                if (!iTe1.getStackInSlot(i).func_190926_b()) continue;
                openSlot = true;
                break;
            }
            if (!this.inventory.getStackInSlot(4).func_190926_b()) {
                existingTemplate = true;
            }
            for (i = 0; i < iTe2.getSlots(); ++i) {
                if (!(iTe2.getStackInSlot(i).func_77973_b() instanceof ItemAssemblyTemplate)) continue;
                if (openSlot && existingTemplate) {
                    filledContainer = this.tryFillContainerCap((IItemHandler)iTe1, 4);
                }
                if (!filledContainer && existingTemplate) continue;
                ItemStack copy = iTe2.getStackInSlot(i).func_77946_l();
                iTe2.setStackInSlot(i, ItemStack.field_190927_a);
                this.inventory.setStackInSlot(4, copy);
                return false;
            }
        }
        return false;
    }

    private boolean validateTe(TileEntity te) {
        return te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) instanceof IItemHandlerModifiable;
    }

    public ItemStackHandler cloneItemStackProper(IItemHandlerModifiable array) {
        ItemStackHandler stack = new ItemStackHandler(array.getSlots());
        for (int i = 0; i < array.getSlots(); ++i) {
            if (!array.getStackInSlot(i).func_190926_b()) {
                stack.setStackInSlot(i, array.getStackInSlot(i).func_77946_l());
                continue;
            }
            stack.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return stack;
    }

    public boolean tryFillContainer(IInventory inv, int slot) {
        int i;
        int size = inv.func_70302_i_();
        for (i = 0; i < size; ++i) {
            inv.func_70301_a(i);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                return false;
            }
            ItemStack sta1 = inv.func_70301_a(i).func_77946_l();
            ItemStack sta2 = this.inventory.getStackInSlot(slot).func_77946_l();
            if (sta1.func_190926_b() || sta2.func_190926_b()) continue;
            sta1.func_190920_e(1);
            sta2.func_190920_e(1);
            if (!this.isItemAcceptable(sta1, sta2) || this.inventory.getStackInSlot(i).func_190916_E() >= this.inventory.getStackInSlot(i).func_77976_d()) continue;
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            ItemStack sta3 = this.inventory.getStackInSlot(i).func_77946_l();
            sta3.func_190917_f(1);
            inv.func_70299_a(i, sta3);
            return true;
        }
        for (i = 0; i < size; ++i) {
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                return false;
            }
            ItemStack sta2 = this.inventory.getStackInSlot(slot).func_77946_l();
            if (!inv.func_70301_a(i).func_190926_b() || sta2.func_190926_b()) continue;
            sta2.func_190920_e(1);
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            inv.func_70299_a(i, sta2);
            return true;
        }
        return false;
    }

    public boolean tryFillContainerCap(IItemHandler chest, int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack simuOutput;
            ItemStack outputStack = this.inventory.getStackInSlot(slot).func_77946_l();
            if (outputStack.func_190926_b()) {
                return false;
            }
            outputStack.func_190920_e(1);
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d()) || !(simuOutput = chest.insertItem(i, outputStack, true)).func_190926_b()) continue;
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            chest.insertItem(i, outputStack, false);
            return true;
        }
        return false;
    }

    private int getValidSlot(RecipesCommon.AStack nextIngredient) {
        int firstFreeSlot = -1;
        float maxStackSize = nextIngredient.getStack().func_77976_d();
        int stackCount = (int)Math.ceil((float)nextIngredient.count() / maxStackSize);
        int stacksFound = 0;
        nextIngredient = nextIngredient.singulize();
        for (int k = 6; k < 18; ++k) {
            if (stacksFound < stackCount) {
                ItemStack assStack = this.inventory.getStackInSlot(k).func_77946_l();
                if (assStack.func_190926_b()) {
                    if (firstFreeSlot >= 6) continue;
                    firstFreeSlot = k;
                    continue;
                }
                assStack.func_190920_e(1);
                if (!nextIngredient.isApplicable(assStack)) continue;
                if (this.inventory.getStackInSlot(k).func_190916_E() < assStack.func_77976_d()) {
                    return k;
                }
                ++stacksFound;
                continue;
            }
            return -1;
        }
        if (firstFreeSlot < 6) {
            return -2;
        }
        return firstFreeSlot;
    }

    public boolean tryFillAssemblerCap(IItemHandler container, int[] allowedSlots, TileEntityMachineBase te) {
        if (allowedSlots.length < 1) {
            return false;
        }
        if (AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)) == null || AssemblerRecipes.getRecipeFromTempate(this.inventory.getStackInSlot(4)).isEmpty()) {
            return false;
        }
        ArrayList<RecipesCommon.AStack> recipeIngredients = new ArrayList<RecipesCommon.AStack>(AssemblerRecipes.getRecipeFromTempate(this.inventory.getStackInSlot(4)));
        block0: for (RecipesCommon.AStack recipeIngredient : recipeIngredients) {
            RecipesCommon.AStack nextIngredient = recipeIngredient.copy();
            int ingredientSlot = this.getValidSlot(nextIngredient);
            if (ingredientSlot < 6) continue;
            ItemStack assemblerItem = this.inventory.getStackInSlot(ingredientSlot);
            int possibleAmount = assemblerItem.func_190926_b() ? nextIngredient.getStack().func_77976_d() : assemblerItem.func_77976_d() - assemblerItem.func_190916_E();
            if (possibleAmount <= 0) {
                System.out.println("This should never happen method getValidSlot broke");
                continue;
            }
            for (int slot : allowedSlots) {
                ItemStack extractItem;
                ItemStack stack = container.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                ItemStack compareStack = stack.func_77946_l();
                compareStack.func_190920_e(1);
                if (!nextIngredient.isApplicable(compareStack)) continue;
                int foundCount = Math.min(stack.func_190916_E(), possibleAmount);
                if (te != null && !te.canExtractItem(slot, stack, foundCount) || (extractItem = container.extractItem(slot, foundCount, false)).func_190926_b()) continue;
                if (this.inventory.getStackInSlot(ingredientSlot).func_190926_b()) {
                    this.inventory.setStackInSlot(ingredientSlot, extractItem.func_77946_l());
                } else {
                    this.inventory.getStackInSlot(ingredientSlot).func_190917_f(extractItem.func_190916_E());
                }
                this.needsProcess = true;
                if ((possibleAmount -= extractItem.func_190916_E()) <= 0) continue block0;
            }
        }
        return true;
    }

    public boolean removeItems(List<RecipesCommon.AStack> stack, IItemHandlerModifiable array) {
        if (stack == null) {
            return false;
        }
        for (RecipesCommon.AStack aStack : stack) {
            for (int j = 0; j < aStack.count(); ++j) {
                RecipesCommon.AStack sta = aStack.copy();
                sta.singulize();
                if (this.canRemoveItemFromArray(sta, array)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRemoveItemFromArray(RecipesCommon.AStack stack, IItemHandlerModifiable array) {
        RecipesCommon.AStack st = stack.copy();
        if (st == null) {
            return true;
        }
        for (int i = 6; i < 18; ++i) {
            if (array.getStackInSlot(i).func_190926_b()) continue;
            ItemStack sta = array.getStackInSlot(i).func_77946_l();
            sta.func_190920_e(1);
            if (!st.isApplicable(sta) || array.getStackInSlot(i).func_190916_E() <= 0) continue;
            array.getStackInSlot(i).func_190918_g(1);
            if (array.getStackInSlot(i).func_190926_b()) {
                array.setStackInSlot(i, ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public boolean isItemAcceptable(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null && !stack1.func_190926_b() && !stack2.func_190926_b()) {
            if (Library.areItemStacksCompatible(stack1, stack2)) {
                return true;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length > 0 && ids2.length > 0) {
                for (int j : ids1) {
                    for (int k : ids2) {
                        if (j != k) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 2000000L;
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b(2.0, 1.0, 2.0).func_186662_g(10.0);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int countMufflers() {
        int count = 0;
        for (int x = this.field_174879_c.func_177958_n() - 1; x <= this.field_174879_c.func_177958_n() + 1; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - 1; z <= this.field_174879_c.func_177952_p() + 1; ++z) {
                if (this.field_145850_b.func_180495_p(new BlockPos(x, this.field_174879_c.func_177956_o() - 1, z)).func_177230_c() != ModBlocks.muffler) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 4) {
            return stack != null && stack.func_77973_b() instanceof ItemAssemblyTemplate;
        }
        return true;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 5;
    }
}

