/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.blocks.ModBlocks;
import com.hbm.lib.ForgeDirection;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class TileEntityMachineAmgen
extends TileEntityLoadedBase
implements ITickable,
IEnergyGenerator {
    public long power;
    public long maxPower = 500L;
    public long production = -1L;
    int counter = 0;

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        return super.func_189515_b(compound);
    }

    public int getHeat(World world, IBlockState state, BlockPos pos) {
        if (state == null) {
            return 0;
        }
        Block b = state.func_177230_c();
        if (b == ModBlocks.geysir_water) {
            return 75;
        }
        if (b == ModBlocks.geysir_chlorine) {
            return 100;
        }
        if (b == ModBlocks.geysir_vapor) {
            return 50;
        }
        if (b == ModBlocks.geysir_nether) {
            return 500;
        }
        int temp = BlockFluidBase.getTemperature((IBlockAccess)world, (BlockPos)pos);
        if (temp == Integer.MAX_VALUE) {
            return 0;
        }
        if ((temp -= 373) < 0) {
            return 0;
        }
        return temp >> 3;
    }

    public void updateHeat() {
        int prod = 0;
        BlockPos.MutableBlockPos posN = new BlockPos.MutableBlockPos();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            posN.func_181079_c(this.field_174879_c.func_177958_n() + dir.offsetX, this.field_174879_c.func_177956_o() + dir.offsetY, this.field_174879_c.func_177952_p() + dir.offsetZ);
            if (!this.field_145850_b.func_175667_e((BlockPos)posN)) continue;
            prod += this.getHeat(this.field_145850_b, this.field_145850_b.func_180495_p((BlockPos)posN), (BlockPos)posN);
        }
        this.production = prod;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            long prevPower = this.power;
            if (this.func_145838_q() == ModBlocks.machine_amgen) {
                this.power += (long)RadiationSavedData.getData(this.field_145850_b).getRadNumFromCoord(this.field_174879_c);
                RadiationSavedData.decrementRad(this.field_145850_b, this.field_174879_c, 5.0f);
            } else {
                if (this.production == -1L || this.counter % 80 == 0) {
                    this.updateHeat();
                }
                this.power += this.production;
                ++this.counter;
            }
            if (this.power > this.maxPower) {
                this.power = this.maxPower;
            }
            if (this.power > 0L) {
                this.sendPower(this.field_145850_b, this.field_174879_c);
            }
            if (prevPower != this.power) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }
}

