/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineITER;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.BreederRecipes;
import com.hbm.inventory.FusionRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemFusionShield;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.AdvancementManager;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.FluidTypePacketTest;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityITERStruct;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityITER
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000000L;
    public static final int powerReq = 500000;
    public int age = 0;
    public FluidTank[] tanks = new FluidTank[2];
    public Fluid[] types = new Fluid[2];
    public FluidTank plasma;
    public Fluid plasmaType;
    public int progress;
    public static final int duration = 100;
    @SideOnly(value=Side.CLIENT)
    public int blanket;
    public float rotor;
    public float lastRotor;
    public boolean isOn;
    AxisAlignedBB bb = null;

    public TileEntityITER() {
        super(5);
        this.tanks[0] = new FluidTank(12800000);
        this.types[0] = FluidRegistry.WATER;
        this.tanks[1] = new FluidTank(1280000);
        this.types[1] = ModForgeFluids.ULTRAHOTSTEAM;
        this.plasma = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.machineITER";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[1]);
            }
            this.updateConnections();
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 1000000000L);
            if (!this.isOn) {
                this.plasma.setFluid(null);
            }
            if (this.plasma.getFluidAmount() > 0 && (this.plasmaType.getTemperature() >= this.getShield() || this.isOn && this.power < 500000L)) {
                this.disassemble();
                Vec3 vec = Vec3.createVectorHelper(5.5, 0.0, 0.0);
                vec.rotateAroundY(this.field_145850_b.field_73012_v.nextFloat() * (float)Math.PI * 2.0f);
                this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n() + 0.5 + vec.xCoord, (double)this.field_174879_c.func_177956_o() + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 1.5, (double)this.field_174879_c.func_177952_p() + 0.5 + vec.zCoord, 2.5f, true, true);
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, 2000.0f, 10000.0f);
            }
            if (this.isOn && this.power >= 500000L) {
                int chance;
                this.power -= 500000L;
                if (this.plasma.getFluidAmount() > 0 && (chance = FusionRecipes.getByproductChance(this.plasmaType)) > 0 && this.field_145850_b.field_73012_v.nextInt(chance) == 0) {
                    this.produceByproduct();
                }
                if (this.plasma.getFluidAmount() > 0 && this.getShield() != 0) {
                    ItemFusionShield.setShieldDamage(this.inventory.getStackInSlot(3), ItemFusionShield.getShieldDamage(this.inventory.getStackInSlot(3)) + 1L);
                    if (ItemFusionShield.getShieldDamage(this.inventory.getStackInSlot(3)) > ((ItemFusionShield)this.inventory.getStackInSlot((int)3).func_77973_b()).field_77699_b) {
                        this.inventory.setStackInSlot(3, ItemStack.field_190927_a);
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.shutdown, SoundCategory.BLOCKS, 5.0f, 1.0f);
                        this.isOn = false;
                        this.func_70296_d();
                    }
                }
                int prod = FusionRecipes.getSteamProduction(this.plasmaType);
                for (int i = 0; i < 20; ++i) {
                    if (this.plasma.getFluidAmount() <= 0) continue;
                    if (this.tanks[0].getFluidAmount() >= prod * 10) {
                        this.tanks[0].drain(prod * 10, true);
                        this.tanks[1].fill(new FluidStack(this.types[1], prod), true);
                    }
                    this.plasma.drain(1, true);
                }
            }
            this.doBreederStuff();
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1], this.plasma), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 120.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTypePacketTest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new Fluid[]{this.plasmaType}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isOn", this.isOn);
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            if (this.inventory.getStackInSlot(3).func_77973_b() == ModItems.fusion_shield_tungsten) {
                data.func_74768_a("blanket", 1);
            } else if (this.inventory.getStackInSlot(3).func_77973_b() == ModItems.fusion_shield_desh) {
                data.func_74768_a("blanket", 2);
            } else if (this.inventory.getStackInSlot(3).func_77973_b() == ModItems.fusion_shield_chlorophyte) {
                data.func_74768_a("blanket", 3);
            } else if (this.inventory.getStackInSlot(3).func_77973_b() == ModItems.fusion_shield_vaporwave) {
                data.func_74768_a("blanket", 4);
            } else {
                data.func_74768_a("blanket", 0);
            }
            this.networkPack(data, 250);
        } else {
            this.lastRotor = this.rotor;
            if (this.isOn && this.power >= 500000L) {
                this.rotor += 15.0f;
                if (this.rotor >= 360.0f) {
                    this.rotor -= 360.0f;
                    this.lastRotor -= 360.0f;
                }
            }
        }
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 3, 0), ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -3, 0), ForgeDirection.DOWN);
    }

    private void doBreederStuff() {
        if (this.plasma.getFluidAmount() == 0) {
            this.progress = 0;
            return;
        }
        BreederRecipes.BreederRecipe out = BreederRecipes.getOutput(this.inventory.getStackInSlot(1));
        if (this.inventory.getStackInSlot(1).func_77973_b() == ModItems.meteorite_sword_irradiated) {
            out = new BreederRecipes.BreederRecipe(ModItems.meteorite_sword_fused, 1);
        }
        if (this.inventory.getStackInSlot(1).func_77973_b() == ModItems.meteorite_sword_fused) {
            out = new BreederRecipes.BreederRecipe(ModItems.meteorite_sword_baleful, 4);
        }
        if (out == null) {
            this.progress = 0;
            return;
        }
        if (!this.inventory.getStackInSlot(2).func_190926_b() && this.inventory.getStackInSlot(2).func_190916_E() >= this.inventory.getStackInSlot(2).func_77976_d()) {
            this.progress = 0;
            return;
        }
        int level = FusionRecipes.getBreedingLevel(this.plasmaType);
        if (out.heat > level) {
            this.progress = 0;
            return;
        }
        ++this.progress;
        if (this.progress > 100) {
            if (!this.inventory.getStackInSlot(2).func_190926_b()) {
                this.inventory.getStackInSlot(2).func_190917_f(1);
            } else {
                this.inventory.setStackInSlot(2, out.output.func_77946_l());
            }
            this.inventory.getStackInSlot(1).func_190918_g(1);
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
            }
            this.func_70296_d();
        }
    }

    private void produceByproduct() {
        ItemStack by = FusionRecipes.getByproduct(this.plasmaType);
        if (by == null) {
            return;
        }
        if (this.inventory.getStackInSlot(4).func_190926_b()) {
            this.inventory.setStackInSlot(4, by);
            return;
        }
        if (this.inventory.getStackInSlot(4).func_77973_b() == by.func_77973_b() && this.inventory.getStackInSlot(4).func_77952_i() == by.func_77952_i() && this.inventory.getStackInSlot(4).func_190916_E() < this.inventory.getStackInSlot(4).func_77976_d()) {
            this.inventory.getStackInSlot(4).func_190917_f(1);
        }
    }

    public int getShield() {
        if (this.inventory.getStackInSlot(3).func_190926_b() || !(this.inventory.getStackInSlot(3).func_77973_b() instanceof ItemFusionShield)) {
            return 0;
        }
        return ((ItemFusionShield)this.inventory.getStackInSlot((int)3).func_77973_b()).maxTemp + 273;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.isOn = data.func_74767_n("isOn");
        this.power = data.func_74763_f("power");
        this.blanket = data.func_74762_e("blanket");
        this.progress = data.func_74762_e("progress");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            this.isOn = !this.isOn;
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000000L;
    }

    public long getProgressScaled(long i) {
        return (long)this.progress * i / 100L;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.tanks[0].readFromNBT(compound.func_74775_l("water"));
        this.tanks[1].readFromNBT(compound.func_74775_l("steam"));
        this.plasma.readFromNBT(compound.func_74775_l("plasma"));
        this.plasmaType = FluidRegistry.getFluid((String)compound.func_74779_i("plasma_type"));
        this.power = compound.func_74763_f("power");
        this.isOn = compound.func_74767_n("isOn");
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("water", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("steam", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("plasma", (NBTBase)this.plasma.writeToNBT(new NBTTagCompound()));
        if (this.plasmaType != null) {
            compound.func_74778_a("plasma_type", this.plasmaType.getName());
        }
        compound.func_74772_a("power", this.power);
        compound.func_74757_a("isOn", this.isOn);
        return super.func_189515_b(compound);
    }

    public void fillFluidInit(FluidTank type) {
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 3, this.field_174879_c.func_177952_p(), type);
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 3, this.field_174879_c.func_177952_p(), type);
    }

    public void fillFluid(int x, int y, int z, FluidTank type) {
        FFUtils.fillFluid(this, type, this.field_145850_b, new BlockPos(x, y, z), 1280000);
    }

    public void disassemble() {
        MachineITER.drop = false;
        int[][][] layout = TileEntityITERStruct.layout;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < layout[0].length; ++x) {
                block8: for (int z = 0; z < layout[0][0].length; ++z) {
                    int ly = y > 2 ? 4 - y : y;
                    int width = 7;
                    if (x == width && y == 0 && z == width) continue;
                    int b = layout[ly][x][z];
                    switch (b) {
                        case 1: {
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n() - width + x, this.field_174879_c.func_177956_o() + y - 2, this.field_174879_c.func_177952_p() - width + z), ModBlocks.fusion_conductor.func_176223_P());
                            continue block8;
                        }
                        case 2: {
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n() - width + x, this.field_174879_c.func_177956_o() + y - 2, this.field_174879_c.func_177952_p() - width + z), ModBlocks.fusion_center.func_176223_P());
                            continue block8;
                        }
                        case 3: {
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n() - width + x, this.field_174879_c.func_177956_o() + y - 2, this.field_174879_c.func_177952_p() - width + z), ModBlocks.fusion_motor.func_176223_P());
                            continue block8;
                        }
                        case 4: {
                            this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n() - width + x, this.field_174879_c.func_177956_o() + y - 2, this.field_174879_c.func_177952_p() - width + z), ModBlocks.reinforced_glass.func_176223_P());
                        }
                    }
                }
            }
        }
        this.field_145850_b.func_175656_a(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p()), ModBlocks.struct_iter_core.func_176223_P());
        MachineITER.drop = true;
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_72314_b(50.0, 10.0, 50.0));
        for (EntityPlayer player : players) {
            AdvancementManager.grantAchievement(player, AdvancementManager.achMeltdown);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.plasma.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            if (resource.getFluid() == this.types[0]) {
                return this.tanks[0].fill(resource, doFill);
            }
            if (resource.getFluid() == this.types[1]) {
                return this.tanks[1].fill(resource, doFill);
            }
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == ModForgeFluids.ULTRAHOTSTEAM) {
            return this.tanks[1].drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{1, 2, 3, 4};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (i == 1 && BreederRecipes.getOutput(stack) != null) {
            return true;
        }
        return i == 3 && stack.func_77973_b() instanceof ItemFusionShield;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 2 || slot == 4;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5 - 8.0, (double)this.field_174879_c.func_177956_o() + 0.5 - 3.0, (double)this.field_174879_c.func_177952_p() + 0.5 - 8.0, (double)this.field_174879_c.func_177958_n() + 0.5 + 8.0, (double)this.field_174879_c.func_177956_o() + 0.5 + 3.0, (double)this.field_174879_c.func_177952_p() + 0.5 + 8.0);
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 3) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
            this.plasma.readFromNBT(tags[2]);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

