/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.CombinationRecipes;
import com.hbm.inventory.container.ContainerFurnaceCombo;
import com.hbm.inventory.gui.GUIFurnaceCombo;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.MainRegistry;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityFurnaceCombination
extends TileEntityMachineBase
implements IGUIProvider,
IFluidHandler,
ITickable,
ITankPacketAcceptor {
    public boolean wasOn;
    public int progress;
    public static final int processTime = 20000;
    public int heat;
    public static final int maxHeat = 100000;
    public static final double diffusion = 0.25;
    public FluidTank tank = new FluidTank(24000);
    AxisAlignedBB bb = null;

    public TileEntityFurnaceCombination() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.furnaceCombination";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tryPullHeat();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (int i = 2; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.getOrientation(i);
                    ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                    for (int y = this.field_174879_c.func_177956_o(); y <= this.field_174879_c.func_177956_o() + 1; ++y) {
                        for (int j = -1; j <= 1; ++j) {
                            if (this.tank.getFluidAmount() <= 0) continue;
                            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 2 + rot.offsetX * j, 0, dir.offsetZ * 2 + rot.offsetZ * j), 8000);
                        }
                    }
                }
            }
            this.wasOn = false;
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 2, 3);
            if (this.canSmelt()) {
                int burn = this.heat / 100;
                if (burn > 0) {
                    this.wasOn = true;
                    this.progress += burn;
                    this.heat -= burn;
                    if (this.progress >= 20000) {
                        this.func_70296_d();
                        this.progress -= 20000;
                        Tuple.Pair<ItemStack, FluidStack> pair = CombinationRecipes.getOutput(this.inventory.getStackInSlot(0));
                        ItemStack out = pair.getKey();
                        FluidStack fluid = pair.getValue();
                        if (out != null && !out.func_190926_b()) {
                            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                                this.inventory.setStackInSlot(1, out.func_77946_l());
                            } else {
                                this.inventory.getStackInSlot(1).func_190917_f(out.func_190916_E());
                            }
                        }
                        if (fluid != null) {
                            this.tank.fill(fluid.copy(), true);
                        }
                        this.inventory.getStackInSlot(0).func_190918_g(1);
                        if (this.inventory.getStackInSlot(0).func_190926_b()) {
                            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                    }
                    List entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.5, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() - 0.5, (double)this.field_174879_c.func_177958_n() + 1.5, (double)(this.field_174879_c.func_177956_o() + 4), (double)this.field_174879_c.func_177952_p() + 1.5));
                    for (Entity e : entities) {
                        e.func_70015_d(5);
                    }
                    if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c.func_177984_a(), HBMSoundHandler.flamethrowerShoot, SoundCategory.BLOCKS, 0.25f, 0.5f);
                    }
                }
            } else {
                this.progress = 0;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 120.0));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("heat", this.heat);
            data.func_74757_a("wasOn", this.wasOn);
            this.networkPack(data, 50);
        } else if (this.wasOn) {
            if (this.field_145850_b.field_73012_v.nextInt(15) == 0) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.field_174879_c.func_177958_n() + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "rbmkflame");
                data.func_74768_a("maxAge", 300);
                data.func_74776_a("scale", 0.5f);
                data.func_74780_a("posX", (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble());
                data.func_74780_a("posY", (double)this.field_174879_c.func_177956_o() + 1.95);
                data.func_74780_a("posZ", (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble());
                MainRegistry.proxy.effectNT(data);
            }
        }
    }

    public boolean canSmelt() {
        ItemStack outSlotStack;
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        Tuple.Pair<ItemStack, FluidStack> pair = CombinationRecipes.getOutput(this.inventory.getStackInSlot(0));
        if (pair == null) {
            return false;
        }
        ItemStack out = pair.getKey();
        FluidStack fluid = pair.getValue();
        if (out != null && !out.func_190926_b() && !(outSlotStack = this.inventory.getStackInSlot(1)).func_190926_b()) {
            if (!out.func_77969_a(outSlotStack)) {
                return false;
            }
            if (out.func_190916_E() + outSlotStack.func_190916_E() > outSlotStack.func_77976_d()) {
                return false;
            }
        }
        if (fluid != null && this.tank.getFluid() != null) {
            if (this.tank.getFluid().getFluid() != fluid.getFluid()) {
                return this.tank.getFluidAmount() <= 0;
            }
            return this.tank.getFluidAmount() + fluid.amount <= this.tank.getCapacity();
        }
        return true;
    }

    protected void tryPullHeat() {
        if (this.heat >= 100000) {
            return;
        }
        TileEntity con = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * 0.25);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > 100000) {
                    this.heat = 100000;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing side) {
        return new int[]{0, 1};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        return i == 0 && CombinationRecipes.getOutput(itemStack) != null;
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i == 1;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.progress = nbt.func_74762_e("prog");
        this.heat = nbt.func_74762_e("heat");
        super.func_145839_a(nbt);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("prog", this.progress);
        nbt.func_74768_a("heat", this.heat);
        return super.func_189515_b(nbt);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFurnaceCombo(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFurnaceCombo(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)this.field_174879_c.func_177956_o() + 2.125, (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.wasOn = data.func_74767_n("wasOn");
        this.heat = data.func_74762_e("heat");
        this.progress = data.func_74762_e("progress");
    }
}

