/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.ICrucibleAcceptor;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.lib.ForgeDirection;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityFoundryBase;
import com.hbm.util.CrucibleUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityFoundryOutlet
extends TileEntityFoundryBase {
    public NTMMaterial filter = null;
    public NTMMaterial lastFilter = null;
    public boolean invertFilter = false;
    public boolean invertRedstone = false;
    public boolean lastClosed = false;

    public boolean isClosed() {
        return this.invertRedstone ^ this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
    }

    @Override
    public void func_73660_a() {
        boolean isClosed;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && (this.lastClosed != (isClosed = this.isClosed()) || this.filter != this.lastFilter)) {
            this.lastFilter = this.filter;
            this.lastClosed = isClosed;
        }
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return false;
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return stack;
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        RayTraceResult[] mop;
        Vec3d end;
        if (this.filter != null && this.filter != stack.material ^ this.invertFilter) {
            return false;
        }
        if (this.isClosed()) {
            return false;
        }
        if (side != ForgeDirection.getOrientation(this.func_145832_p()).getOpposite()) {
            return false;
        }
        Vec3d start = new Vec3d((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() - 0.125, (double)p.func_177952_p() + 0.5);
        ICrucibleAcceptor acc = CrucibleUtil.getPouringTarget(world, start, end = new Vec3d((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.125 - 4.0, (double)p.func_177952_p() + 0.5), mop = new RayTraceResult[1]);
        if (acc == null) {
            return false;
        }
        return acc.canAcceptPartialPour(world, mop[0].func_178782_a(), mop[0].field_72307_f.field_72450_a, mop[0].field_72307_f.field_72448_b, mop[0].field_72307_f.field_72449_c, ForgeDirection.UP, stack);
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        RayTraceResult[] mop;
        Vec3d end;
        Vec3d start = new Vec3d((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() - 0.125, (double)p.func_177952_p() + 0.5);
        ICrucibleAcceptor acc = CrucibleUtil.getPouringTarget(world, start, end = new Vec3d((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.125 - 4.0, (double)p.func_177952_p() + 0.5), mop = new RayTraceResult[1]);
        if (acc == null) {
            return stack;
        }
        Mats.MaterialStack didPour = acc.pour(world, mop[0].func_178782_a(), mop[0].field_72307_f.field_72450_a, mop[0].field_72307_f.field_72448_b, mop[0].field_72307_f.field_72449_c, ForgeDirection.UP, stack);
        if (stack != null) {
            ForgeDirection dir = side.getOpposite();
            double hitY = mop[0].func_178782_a().func_177956_o() + 1;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "foundry");
            data.func_74768_a("color", stack.material.moltenColor);
            data.func_74774_a("dir", (byte)dir.ordinal());
            data.func_74776_a("off", 0.375f);
            data.func_74776_a("base", 0.0f);
            data.func_74776_a("len", Math.max(1.0f, (float)p.func_177956_o() - (float)(Math.ceil(hitY) - 0.875)));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)p.func_177958_n() + 0.5 - (double)dir.offsetX * 0.125, (double)p.func_177956_o() + 0.125, (double)p.func_177952_p() + 0.5 - (double)dir.offsetZ * 0.125), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)p.func_177958_n() + 0.5, (double)p.func_177956_o(), (double)p.func_177952_p() + 0.5, 50.0));
        }
        return didPour;
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.invertRedstone = nbt.func_74767_n("invert");
        this.invertFilter = nbt.func_74767_n("invertFilter");
        this.filter = Mats.matById.get(nbt.func_74765_d("filter"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("invert", this.invertRedstone);
        nbt.func_74757_a("invertFilter", this.invertFilter);
        nbt.func_74777_a("filter", this.filter == null ? (short)-1 : (short)this.filter.id);
        return super.func_189515_b(nbt);
    }
}

