/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMold;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.ItemStackHandlerWrapper;
import com.hbm.tileentity.machine.TileEntityFoundryBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityFoundryCastingBase
extends TileEntityFoundryBase {
    public ItemStackHandler inventory;
    public int cooloff = 100;

    public TileEntityFoundryCastingBase(int slotCount) {
        this.inventory = this.getNewInventory(slotCount);
    }

    public ItemStackHandler getNewInventory(int scount) {
        return new ItemStackHandler(scount){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityFoundryCastingBase.this.func_70296_d();
            }
        };
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemMold.Mold mold;
            if (this.amount > this.getCapacity()) {
                this.amount = this.getCapacity();
            }
            if (this.amount == 0) {
                this.type = null;
            }
            if ((mold = this.getInstalledMold()) != null && this.amount == this.getCapacity() && this.inventory.getStackInSlot(1).func_190926_b()) {
                --this.cooloff;
                if (this.cooloff <= 0) {
                    this.amount = 0;
                    ItemStack out = mold.getOutput(this.type);
                    if (out != null && !out.func_190926_b()) {
                        this.inventory.setStackInSlot(1, out.func_77946_l());
                    }
                    this.cooloff = 200;
                    this.func_70296_d();
                }
            } else {
                this.cooloff = 200;
            }
        }
    }

    @Override
    protected boolean shouldClientReRender() {
        return false;
    }

    public ItemMold.Mold getInstalledMold() {
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return null;
        }
        if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.mold) {
            ItemMold.Mold mold = ((ItemMold)this.inventory.getStackInSlot(0).func_77973_b()).getMold(this.inventory.getStackInSlot(0));
            if (mold.size == this.getMoldSize()) {
                return mold;
            }
        }
        return null;
    }

    @Override
    public int getCapacity() {
        ItemMold.Mold mold = this.getInstalledMold();
        return mold == null ? 0 : mold.getCost();
    }

    @Override
    public boolean standardCheck(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        if (!super.standardCheck(world, p, side, stack)) {
            return false;
        }
        if (!this.inventory.getStackInSlot(1).func_190926_b()) {
            return false;
        }
        ItemMold.Mold mold = this.getInstalledMold();
        if (mold == null) {
            return false;
        }
        return mold.getOutput(stack.material) != null;
    }

    public abstract int getMoldSize();

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int[] getAccessibleSlotsFromSide(EnumFacing face) {
        return new int[]{1};
    }

    public boolean canInsertItem(int slot, ItemStack stack, int amount) {
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int amount) {
        return slot == 1;
    }

    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemStackHandlerWrapper(this.inventory, this.getAccessibleSlotsFromSide(facing)){

                @Override
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (TileEntityFoundryCastingBase.this.canExtractItem(slot, TileEntityFoundryCastingBase.this.inventory.getStackInSlot(slot), amount)) {
                        return super.extractItem(slot, amount, simulate);
                    }
                    return ItemStack.field_190927_a;
                }

                @Override
                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (TileEntityFoundryCastingBase.this.canInsertItem(slot, stack, stack.func_190916_E())) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }
            });
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null || super.hasCapability(capability, facing);
    }
}

