/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.tile.IHeatSource;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.CrucibleRecipes;
import com.hbm.inventory.container.ContainerCrucible;
import com.hbm.inventory.gui.GUICrucible;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.CrucibleUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntityCrucible
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
ICrucibleAcceptor,
IConfigurableMachine {
    public int heat;
    public int progress;
    public List<Mats.MaterialStack> recipeStack = new ArrayList<Mats.MaterialStack>();
    public List<Mats.MaterialStack> wasteStack = new ArrayList<Mats.MaterialStack>();
    public static int recipeZCapacity = MaterialShapes.BLOCK.q(16);
    public static int wasteZCapacity = MaterialShapes.BLOCK.q(16);
    public static int processTime = 20000;
    public static double diffusion = 0.25;
    public static int maxHeat = 100000;
    AxisAlignedBB bb = null;

    public TileEntityCrucible() {
        super(10, 1);
    }

    @Override
    public String getName() {
        return "container.machineCrucible";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Mats.MaterialStack sta;
            int i;
            ForgeDirection dir;
            this.tryPullHeat();
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                List list = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() - 0.5, (double)this.field_174879_c.func_177958_n() + 1.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 1.5));
                EntityItem itemE = null;
                for (int i2 = 1; i2 < 10; ++i2) {
                    if (itemE == null) {
                        for (EntityItem entity : list) {
                            if (!this.isItemSmeltable(entity.func_92059_d())) continue;
                            itemE = entity;
                            break;
                        }
                    }
                    if (itemE == null) break;
                    if (!this.inventory.getStackInSlot(i2).func_190926_b()) continue;
                    Mats.MaterialStack stack = itemE.func_92059_d();
                    if (stack.func_190916_E() == 1) {
                        this.inventory.setStackInSlot(i2, stack.func_77946_l());
                        list.remove(itemE);
                        itemE.func_70106_y();
                        break;
                    }
                    ItemStack cStack = stack.func_77946_l();
                    cStack.func_190920_e(1);
                    this.inventory.setStackInSlot(i2, cStack);
                    stack.func_190918_g(1);
                    this.func_70296_d();
                }
            }
            int totalCap = recipeZCapacity + wasteZCapacity;
            int totalMass = 0;
            for (Mats.MaterialStack stack : this.recipeStack) {
                totalMass += stack.amount;
            }
            for (Mats.MaterialStack stack : this.wasteStack) {
                totalMass += stack.amount;
            }
            double level = (double)totalMass / (double)totalCap * 0.875;
            List living = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() - 0.5, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o() + 0.5 + level, (double)this.field_174879_c.func_177952_p() + 1.5));
            for (EntityLivingBase entity : living) {
                entity.func_70097_a(DamageSource.field_76371_c, 5.0f);
                entity.func_70015_d(5);
            }
            if (!this.trySmelt()) {
                this.progress = 0;
            }
            this.tryRecipe();
            if (!this.wasteStack.isEmpty()) {
                dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getOpposite();
                Vec3 impact = Vec3.createVectorHelper(0.0, 0.0, 0.0);
                Mats.MaterialStack didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 1.875, (double)this.field_174879_c.func_177956_o() + 0.25, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 1.875, 6.0, true, this.wasteStack, MaterialShapes.NUGGET.q(3), impact);
                if (didPour != null) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)this.field_174879_c.func_177956_o() - (float)(Math.ceil(impact.yCoord) - 0.875)));
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 1.875, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 1.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 50.0));
                }
            }
            if (!this.recipeStack.isEmpty()) {
                dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
                ArrayList<Mats.MaterialStack> toCast = new ArrayList<Mats.MaterialStack>();
                CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
                if (recipe == null) {
                    toCast.addAll(this.recipeStack);
                } else {
                    block5: for (Mats.MaterialStack stack : this.recipeStack) {
                        for (Mats.MaterialStack output : recipe.output) {
                            if (stack.material != output.material) continue;
                            toCast.add(stack);
                            continue block5;
                        }
                    }
                }
                Vec3 impact = Vec3.createVectorHelper(0.0, 0.0, 0.0);
                Mats.MaterialStack didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 1.875, (double)this.field_174879_c.func_177956_o() + 0.25, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 1.875, 6.0, true, toCast, MaterialShapes.NUGGET.q(3), impact);
                if (didPour != null) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)this.field_174879_c.func_177956_o() - (float)(Math.ceil(impact.yCoord) - 0.875)));
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 1.875, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 1.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 50.0));
                }
            }
            this.recipeStack.removeIf(o -> o.amount <= 0);
            this.wasteStack.removeIf(x -> x.amount <= 0);
            NBTTagCompound data = new NBTTagCompound();
            int[] rec = new int[this.recipeStack.size() * 2];
            int[] was = new int[this.wasteStack.size() * 2];
            for (i = 0; i < this.recipeStack.size(); ++i) {
                sta = this.recipeStack.get(i);
                rec[i * 2] = sta.material.id;
                rec[i * 2 + 1] = sta.amount;
            }
            for (i = 0; i < this.wasteStack.size(); ++i) {
                sta = this.wasteStack.get(i);
                was[i * 2] = sta.material.id;
                was[i * 2 + 1] = sta.amount;
            }
            data.func_74783_a("rec", rec);
            data.func_74783_a("was", was);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("heat", this.heat);
            this.networkPack(data, 25);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.recipeStack.clear();
        this.wasteStack.clear();
        int[] rec = nbt.func_74759_k("rec");
        for (int i = 0; i < rec.length >> 1; ++i) {
            this.recipeStack.add(new Mats.MaterialStack(Mats.matById.get(rec[i * 2]), rec[i * 2 + 1]));
        }
        int[] was = nbt.func_74759_k("was");
        for (int i = 0; i < was.length >> 1; ++i) {
            this.wasteStack.add(new Mats.MaterialStack(Mats.matById.get(was[i * 2]), was[i * 2 + 1]));
        }
        this.progress = nbt.func_74762_e("progress");
        this.heat = nbt.func_74762_e("heat");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] rec = nbt.func_74759_k("rec");
        for (int i = 0; i < rec.length >> 1; ++i) {
            this.recipeStack.add(new Mats.MaterialStack(Mats.matById.get(rec[i * 2]), rec[i * 2 + 1]));
        }
        int[] was = nbt.func_74759_k("was");
        for (int i = 0; i < was.length >> 1; ++i) {
            this.wasteStack.add(new Mats.MaterialStack(Mats.matById.get(was[i * 2]), was[i * 2 + 1]));
        }
        this.progress = nbt.func_74762_e("progress");
        this.heat = nbt.func_74762_e("heat");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        Mats.MaterialStack sta;
        int i;
        int[] rec = new int[this.recipeStack.size() * 2];
        int[] was = new int[this.wasteStack.size() * 2];
        for (i = 0; i < this.recipeStack.size(); ++i) {
            sta = this.recipeStack.get(i);
            rec[i * 2] = sta.material.id;
            rec[i * 2 + 1] = sta.amount;
        }
        for (i = 0; i < this.wasteStack.size(); ++i) {
            sta = this.wasteStack.get(i);
            was[i * 2] = sta.material.id;
            was[i * 2 + 1] = sta.amount;
        }
        nbt.func_74783_a("rec", rec);
        nbt.func_74783_a("was", was);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("heat", this.heat);
        return super.func_189515_b(nbt);
    }

    protected void tryPullHeat() {
        if (this.heat >= maxHeat) {
            return;
        }
        TileEntity con = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * diffusion);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > maxHeat) {
                    this.heat = maxHeat;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    protected boolean trySmelt() {
        if (this.heat < maxHeat >> 1) {
            return false;
        }
        int slot = this.getFirstSmeltableSlot();
        if (slot == -1) {
            return false;
        }
        int delta = this.heat - maxHeat / 2;
        delta = (int)((double)delta * 0.05);
        this.progress += delta;
        this.heat -= delta;
        if (this.progress >= processTime) {
            this.progress = 0;
            List<Mats.MaterialStack> materials = Mats.getSmeltingMaterialsFromItem(this.inventory.getStackInSlot(slot));
            CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
            for (Mats.MaterialStack material : materials) {
                boolean mainStack;
                boolean bl = mainStack = recipe != null && (this.getQuantaFromType(recipe.input, material.material) > 0 || this.getQuantaFromType(recipe.output, material.material) > 0);
                if (mainStack) {
                    this.addToStack(this.recipeStack, material);
                    continue;
                }
                this.addToStack(this.wasteStack, material);
            }
            this.inventory.getStackInSlot(slot).func_190918_g(1);
        }
        return true;
    }

    protected void tryRecipe() {
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        if (recipe == null) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % (long)recipe.frequency > 0L) {
            return;
        }
        for (Mats.MaterialStack stack : recipe.input) {
            if (this.getQuantaFromType(this.recipeStack, stack.material) >= stack.amount) continue;
            return;
        }
        for (Mats.MaterialStack stack : this.recipeStack) {
            stack.amount -= this.getQuantaFromType(recipe.input, stack.material);
        }
        block2: for (Mats.MaterialStack out : recipe.output) {
            for (Mats.MaterialStack stack : this.recipeStack) {
                if (stack.material != out.material) continue;
                stack.amount += out.amount;
                continue block2;
            }
            this.recipeStack.add(out.copy());
        }
    }

    protected int getFirstSmeltableSlot() {
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!this.isItemSmeltable(stack)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 0) {
            return stack.func_77973_b() == ModItems.crucible_template;
        }
        return this.isItemSmeltable(stack);
    }

    public boolean isItemSmeltable(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        List<Mats.MaterialStack> materials = Mats.getSmeltingMaterialsFromItem(stack);
        if (materials.isEmpty()) {
            return false;
        }
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        int recipeContent = recipe != null ? recipe.getInputAmount() : 0;
        int recipeAmount = this.getQuantaFromType(this.recipeStack, null);
        int wasteAmount = this.getQuantaFromType(this.wasteStack, null);
        for (Mats.MaterialStack mat : materials) {
            int recipeInputRequired;
            int n = recipeInputRequired = recipe != null ? this.getQuantaFromType(recipe.input, mat.material) : 0;
            if (recipe != null && this.getQuantaFromType(recipe.output, mat.material) > 0) {
                recipeAmount += mat.amount;
                continue;
            }
            if (recipeInputRequired == 0) {
                wasteAmount += mat.amount;
                continue;
            }
            int matMaximum = recipeInputRequired * recipeZCapacity / recipeContent;
            int amountStored = this.getQuantaFromType(this.recipeStack, mat.material);
            recipeAmount += mat.amount;
            if (amountStored + mat.amount <= matMaximum) continue;
            return false;
        }
        return recipeAmount <= recipeZCapacity && wasteAmount <= wasteZCapacity;
    }

    public void addToStack(List<Mats.MaterialStack> stack, Mats.MaterialStack matStack) {
        for (Mats.MaterialStack mat : stack) {
            if (mat.material != matStack.material) continue;
            mat.amount += matStack.amount;
            return;
        }
        stack.add(matStack.copy());
    }

    public CrucibleRecipes.CrucibleRecipe getLoadedRecipe() {
        if (!this.inventory.getStackInSlot(0).func_190926_b() && this.inventory.getStackInSlot(0).func_77973_b() == ModItems.crucible_template) {
            return CrucibleRecipes.recipes.get(this.inventory.getStackInSlot(0).func_77952_i());
        }
        return null;
    }

    public int getQuantaFromType(Mats.MaterialStack[] stacks, NTMMaterial mat) {
        for (Mats.MaterialStack stack : stacks) {
            if (mat != null && stack.material != mat) continue;
            return stack.amount;
        }
        return 0;
    }

    public int getQuantaFromType(List<Mats.MaterialStack> stacks, NTMMaterial mat) {
        int sum = 0;
        for (Mats.MaterialStack stack : stacks) {
            if (stack.material == mat) {
                return stack.amount;
            }
            if (mat != null) continue;
            sum += stack.amount;
        }
        return sum;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCrucible(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICrucible(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        if (recipe == null) {
            return this.getQuantaFromType(this.wasteStack, null) < wasteZCapacity;
        }
        int recipeContent = recipe.getInputAmount();
        int recipeInputRequired = this.getQuantaFromType(recipe.input, stack.material);
        int matMaximum = recipeInputRequired * recipeZCapacity / recipeContent;
        int amountStored = this.getQuantaFromType(this.recipeStack, stack.material);
        return amountStored < matMaximum && this.getQuantaFromType(this.recipeStack, null) < recipeZCapacity;
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        int matMaximum;
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        if (recipe == null) {
            int amount = this.getQuantaFromType(this.wasteStack, null);
            if (amount + stack.amount <= wasteZCapacity) {
                this.addToStack(this.wasteStack, stack.copy());
                return null;
            }
            int toAdd = wasteZCapacity - amount;
            this.addToStack(this.wasteStack, new Mats.MaterialStack(stack.material, toAdd));
            return new Mats.MaterialStack(stack.material, stack.amount - toAdd);
        }
        int recipeContent = recipe.getInputAmount();
        int recipeInputRequired = this.getQuantaFromType(recipe.input, stack.material);
        if (recipeInputRequired + stack.amount <= (matMaximum = recipeInputRequired * recipeZCapacity / recipeContent)) {
            this.addToStack(this.recipeStack, stack.copy());
            return null;
        }
        int toAdd = matMaximum - stack.amount;
        toAdd = Math.min(toAdd, recipeZCapacity - this.getQuantaFromType(this.recipeStack, null));
        this.addToStack(this.recipeStack, new Mats.MaterialStack(stack.material, toAdd));
        return new Mats.MaterialStack(stack.material, stack.amount - toAdd);
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return false;
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return null;
    }

    @Override
    public String getConfigName() {
        return "crucible";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        recipeZCapacity = IConfigurableMachine.grab(obj, "I:recipeCapacity", recipeZCapacity);
        wasteZCapacity = IConfigurableMachine.grab(obj, "I:wasteCapacity", wasteZCapacity);
        processTime = IConfigurableMachine.grab(obj, "I:processHeat", processTime);
        diffusion = IConfigurableMachine.grab(obj, "D:diffusion", diffusion);
        maxHeat = IConfigurableMachine.grab(obj, "I:heatCap", maxHeat);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:recipeCapacity").value((long)recipeZCapacity);
        writer.name("I:wasteCapacity").value((long)wasteZCapacity);
        writer.name("I:processHeat").value((long)processTime);
        writer.name("D:diffusion").value(diffusion);
        writer.name("I:heatCap").value((long)maxHeat);
    }
}

