/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.ILaserable;
import com.hbm.inventory.DFCRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemKeyPin;
import com.hbm.items.weapon.ItemCrucible;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxParticlePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.quark.api.IDropoffManager;

@Optional.InterfaceList(value={@Optional.Interface(iface="vazkii.quark.api.IDropoffManager", modid="quark")})
public class TileEntityCrateTungsten
extends TileEntityLockableBase
implements IDropoffManager,
ITickable,
ILaserable,
INBTPacketReceiver {
    public ItemStackHandler inventory;
    private final Random rand = new Random();
    public int heatTimer = 0;
    public int age = 0;
    public long joules = 0L;

    public TileEntityCrateTungsten() {
        this.inventory = new ItemStackHandler(27){

            protected void onContentsChanged(int slot) {
                TileEntityCrateTungsten.this.func_70296_d();
            }
        };
    }

    public boolean acceptsDropoff(EntityPlayer player) {
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (!this.isLocked() || player == null) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemKeyPin && ItemKeyPin.getPins(stack) == this.lock) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (stack.func_77973_b() == ModItems.key_red) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.lockOpen, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return this.tryPick(player);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.heatTimer > 0) {
                --this.heatTimer;
            }
            if (this.heatTimer > 0) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 4), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            }
            ++this.age;
            if (this.age > 20) {
                this.networkPack();
                this.age = 0;
            }
        }
    }

    public void networkPack() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("timer", this.heatTimer);
        data.func_74772_a("spk", this.joules);
        INBTPacketReceiver.networkPack(this, data, 150);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.heatTimer = data.func_74762_e("timer");
        this.joules = data.func_74763_f("spk");
    }

    @Override
    public void addEnergy(long energy, EnumFacing dir) {
        this.heatTimer = 5;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(i));
            long requiredEnergy = DFCRecipes.getRequiredFlux(this.inventory.getStackInSlot(i));
            int count = this.inventory.getStackInSlot(i).func_190916_E();
            if ((requiredEnergy = (long)((double)requiredEnergy * 0.9)) > -1L && energy > requiredEnergy && 0.001 > (double)count * this.rand.nextDouble() * ((double)requiredEnergy / (double)energy)) {
                result = DFCRecipes.getOutput(this.inventory.getStackInSlot(i));
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.crucible && ItemCrucible.getCharges(this.inventory.getStackInSlot(i)) < 3 && energy > 10000000L) {
                ItemCrucible.charge(this.inventory.getStackInSlot(i));
            }
            if (result == null || result.func_190926_b()) continue;
            int size = this.inventory.getStackInSlot(i).func_190916_E();
            if (result.func_190916_E() * size > result.func_77976_d()) continue;
            this.inventory.setStackInSlot(i, result.func_77946_l());
            this.inventory.getStackInSlot(i).func_190920_e(this.inventory.getStackInSlot(i).func_190916_E() * size);
        }
        this.joules = energy;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_74764_b("heatTimer")) {
            this.heatTimer = compound.func_74762_e("heatTimer");
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("heatTimer", this.heatTimer);
        return super.func_189515_b(compound);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }
}

