/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ILaserable;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.AuxLongPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntityCoreEmitter
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
IFluidHandler,
ILaserable,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 1000000000L;
    public int watts = 1;
    public int beam;
    public long joules;
    public boolean isOn;
    public FluidTank tank = new FluidTank(64000);
    public long prev;
    public int prevWatts = -1;
    public static final int range = 50;

    public TileEntityCoreEmitter() {
        super(0);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            this.watts = MathHelper.func_76125_a((int)this.watts, (int)1, (int)100);
            long demand = 1000000000L * (long)this.watts / 2000L;
            this.beam = 0;
            if (this.joules > 0L || this.prev > 0L) {
                if (this.tank.getFluidAmount() >= 20) {
                    this.tank.drain(20, true);
                } else {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150356_k.func_176223_P());
                    return;
                }
            }
            if (this.isOn) {
                if (this.power >= demand) {
                    this.power -= demand;
                    long add = this.watts * 100;
                    this.joules = add > Long.MAX_VALUE - this.joules ? Long.MAX_VALUE : (this.joules += add);
                }
                this.prev = this.joules;
                if (this.joules > 0L) {
                    long out = this.joules;
                    EnumFacing dir = EnumFacing.func_82600_a((int)this.func_145832_p());
                    for (int i = 1; i <= 50; ++i) {
                        int z;
                        int y;
                        this.beam = i;
                        int x = this.field_174879_c.func_177958_n() + dir.func_82601_c() * i;
                        BlockPos pos1 = new BlockPos(x, y = this.field_174879_c.func_177956_o() + dir.func_96559_d() * i, z = this.field_174879_c.func_177952_p() + dir.func_82599_e() * i);
                        TileEntity te = this.field_145850_b.func_175625_s(pos1);
                        if (te instanceof ILaserable) {
                            ((ILaserable)te).addEnergy(out * 100L * (long)this.watts / 10000L, dir);
                            break;
                        }
                        if (te instanceof TileEntityCore) {
                            out = Math.max(0L, ((TileEntityCore)te).burn(out));
                            continue;
                        }
                        IBlockState b = this.field_145850_b.func_180495_p(pos1);
                        if (b.func_177230_c() == Blocks.field_150350_a) continue;
                        if (b.func_185904_a().func_76224_d()) {
                            this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            this.field_145850_b.func_175698_g(pos1);
                            break;
                        }
                        float hardness = b.func_177230_c().func_149638_a(null);
                        if (!(hardness < 10000.0f) || !(this.field_145850_b.field_73012_v.nextDouble() < (double)((float)out * 1.0E-8f / hardness))) break;
                        this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.field_145850_b.func_175655_b(pos1, false);
                        break;
                    }
                    double blx = (double)Math.min(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177958_n() + dir.func_82601_c() * this.beam) + 0.2;
                    double bux = (double)Math.max(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177958_n() + dir.func_82601_c() * this.beam) + 0.8;
                    double bly = (double)Math.min(this.field_174879_c.func_177956_o(), this.field_174879_c.func_177956_o() + dir.func_96559_d() * this.beam) + 0.2;
                    double buy = (double)Math.max(this.field_174879_c.func_177956_o(), this.field_174879_c.func_177956_o() + dir.func_96559_d() * this.beam) + 0.8;
                    double blz = (double)Math.min(this.field_174879_c.func_177952_p(), this.field_174879_c.func_177952_p() + dir.func_82599_e() * this.beam) + 0.2;
                    double buz = (double)Math.max(this.field_174879_c.func_177952_p(), this.field_174879_c.func_177952_p() + dir.func_82599_e() * this.beam) + 0.8;
                    List list = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(blx, bly, blz, bux, buy, buz));
                    for (Entity e : list) {
                        e.func_70097_a(ModDamageSource.amsCore, (float)this.joules * 1.0E-6f);
                        e.func_70015_d(10);
                    }
                    this.joules = 0L;
                }
            } else {
                this.joules = 0L;
                this.prev = 0L;
            }
            this.func_70296_d();
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.beam, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
            if (this.watts != this.prevWatts) {
                PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.watts, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
            }
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxLongPacket(this.field_174879_c, this.prev, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
            this.prevWatts = this.watts;
        }
    }

    @Override
    public String getName() {
        return "container.dfcEmitter";
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000000L;
    }

    public int getWattsScaled(int i) {
        return this.watts * i / 100;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000000L;
    }

    @Override
    public void addEnergy(long energy, EnumFacing dir) {
        if (dir.func_176734_d().ordinal() != this.func_145832_p()) {
            this.joules = Long.MAX_VALUE - this.joules < energy ? Long.MAX_VALUE : (this.joules += energy);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == ModForgeFluids.CRYOGEL) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.watts = compound.func_74762_e("watts");
        this.joules = compound.func_74763_f("joules");
        this.prev = compound.func_74763_f("prev");
        this.isOn = compound.func_74767_n("isOn");
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("watts", this.watts);
        compound.func_74772_a("joules", this.joules);
        compound.func_74772_a("prev", this.prev);
        compound.func_74757_a("isOn", this.isOn);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(compound);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

