/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.BlockControlPanelType;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueEnum;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.packet.ControlPanelUpdatePacket;
import com.hbm.packet.PacketDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityControlPanel
extends TileEntity
implements ITickable,
IControllable,
IControlReceiver,
SimpleComponent {
    public ItemStackHandler inventory;
    public ControlPanel panel;
    public BlockControlPanelType panelType = BlockControlPanelType.CUSTOM_PANEL;

    public TileEntityControlPanel() {
        this.inventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                TileEntityControlPanel.this.func_70296_d();
            }
        };
        this.panel = new ControlPanel(this, 0.25f, (float)Math.toRadians(20.0), 0.0f, 0.0f, 0.25f, 0.0f);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.loadClient();
        } else {
            for (Control c : this.panel.controls) {
                for (BlockPos b : c.connectedSet) {
                    ControlEventSystem.get(this.field_145850_b).subscribeTo((IControllable)this, b);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTransform() {
        boolean isUp;
        Matrix4f mat = new Matrix4f();
        boolean isDown = this.func_145832_p() >> 2 == 1;
        boolean bl = isUp = this.func_145832_p() >> 3 == 1;
        if (isUp) {
            mat.translate(new Vector3f(0.5f, this.panel.height, 0.5f));
            this.rotateByMetadata(mat, this.func_145832_p());
            mat.rotate(-this.panel.angle, new Vector3f(0.0f, 0.0f, 1.0f));
            mat.rotate((float)Math.toRadians(90.0), new Vector3f(0.0f, 1.0f, 0.0f));
        } else if (isDown) {
            mat.translate(new Vector3f(0.5f, 1.0f - this.panel.height, 0.5f));
            this.rotateByMetadata(mat, this.func_145832_p());
            mat.rotate((float)Math.toRadians(180.0), new Vector3f(1.0f, 0.0f, 0.0f));
            mat.rotate(-this.panel.angle, new Vector3f(0.0f, 0.0f, 1.0f));
            mat.rotate((float)Math.toRadians(90.0), new Vector3f(0.0f, 1.0f, 0.0f));
        } else {
            mat.translate(new Vector3f(0.5f, 0.0f, 0.5f));
            this.rotateByMetadata(mat, this.func_145832_p());
            mat.rotate((float)Math.toRadians(-90.0), new Vector3f(1.0f, 0.0f, 0.0f));
            mat.rotate((float)Math.toRadians(-90.0), new Vector3f(0.0f, 0.0f, 1.0f));
            mat.translate(new Vector3f(0.0f, this.panel.height - 0.5f, 0.5f));
            mat.rotate((float)Math.toRadians(-180.0), new Vector3f(0.0f, 1.0f, 0.0f));
            mat.rotate(this.panel.angle, new Vector3f(1.0f, 0.0f, 0.0f));
        }
        mat.scale(new Vector3f(0.1f, 0.1f, 0.1f));
        mat.translate(new Vector3f(0.5f, 0.0f, 0.5f));
        this.panel.setTransform(mat);
    }

    private void rotateByMetadata(Matrix4f mat, int meta) {
        switch ((meta & 3) + 2) {
            case 4: {
                mat.rotate((float)Math.toRadians(180.0), new Vector3f(0.0f, 1.0f, 0.0f));
                break;
            }
            case 2: {
                mat.rotate((float)Math.toRadians(90.0), new Vector3f(0.0f, 1.0f, 0.0f));
                break;
            }
            case 3: {
                mat.rotate((float)Math.toRadians(270.0), new Vector3f(0.0f, 1.0f, 0.0f));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void loadClient() {
        this.updateTransform();
    }

    public void func_73660_a() {
        this.panel.update();
        if (!this.panel.changedVars.isEmpty()) {
            this.func_70296_d();
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new ControlPanelUpdatePacket(this.field_174879_c, this.panel.changedVars), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1.0));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("panel", (NBTBase)this.panel.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.panel.readFromNBT(compound.func_74775_l("panel"));
        super.func_145839_a(compound);
    }

    @Override
    public void receiveEvent(BlockPos from, ControlEvent e) {
        this.panel.receiveEvent(from, e);
    }

    @Override
    public List<String> getInEvents() {
        return Arrays.asList("tick");
    }

    @Override
    public BlockPos getControlPos() {
        return this.func_174877_v();
    }

    @Override
    public World getControlWorld() {
        return this.func_145831_w();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return true;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("full_set")) {
            this.func_70296_d();
            for (Control c : this.panel.controls) {
                for (BlockPos b : c.connectedSet) {
                    ControlEventSystem.get(this.field_145850_b).unsubscribeFrom((IControllable)this, b);
                }
            }
            this.panel.readFromNBT(data);
            for (Control c : this.panel.controls) {
                for (BlockPos b : c.connectedSet) {
                    ControlEventSystem.get(this.field_145850_b).subscribeTo((IControllable)this, b);
                }
            }
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new ControlPanelUpdatePacket(this.field_174879_c, data), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1.0));
        } else if (data.func_74764_b("click_control")) {
            ControlEvent evt = ControlEvent.readFromNBT(data);
            this.panel.controls.get(data.func_74762_e("click_control")).receiveEvent(evt);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        ControlEventSystem.get(this.field_145850_b).addControllable(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ControlEventSystem.get(this.field_145850_b).removeControllable(this);
    }

    public float[] getBox() {
        float baseSizeX = 1.0f - (this.panel.b_off + this.panel.d_off);
        float baseSizeY = 1.0f - (this.panel.a_off + this.panel.c_off);
        double base_hyp = 1.0 / Math.cos(Math.abs(this.panel.angle));
        double panel_hyp = (double)baseSizeY / Math.cos(Math.abs(this.panel.angle));
        float box_width = 10.0f;
        float box_height = (float)(base_hyp * 10.0);
        float minX = -box_width / 2.0f + this.panel.d_off * box_width;
        float minY = -box_height / 2.0f + this.panel.a_off * box_height;
        return new float[]{minX, minY, minX + baseSizeX * 10.0f, (float)((double)minY + panel_hyp * 10.0)};
    }

    public AxisAlignedBB getBoundingBox(boolean isUp, boolean isDown, EnumFacing facing) {
        AxisAlignedBB defAABB = null;
        float height1 = ControlPanel.getSlopeHeightFromZ(1.0f - this.panel.c_off, this.panel.height, -this.panel.angle);
        float height0 = ControlPanel.getSlopeHeightFromZ(this.panel.a_off, this.panel.height, -this.panel.angle);
        defAABB = isUp ? new AxisAlignedBB((double)this.panel.d_off, 0.0, (double)this.panel.a_off, (double)(1.0f - this.panel.b_off), (double)Math.max(height0, height1), (double)(1.0f - this.panel.c_off)) : (isDown ? new AxisAlignedBB((double)(1.0f - this.panel.d_off), 1.0, (double)this.panel.a_off, (double)this.panel.b_off, (double)(1.0f - Math.max(height0, height1)), (double)(1.0f - this.panel.c_off)) : new AxisAlignedBB((double)this.panel.d_off, (double)(1.0f - this.panel.a_off), 0.0, (double)(1.0f - this.panel.b_off), (double)this.panel.c_off, (double)Math.max(height0, height1)));
        defAABB = TileEntityControlPanel.rotateAABB(defAABB, facing);
        return defAABB;
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB box, EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return new AxisAlignedBB(1.0 - box.field_72340_a, box.field_72338_b, 1.0 - box.field_72334_f, 1.0 - box.field_72336_d, box.field_72337_e, 1.0 - box.field_72339_c);
            }
            case SOUTH: {
                return box;
            }
            case EAST: {
                return new AxisAlignedBB(box.field_72339_c, box.field_72338_b, 1.0 - box.field_72340_a, box.field_72334_f, box.field_72337_e, 1.0 - box.field_72336_d);
            }
            case WEST: {
                return new AxisAlignedBB(1.0 - box.field_72339_c, box.field_72338_b, box.field_72340_a, 1.0 - box.field_72334_f, box.field_72337_e, box.field_72336_d);
            }
        }
        return box;
    }

    public String getComponentName() {
        return "control_panel";
    }

    @Callback
    public Object[] listControls(Context context, Arguments args) {
        ArrayList<String> ctrlList = new ArrayList<String>();
        for (int i = 0; i < this.panel.controls.size(); ++i) {
            ctrlList.add(this.panel.controls.get((int)i).name + " (" + i + ")");
        }
        return new Object[]{ctrlList};
    }

    @Callback
    public Object[] listGlobalVars(Context context, Arguments args) {
        return new Object[]{this.panel.globalVars};
    }

    @Callback(doc="getGlobalVar(name:str);")
    public Object[] getGlobalVar(Context context, Arguments args) {
        String name = args.checkString(0);
        DataValue value = this.panel.getVar(name);
        if (Objects.requireNonNull(value.getType()) == DataValue.DataType.NUMBER) {
            return new Object[]{Float.valueOf(value.getNumber())};
        }
        return new Object[]{value.toString()};
    }

    @Callback(doc="setGlobalVar(name:str, value:[bool,str,double,int]);")
    public Object[] setGlobalVar(Context context, Arguments args) {
        String name = args.checkString(0);
        if (args.isBoolean(1)) {
            this.panel.globalVars.put(name, new DataValueFloat(args.checkBoolean(1)));
        } else if (args.isString(1)) {
            this.panel.globalVars.put(name, new DataValueString(args.checkString(1)));
        } else if (args.isDouble(1)) {
            this.panel.globalVars.put(name, new DataValueFloat((float)args.checkDouble(1)));
        } else if (args.isInteger(1)) {
            this.panel.globalVars.put(name, new DataValueFloat(args.checkInteger(1)));
        } else {
            return new Object[]{"ERROR: unsupported value type"};
        }
        return new Object[0];
    }

    @Callback(doc="listLocalVars(ID:int); list local vars for control ID.")
    public Object[] listLocalVars(Context context, Arguments args) {
        return new Object[]{this.panel.controls.get((int)args.checkInteger((int)0)).vars};
    }

    @Callback(doc="getLocalVar(ID:int, name:str); get var for control ID.")
    public Object[] getLocalVar(Context context, Arguments args) {
        int index = args.checkInteger(0);
        String name = args.checkString(1);
        DataValue value = this.panel.controls.get(index).getVar(name);
        if (Objects.requireNonNull(value.getType()) == DataValue.DataType.NUMBER) {
            return new Object[]{Float.valueOf(value.getNumber())};
        }
        return new Object[]{value.toString()};
    }

    @Callback(doc="getLocalVar(ID:int, name:str, value:[bool,str,double,int]); set var for control ID.")
    public Object[] setLocalVar(Context context, Arguments args) {
        int index = args.checkInteger(0);
        String name = args.checkString(1);
        if (args.isBoolean(2)) {
            this.panel.controls.get((int)index).vars.put(name, new DataValueFloat(args.checkBoolean(2)));
        } else if (args.isString(2)) {
            DataValue value = this.panel.controls.get((int)index).vars.get(name);
            String newValue = args.checkString(2);
            if (value.getType().equals((Object)DataValue.DataType.ENUM)) {
                if (((DataValueEnum)value).enumClass.equals(EnumDyeColor.class)) {
                    for (EnumDyeColor c : EnumDyeColor.values()) {
                        if (!c.func_176610_l().equals(newValue)) continue;
                        this.panel.controls.get((int)index).vars.put(name, new DataValueEnum(EnumDyeColor.valueOf((String)newValue.toUpperCase())));
                        return new Object[0];
                    }
                    return new Object[]{"ERROR: '" + newValue + "' not found for EnumDyeColor"};
                }
                return new Object[]{"ERROR: unsupported enum class"};
            }
            this.panel.controls.get((int)index).vars.put(name, new DataValueString(newValue));
        } else if (args.isDouble(2)) {
            this.panel.controls.get((int)index).vars.put(name, new DataValueFloat((float)args.checkDouble(2)));
        } else if (args.isInteger(2)) {
            this.panel.controls.get((int)index).vars.put(name, new DataValueFloat(args.checkInteger(2)));
        } else {
            return new Object[]{"ERROR: unsupported value type"};
        }
        return new Object[0];
    }
}

