/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.machine.MachineCharger;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityCharger
extends TileEntityLoadedBase
implements ITickable,
IEnergyUser,
INBTPacketReceiver {
    public static final int range = 3;
    private List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    private long maxChargeRate;
    public long charge = 0L;
    public long actualCharge = 0L;
    public long totalCapacity = 0L;
    public long totalEnergy = 0L;
    private int lastOp = 0;
    public boolean isOn = false;
    public boolean pointingUp = true;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            MachineCharger c = (MachineCharger)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            this.maxChargeRate = c.maxThroughput;
            this.pointingUp = c.pointingUp;
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            this.players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + (this.pointingUp ? 3 : -3)), (double)(this.field_174879_c.func_177952_p() + 1)));
            this.totalCapacity = 0L;
            this.totalEnergy = 0L;
            this.charge = 0L;
            for (EntityPlayer player : this.players) {
                InventoryPlayer inv = player.field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null || !(stack.func_77973_b() instanceof IBatteryItem)) continue;
                    IBatteryItem battery = (IBatteryItem)stack.func_77973_b();
                    this.totalCapacity += battery.getMaxCharge(stack);
                    this.totalEnergy += battery.getCharge(stack);
                    this.charge += Math.min(battery.getMaxCharge(stack) - battery.getCharge(stack), battery.getChargeRate());
                }
            }
            boolean bl = this.isOn = this.lastOp > 0;
            if (this.isOn) {
                --this.lastOp;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("o", this.isOn);
            data.func_74757_a("u", this.pointingUp);
            data.func_74772_a("m", this.totalCapacity);
            data.func_74772_a("v", this.totalEnergy);
            data.func_74772_a("c", this.charge);
            data.func_74772_a("a", this.actualCharge);
            INBTPacketReceiver.networkPack(this, data, 50);
            this.actualCharge = 0L;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.isOn = nbt.func_74767_n("o");
        this.pointingUp = nbt.func_74767_n("u");
        this.totalCapacity = nbt.func_74763_f("m");
        this.totalEnergy = nbt.func_74763_f("v");
        this.charge = nbt.func_74763_f("c");
        this.actualCharge = nbt.func_74763_f("a");
    }

    @Override
    public long getPower() {
        return 0L;
    }

    @Override
    public long getMaxPower() {
        return Math.min(this.charge, this.maxChargeRate);
    }

    @Override
    public void setPower(long power) {
    }

    @Override
    public long transferPower(long power) {
        if (power == 0L) {
            return power;
        }
        this.actualCharge = 0L;
        long chargeBudget = this.maxChargeRate;
        for (EntityPlayer player : this.players) {
            InventoryPlayer inv = player.field_71071_by;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack;
                if (chargeBudget <= 0L || power <= 0L || (stack = inv.func_70301_a(i)) == null || !(stack.func_77973_b() instanceof IBatteryItem)) continue;
                IBatteryItem battery = (IBatteryItem)stack.func_77973_b();
                long toCharge = Math.min(battery.getMaxCharge(stack) - battery.getCharge(stack), battery.getChargeRate());
                toCharge = Math.min(toCharge, chargeBudget);
                toCharge = Math.min(toCharge, power);
                battery.chargeBattery(stack, toCharge);
                power -= toCharge;
                this.actualCharge += toCharge;
                chargeBudget -= toCharge;
                this.lastOp = 4;
            }
        }
        return power;
    }
}

